/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ecore.system.activityArchitecture;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TimeUnit implements Enumerator
{
    SEC(0, "SEC", "s"),
    MSEC(1, "MSEC", "ms"),
    USEC(2, "USEC", "us");

    public static final int SEC_VALUE = 0;
    public static final int MSEC_VALUE = 1;
    public static final int USEC_VALUE = 2;
    private static final TimeUnit[] VALUES_ARRAY;
    public static final List<TimeUnit> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TimeUnit[]{SEC, MSEC, USEC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TimeUnit get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeUnit result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeUnit getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeUnit result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeUnit get(int value) {
        switch (value) {
            case 0: {
                return SEC;
            }
            case 1: {
                return MSEC;
            }
            case 2: {
                return USEC;
            }
        }
        return null;
    }

    private TimeUnit(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

