/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.ecore.system.componentArchitecture;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPort;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.OutputPort;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.CommunicationServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ForkingServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.JoiningServiceDefinition;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.OneWayCommunicationService;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ServiceInstance;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ComponentArchitectureModelUtility extends ComponentDefinitionModelUtility {
  public static boolean servicePortsCompatible(final ServiceInstance left, final ServiceInstance right) {
    ComponentPort _port = left.getPort();
    ComponentPort _port_1 = right.getPort();
    boolean _notEquals = (!Objects.equal(_port, _port_1));
    if (_notEquals) {
      CommunicationServiceDefinition _service = ComponentDefinitionModelUtility.getService(left.getPort());
      CommunicationServiceDefinition _service_1 = ComponentDefinitionModelUtility.getService(right.getPort());
      return Objects.equal(_service, _service_1);
    }
    return false;
  }
  
  public static Iterable<ComponentPort> getAllClientPorts(final ComponentInstance instance) {
    List<ComponentPort> services = CollectionLiterals.<ComponentPort>newArrayList();
    final Function1<InputPort, Boolean> _function = (InputPort it) -> {
      OneWayCommunicationService _service = it.getService();
      return Boolean.valueOf((_service instanceof ForkingServiceDefinition));
    };
    Iterables.<ComponentPort>addAll(services, IterableExtensions.<InputPort>filter(ComponentDefinitionModelUtility.getInputPorts(instance.getComponent()), _function));
    final Function1<OutputPort, Boolean> _function_1 = (OutputPort it) -> {
      OneWayCommunicationService _service = it.getService();
      return Boolean.valueOf((_service instanceof JoiningServiceDefinition));
    };
    Iterables.<ComponentPort>addAll(services, IterableExtensions.<OutputPort>filter(ComponentDefinitionModelUtility.getOutputPorts(instance.getComponent()), _function_1));
    Iterables.<ComponentPort>addAll(services, ComponentDefinitionModelUtility.getRequestPorts(instance.getComponent()));
    return services;
  }
  
  public static Iterable<ComponentPort> getNonOptionalClientPorts(final ComponentInstance instance) {
    List<ComponentPort> services = CollectionLiterals.<ComponentPort>newArrayList();
    final Function1<InputPort, Boolean> _function = (InputPort it) -> {
      OneWayCommunicationService _service = it.getService();
      return Boolean.valueOf((_service instanceof ForkingServiceDefinition));
    };
    Iterables.<ComponentPort>addAll(services, IterableExtensions.<InputPort>filter(ComponentDefinitionModelUtility.getInputPorts(instance.getComponent()), _function));
    final Function1<OutputPort, Boolean> _function_1 = (OutputPort it) -> {
      OneWayCommunicationService _service = it.getService();
      return Boolean.valueOf((_service instanceof JoiningServiceDefinition));
    };
    Iterables.<ComponentPort>addAll(services, IterableExtensions.<OutputPort>filter(ComponentDefinitionModelUtility.getOutputPorts(instance.getComponent()), _function_1));
    Iterables.<ComponentPort>addAll(services, ComponentDefinitionModelUtility.getRequestPorts(instance.getComponent()));
    return services;
  }
  
  public static Iterable<ComponentPort> getAllServerPorts(final ComponentInstance instance) {
    List<ComponentPort> services = CollectionLiterals.<ComponentPort>newArrayList();
    final Function1<OutputPort, Boolean> _function = (OutputPort it) -> {
      OneWayCommunicationService _service = it.getService();
      return Boolean.valueOf((_service instanceof ForkingServiceDefinition));
    };
    Iterables.<ComponentPort>addAll(services, IterableExtensions.<OutputPort>filter(ComponentDefinitionModelUtility.getOutputPorts(instance.getComponent()), _function));
    final Function1<InputPort, Boolean> _function_1 = (InputPort it) -> {
      OneWayCommunicationService _service = it.getService();
      return Boolean.valueOf((_service instanceof JoiningServiceDefinition));
    };
    Iterables.<ComponentPort>addAll(services, IterableExtensions.<InputPort>filter(ComponentDefinitionModelUtility.getInputPorts(instance.getComponent()), _function_1));
    Iterables.<ComponentPort>addAll(services, ComponentDefinitionModelUtility.getAnswerPorts(instance.getComponent()));
    return services;
  }
}
