/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.builder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class CDTProjectHelpers {
    public static List<IConfiguration> getSupportedConfigurations() {
        ArrayList<IConfiguration> cfgs = new ArrayList<IConfiguration>();
        IConfiguration[] iConfigurationArray = ManagedBuildManager.getExtensionConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildPropertyValue value;
            IConfiguration cfg = iConfigurationArray[n2];
            IToolChain tc = cfg.getToolChain();
            if (tc != null && ManagedBuildManager.isPlatformOk((IToolChain)tc) && tc.isSupported() && (value = cfg.getBuildArtefactType()) != null && "org.eclipse.cdt.build.core.buildArtefactType.exe".equals(value.getId())) {
                cfgs.add(cfg);
            }
            ++n2;
        }
        return cfgs;
    }

    public static void addDefaultSettingsTo(IProject project, String activeBuildType, IProgressMonitor monitor) throws CoreException, BuildException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Set default CDT Settings", (int)100);
        CProjectNature.addCNature((IProject)project, (IProgressMonitor)subMonitor.split(20));
        CCProjectNature.addCCNature((IProject)project, (IProgressMonitor)subMonitor.split(20));
        ICProjectDescription cProjectDescription = CoreModel.getDefault().createProjectDescription(project, false);
        List<IConfiguration> supportedConfigurations = CDTProjectHelpers.getSupportedConfigurations();
        ManagedBuildManager.createBuildInfo((IResource)project);
        IManagedProject managedProject = ManagedBuildManager.createManagedProject((IResource)project, (IProjectType)supportedConfigurations.get(0).getProjectType());
        for (IConfiguration configuration : supportedConfigurations) {
            subMonitor.split(20);
            String id = ManagedBuildManager.calculateChildId((String)configuration.getId(), null);
            IConfiguration configurationClone = managedProject.createConfiguration(configuration, id);
            configurationClone.setArtifactName("${ProjName}");
            IBuilder[] iBuilderArray = ManagedBuildManager.getRealBuilders();
            int n = iBuilderArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBuilder builder = iBuilderArray[n2];
                if (builder.getId().equals("org.eclipse.smartmdsd.ui.smartmdsd.builder")) {
                    configurationClone.changeBuilder(builder, id, builder.getName());
                }
                ++n2;
            }
            configurationClone.getEditableBuilder().setParallelBuildOn(true);
            cProjectDescription.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", configurationClone.getConfigurationData());
        }
        subMonitor.split(20);
        CoreModel.getDefault().setProjectDescription(project, cProjectDescription);
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        buildInfo.setDefaultConfiguration(activeBuildType);
    }

    public static void setSmartMDSDCdtBuilderFor(IProject project) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] configs = buildInfo.getManagedProject().getConfigurations();
        boolean hasChanges = false;
        IConfiguration[] iConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            if (!config.getBuilder().getId().equals("org.eclipse.smartmdsd.ui.smartmdsd.builder")) {
                IBuilder[] iBuilderArray = ManagedBuildManager.getRealBuilders();
                int n3 = iBuilderArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBuilder builder = iBuilderArray[n4];
                    if (builder.getId().equals("org.eclipse.smartmdsd.ui.smartmdsd.builder")) {
                        String id = ManagedBuildManager.calculateChildId((String)config.getId(), null);
                        config.changeBuilder(builder, id, builder.getName());
                        hasChanges = true;
                        try {
                            config.getEditableBuilder().setParallelBuildOn(true);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (hasChanges) {
            ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        }
    }

    public static void resetDefaultCdtBuilderFor(IProject project) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] configs = buildInfo.getManagedProject().getConfigurations();
        boolean hasChanges = false;
        IConfiguration[] iConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            if (!config.getBuilder().getId().equals("org.eclipse.smartmdsd.ui.smartmdsd.builder")) {
                IBuilder[] iBuilderArray = ManagedBuildManager.getRealBuilders();
                int n3 = iBuilderArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBuilder builder = iBuilderArray[n4];
                    if (builder.getId().startsWith("cdt.managedbuild.")) {
                        String id = ManagedBuildManager.calculateChildId((String)config.getId(), null);
                        config.changeBuilder(builder, id, builder.getName());
                        hasChanges = true;
                        try {
                            config.getEditableBuilder().setParallelBuildOn(false);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (hasChanges) {
            ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        }
    }

    public static void setDefaultCppIncludesFor(IProject project, boolean useKernelIncludes) throws CoreException {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription projectDescription = mngr.getProjectDescription(project);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = projectDescription.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription configDescription = iCConfigurationDescriptionArray[n2];
            ICFolderDescription projectRoot = configDescription.getRootFolderDescription();
            ICLanguageSetting[] iCLanguageSettingArray = projectRoot.getLanguageSettings();
            int n3 = iCLanguageSettingArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ICLanguageSetting setting = iCLanguageSettingArray[n4];
                String languageId = setting.getLanguageId();
                if (languageId != null && languageId.equals("org.eclipse.cdt.core.g++")) {
                    List includePathSettings = setting.getSettingEntriesList(1);
                    String aceInclude = "${ACE_ROOT}";
                    includePathSettings.add(new CIncludePathEntry(aceInclude, 4));
                    String smartInclude = "${SMART_ROOT_ACE}/include";
                    includePathSettings.add(new CIncludePathEntry(smartInclude, 4));
                    if (useKernelIncludes) {
                        String apiInclude = "${SMART_ROOT_ACE}/include/SmartSoft_CD_API";
                        includePathSettings.add(new CIncludePathEntry(apiInclude, 4));
                        String kernelInclude = "${SMART_ROOT_ACE}/include/AceSmartSoftKernel";
                        includePathSettings.add(new CIncludePathEntry(kernelInclude, 4));
                        String kernelMWInclude = "${SMART_ROOT_ACE}/include/AceSmartSoftKernel/middlewareMapping";
                        includePathSettings.add(new CIncludePathEntry(kernelMWInclude, 4));
                    }
                    includePathSettings.add(new CIncludePathEntry("smartsoft/src", 8));
                    includePathSettings.add(new CIncludePathEntry("smartsoft/src-gen", 8));
                    setting.setSettingEntries(1, includePathSettings);
                }
                ++n4;
            }
            ++n2;
        }
        CoreModel.getDefault().setProjectDescription(project, projectDescription);
    }
}

