/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.smartmdsd.ui.Activator;

public class CMakeLauncher
implements ILaunchConfigurationDelegate {
    public static final String LAUNCHER_ID = "org.eclipse.smartmdsd.ui.launch.cmake";
    public static final String ATTR_PROJECT_NAME = "org.eclipse.smartmdsd.ui.launch.cmake.projectName";
    public static final String ATTR_WORKING_DIR = "org.eclipse.smartmdsd.ui.launch.cmake.rootWorkingDir";
    public static final String ATTR_CMAKE_COMMAND = "org.eclipse.smartmdsd.ui.launch.cmake.cmakeCommand";
    public static final String ATTR_CMAKE_PARAMETER = "org.eclipse.smartmdsd.ui.launch.cmake.cmakeParameter";
    public static final String ATTR_CMAKE_BUILD_TYPE = "org.eclipse.smartmdsd.ui.launch.cmake.cmakeBuildType";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String projectName = configuration.getAttribute(ATTR_PROJECT_NAME, "");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists() && project.isOpen()) {
            String generatorFolderName = Activator.getDefault().getPreferenceStore().getString("GeneratorFolderName");
            String buildFolderName = Activator.getDefault().getPreferenceStore().getString("BuildFolderName");
            String defaultWorkingDir = String.valueOf(generatorFolderName) + "/" + buildFolderName;
            String workingDirString = configuration.getAttribute(ATTR_WORKING_DIR, defaultWorkingDir);
            IFolder workingDir = project.getFolder((IPath)new Path(workingDirString));
            if (workingDir.exists()) {
                String defaultCmakeCommand = Activator.getDefault().getPreferenceStore().getString("CMakeCommand");
                String cmakeCommand = configuration.getAttribute(ATTR_CMAKE_COMMAND, defaultCmakeCommand);
                String cmakeParameters = configuration.getAttribute(ATTR_CMAKE_PARAMETER, "..");
                String resolvedCmakeCommand = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(cmakeCommand);
                ArrayList<String> command_list = new ArrayList<String>();
                command_list.add(resolvedCmakeCommand);
                String defaultCmakeBuildType = Activator.getDefault().getPreferenceStore().getString("CMakeBuildType");
                String cmakeBuildType = configuration.getAttribute(ATTR_CMAKE_BUILD_TYPE, defaultCmakeBuildType);
                command_list.add("-DCMAKE_BUILD_TYPE=" + cmakeBuildType);
                command_list.add("-DBUILD_DEPENDENCIES=OFF");
                String ros_distro_dir = Activator.getDefault().getPreferenceStore().getString("ROSDistributionDir");
                File ros_dir = new File(ros_distro_dir);
                if (ros_dir.exists()) {
                    command_list.add("-DCMAKE_PREFIX_PATH=" + ros_dir.getPath());
                }
                command_list.add(cmakeParameters);
                String[] commands = new String[command_list.size()];
                commands = command_list.toArray(commands);
                Process cmakeProcess = DebugPlugin.exec((String[])commands, (File)workingDir.getLocation().toFile(), (String[])this.calculateEnvironmentVariables(project, ros_dir));
                String processLabel = cmakeBuildType;
                DebugPlugin.newProcess((ILaunch)launch, (Process)cmakeProcess, (String)processLabel);
                try {
                    cmakeProcess.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String[] calculateEnvironmentVariables(IProject project, File ros_dir) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        Map environment = manager.getNativeEnvironment();
        Integer index = 0;
        int env_size = environment.size();
        if (ros_dir.exists()) {
            env_size += 3;
        }
        String[] environmentVariables = new String[env_size];
        String workspacePath = project.getWorkspace().getRoot().getLocation().toOSString();
        for (Map.Entry entry : environment.entrySet()) {
            environmentVariables[index.intValue()] = ((String)entry.getKey()).contentEquals("SMART_PACKAGE_PATH") ? String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue() + ":" + workspacePath : (((String)entry.getKey()).equals("PATH") && ros_dir.exists() ? String.valueOf((String)entry.getKey()) + "=" + ros_dir.getPath() + "/bin:" + (String)entry.getValue() : String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
            index = index + 1;
        }
        if (ros_dir.exists()) {
            Integer n = index;
            index = n + 1;
            environmentVariables[n.intValue()] = "ROS_ROOT=" + ros_dir.getPath() + "/share/ros";
            Integer n2 = index;
            index = n2 + 1;
            environmentVariables[n2.intValue()] = "ROS_PACKAGE_PATH=" + ros_dir.getPath() + "/share";
            Integer n3 = index;
            index = n3 + 1;
            environmentVariables[n3.intValue()] = "PYTHONPATH=" + ros_dir.getPath() + "/lib/python2.7/dist-packages";
        }
        return environmentVariables;
    }
}

