/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.builder;

import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.smartmdsd.ui.Activator;

public class SmartMDSDManagedBuildConfigurator
implements IManagedBuilderMakefileGenerator {
    public static final String BUILDER_ID = "org.eclipse.smartmdsd.ui.smartmdsd.builder";
    private IProject project = null;
    private IPath buildWorkingDir = null;
    private String generatorFolderName = "";
    private String buildFolderName = "";
    private String buildConfigurationName = "";

    public void generateDependencies() throws CoreException {
        this.regenerateDependencies(false);
    }

    public MultiStatus generateMakefiles(IResourceDelta delta) throws CoreException {
        return this.regenerateMakefiles();
    }

    public IPath getBuildWorkingDir() {
        return this.buildWorkingDir;
    }

    public String getMakefileName() {
        return "Makefile";
    }

    public void initialize(IProject project, IManagedBuildInfo info, IProgressMonitor monitor) {
        this.project = project;
        this.generatorFolderName = Activator.getDefault().getPreferenceStore().getString("GeneratorFolderName");
        this.buildFolderName = Activator.getDefault().getPreferenceStore().getString("BuildFolderName");
        this.buildWorkingDir = new Path(String.valueOf(this.generatorFolderName) + "/" + this.buildFolderName);
        this.buildConfigurationName = info.getConfigurationName();
    }

    public boolean isGeneratedResource(IResource resource) {
        if (resource != null) {
            return resource.isDerived();
        }
        return false;
    }

    public void regenerateDependencies(boolean force) throws CoreException {
    }

    public MultiStatus regenerateMakefiles() throws CoreException {
        MultiStatus status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, "", null);
        if (this.project == null) {
            return status;
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        final ILaunchConfigurationType cmakeLauncher = launchManager.getLaunchConfigurationType("org.eclipse.smartmdsd.ui.launch.cmake");
        IWorkspaceRunnable cmakeRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IFolder buildFolder = SmartMDSDManagedBuildConfigurator.this.project.getFolder(SmartMDSDManagedBuildConfigurator.this.buildWorkingDir);
                if (!buildFolder.exists()) {
                    SmartMDSDManagedBuildConfigurator.this.createBuildFolder(monitor);
                }
                String launcherName = SmartMDSDManagedBuildConfigurator.this.project.getName();
                ILaunchConfigurationWorkingCopy cmakeLauncherConfiguration = cmakeLauncher.newInstance((IContainer)SmartMDSDManagedBuildConfigurator.this.project, launcherName);
                cmakeLauncherConfiguration.setAttribute("org.eclipse.smartmdsd.ui.launch.cmake.projectName", SmartMDSDManagedBuildConfigurator.this.project.getName());
                cmakeLauncherConfiguration.setAttribute("org.eclipse.smartmdsd.ui.launch.cmake.cmakeBuildType", SmartMDSDManagedBuildConfigurator.this.buildConfigurationName);
                cmakeLauncherConfiguration.launch("run", monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(cmakeRunnable, (ISchedulingRule)this.project, 1, null);
        return status;
    }

    protected void createBuildFolder(IProgressMonitor monitor) throws CoreException {
        IFolder buildFolder;
        IFolder smartsoftFolder = this.project.getFolder(this.generatorFolderName);
        if (smartsoftFolder.exists() && !(buildFolder = smartsoftFolder.getFolder(this.buildFolderName)).exists()) {
            buildFolder.create(true, true, monitor);
            this.project.refreshLocal(2, monitor);
        }
    }
}

