/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.codegen;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.smartmdsd.ui.natures.ComponentNature;
import org.eclipse.smartmdsd.ui.natures.DomainModelsNature;
import org.eclipse.smartmdsd.ui.natures.SystemNature;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.service.prefs.BackingStoreException;

public class AutoCodeGenerationSwitchHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Enum language;
        boolean newState;
        Command command = event.getCommand();
        boolean oldState = HandlerUtil.toggleCommandState((Command)command);
        boolean bl = newState = !oldState;
        if (newState) {
            System.out.println("Automated code-generation activated!");
        } else {
            System.out.println("Automated code-generation deactivated!");
        }
        Enum[] enumArray = DomainModelsNature.DSL.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            language = enumArray[n2];
            this.setAutobuildValue(((DomainModelsNature.DSL)language).getLanguageID(), newState);
            ++n2;
        }
        enumArray = ComponentNature.DSL.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            language = enumArray[n2];
            this.setAutobuildValue(((ComponentNature.DSL)language).getLanguageID(), newState);
            ++n2;
        }
        enumArray = SystemNature.DSL.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            language = enumArray[n2];
            this.setAutobuildValue(((SystemNature.DSL)language).getLanguageID(), newState);
            ++n2;
        }
        if (newState && this.askToCleanWorkspace(event)) {
            this.fullBuildWorkspace();
        }
        return null;
    }

    private void setAutobuildValue(String nodeId, boolean value) {
        String autoBuildFullStr = "description.autobuilding";
        String autoBuildStr = autoBuildFullStr.substring(autoBuildFullStr.indexOf(46) + 1);
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(nodeId);
        preferences.putBoolean(autoBuildStr, value);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    private boolean askToCleanWorkspace(ExecutionEvent event) {
        try {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
            return MessageDialog.openQuestion((Shell)window.getShell(), (String)"Clean and Build Workspace?", (String)"You have activated automatic code generation. Do you like to rebuild the Workspace?");
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void fullBuildWorkspace() {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Job buildJob = new Job("Rebuild workspace"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    workspace.build(6, monitor);
                    return Status.OK_STATUS;
                }
                catch (CoreException ex) {
                    return ex.getStatus();
                }
            }
        };
        buildJob.schedule();
    }
}

