/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.codegen;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.smartmdsd.ui.codegen.ManualCodeGeneratorWorkspaceJob;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ManualCodeGeneratorTriggerHandler
extends AbstractHandler {
    public IResource getSelectedResource(IWorkbenchWindow window) {
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof IResource) {
                return (IResource)firstElement;
            }
            if (firstElement instanceof IProjectNature) {
                IProjectNature projNature = (IProjectNature)firstElement;
                return projNature.getProject();
            }
        }
        return null;
    }

    public IProject getProjectFromDialog(IWorkbenchWindow window) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(window.getShell(), (ILabelProvider)new WorkbenchLabelProvider());
        BaseWorkbenchContentProvider contentProvider = new BaseWorkbenchContentProvider();
        dialog.setElements(contentProvider.getElements((Object)ResourcesPlugin.getWorkspace().getRoot()));
        dialog.setTitle("Select the Project for Code Generation");
        if (dialog.open() == 0) {
            return (IProject)dialog.getFirstResult();
        }
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IResource currentResource = this.getSelectedResource(window);
        if (currentResource == null) {
            currentResource = this.getProjectFromDialog(window);
        }
        if (currentResource != null) {
            ManualCodeGeneratorWorkspaceJob codeGeneratorJob = new ManualCodeGeneratorWorkspaceJob(currentResource, window);
            codeGeneratorJob.schedule();
        }
        return Status.OK_STATUS;
    }
}

