/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.deployment;

import java.io.File;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.smartmdsd.ui.Activator;

public class DeplyomentLauncher
extends LaunchConfigurationDelegate {
    public static final String LAUNCHER_ID = "org.eclipse.smartmdsd.ui.launch.deployment";
    public static final String ATTR_PROJECT_NAME = "org.eclipse.smartmdsd.ui.launch.deployment.projectName";
    public static final String ATTR_SHELL_COMMAND = "org.eclipse.smartmdsd.ui.launch.deployment.shellCommand";
    public static final String ATTR_ROOT_FOLDER_NAME = "org.eclipse.smartmdsd.ui.launch.deployment.rootFolderName";
    public static final String ATTR_DEPLOYMENT_SCRIPT = "org.eclipse.smartmdsd.ui.launch.deployment.deploymentScript";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String projectName = configuration.getAttribute(ATTR_PROJECT_NAME, "");
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists() && project.isOpen()) {
            if (project.hasNature("org.eclipse.smartmdsd.ui.natures.SystemNature")) {
                String generatorFolderName = Activator.getDefault().getPreferenceStore().getString("GeneratorFolderName");
                String rootFolderName = configuration.getAttribute(ATTR_ROOT_FOLDER_NAME, generatorFolderName);
                IFolder workingDir = project.getFolder(rootFolderName);
                if (workingDir.exists()) {
                    String defaultShellCommand = Activator.getDefault().getPreferenceStore().getString("ShellCommand");
                    String shell = configuration.getAttribute(ATTR_SHELL_COMMAND, defaultShellCommand);
                    String skript = configuration.getAttribute(ATTR_DEPLOYMENT_SCRIPT, "src-gen/deployment/deploy-all.sh");
                    String[] commands = new String[]{shell, skript};
                    Process process = DebugPlugin.exec((String[])commands, (File)workingDir.getLocation().toFile());
                    String processLabel = String.valueOf(shell) + " " + skript;
                    DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)processLabel);
                }
            } else {
                System.out.println("Skip the deployment-action as the selected project " + project.getName() + " does not have a System project-nature.");
            }
        }
    }
}

