/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.factories;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.ecore.behavior.taskRealization.TaskRealizationFactory;
import org.eclipse.smartmdsd.ecore.behavior.taskRealization.TaskRealizationModel;
import org.eclipse.smartmdsd.ui.factories.AbstractSelectedModelsFactory;
import org.eclipse.smartmdsd.ui.natures.BehaviorNature;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class BehaviorModelsFactory
extends AbstractSelectedModelsFactory {
    public BehaviorModelsFactory(IProject project, IFolder modelFolder) {
        super(project, modelFolder);
    }

    @Override
    public boolean createSelectedModels(List<String> selectedModelTypes, IProgressMonitor monitor) {
        List<Resource> relatedResources = null;
        for (String modelName : selectedModelTypes) {
            BehaviorNature.DSL dsl = BehaviorNature.DSL.valueOf(modelName);
            TaskRealizationModel model = null;
            switch (dsl) {
                case TaskRealization: {
                    model = this.createDefaultTaskRealizationModel();
                }
            }
            if (model == null) continue;
            Resource resource = this.createNewXtextResource(dsl.getInjector(), relatedResources);
            this.saveEMFModelInResource((EObject)model, resource);
        }
        return true;
    }

    private TaskRealizationModel createDefaultTaskRealizationModel() {
        TaskRealizationModel model = TaskRealizationFactory.eINSTANCE.createTaskRealizationModel();
        model.setName(this.getProject().getName());
        return model;
    }

    @Override
    public void openSelectedModelsInEditor(IWorkbench workbench, List<String> selectedModelTypes) {
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        for (String modelName : selectedModelTypes) {
            BehaviorNature.DSL dsl = BehaviorNature.DSL.valueOf(modelName);
            String fileName = String.valueOf(this.getProject().getName()) + "." + dsl.getModelFileExtension();
            IFile modelFile = this.getModelFolder().getFile(fileName);
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)modelFile);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }
}

