/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.factories;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.GenericDatasheetFactory;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElement;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElementNames;
import org.eclipse.smartmdsd.ecore.behavior.taskDefinition.TaskDefinitionFactory;
import org.eclipse.smartmdsd.ecore.behavior.taskDefinition.TaskDefinitionModel;
import org.eclipse.smartmdsd.ecore.behavior.taskDefinition.TaskDefinitionRepository;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectModel;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObjectFactory;
import org.eclipse.smartmdsd.ecore.service.communicationObject.Version;
import org.eclipse.smartmdsd.ecore.service.componentMode.ComponentModeFactory;
import org.eclipse.smartmdsd.ecore.service.componentMode.ComponentModeModel;
import org.eclipse.smartmdsd.ecore.service.componentMode.ComponentModeRepository;
import org.eclipse.smartmdsd.ecore.service.domainModelsDatasheet.DomainModelsDatasheet;
import org.eclipse.smartmdsd.ecore.service.domainModelsDatasheet.DomainModelsDatasheetFactory;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParamDefModel;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterDefinitionFactory;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterSetRepository;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefModel;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefRepository;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefinitionFactory;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceRepoVersion;
import org.eclipse.smartmdsd.ecore.service.skillDefinition.SkillDefinitionFactory;
import org.eclipse.smartmdsd.ecore.service.skillDefinition.SkillDefinitionModel;
import org.eclipse.smartmdsd.ecore.service.skillDefinition.SkillDefinitionRepository;
import org.eclipse.smartmdsd.ui.factories.AbstractSelectedModelsFactory;
import org.eclipse.smartmdsd.ui.natures.DomainModelsNature;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class DomainModelsFactory
extends AbstractSelectedModelsFactory {
    public DomainModelsFactory(IProject project, IFolder modelFolder) {
        super(project, modelFolder);
    }

    @Override
    public boolean createSelectedModels(List<String> selectedModelTypes, IProgressMonitor monitor) {
        List<Resource> relatedResources = null;
        for (String modelName : selectedModelTypes) {
            DomainModelsNature.DSL dsl = DomainModelsNature.DSL.valueOf(modelName);
            CommObjectModel model = null;
            switch (dsl) {
                case CommunicationObjects: {
                    model = this.createDefaultCommObjectsModel();
                    break;
                }
                case ServiceDefinition: {
                    model = this.createDefaultServiceDefinitionModel();
                    break;
                }
                case ComponentModeDefinition: {
                    model = this.createDefaultComponentModesModel();
                    break;
                }
                case ParameterDefinition: {
                    model = this.createDefaultParametersModel();
                    break;
                }
                case DomainModelsDatasheet: {
                    model = this.createDefaultDomainModelsDatasheet();
                    break;
                }
                case SkillDefinition: {
                    model = this.createDefaultSkillDefinitionModel();
                    break;
                }
                case TaskDefinition: {
                    model = this.createDefaultTaskDefinitionModel();
                }
            }
            if (model == null) continue;
            Resource resource = this.createNewXtextResource(dsl.getInjector(), relatedResources);
            this.saveEMFModelInResource((EObject)model, resource);
        }
        return true;
    }

    private EObject createDefaultTaskDefinitionModel() {
        TaskDefinitionModel model = TaskDefinitionFactory.eINSTANCE.createTaskDefinitionModel();
        TaskDefinitionRepository repo = TaskDefinitionFactory.eINSTANCE.createTaskDefinitionRepository();
        repo.setName(this.getProject().getName());
        model.setRepository(repo);
        return model;
    }

    private EObject createDefaultSkillDefinitionModel() {
        SkillDefinitionModel model = SkillDefinitionFactory.eINSTANCE.createSkillDefinitionModel();
        SkillDefinitionRepository repo = SkillDefinitionFactory.eINSTANCE.createSkillDefinitionRepository();
        repo.setName(this.getProject().getName());
        model.setRepository(repo);
        return model;
    }

    @Override
    public void openSelectedModelsInEditor(IWorkbench workbench, List<String> selectedModelTypes) {
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        for (String modelName : selectedModelTypes) {
            DomainModelsNature.DSL dsl = DomainModelsNature.DSL.valueOf(modelName);
            String fileName = String.valueOf(this.getProject().getName()) + "." + dsl.getModelFileExtension();
            IFile modelFile = this.getModelFolder().getFile(fileName);
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)modelFile);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    public CommObjectModel createDefaultCommObjectsModel() {
        CommObjectModel model = CommunicationObjectFactory.eINSTANCE.createCommObjectModel();
        CommObjectsRepository repo = CommunicationObjectFactory.eINSTANCE.createCommObjectsRepository();
        repo.setName(this.getProject().getName());
        Version version = CommunicationObjectFactory.eINSTANCE.createVersion();
        version.setMajor(1);
        version.setMinor(0);
        repo.setVersion(version);
        model.setRepository(repo);
        return model;
    }

    public ServiceDefModel createDefaultServiceDefinitionModel() {
        ServiceDefModel model = ServiceDefinitionFactory.eINSTANCE.createServiceDefModel();
        ServiceDefRepository repo = ServiceDefinitionFactory.eINSTANCE.createServiceDefRepository();
        repo.setName(this.getProject().getName());
        ServiceRepoVersion version = ServiceDefinitionFactory.eINSTANCE.createServiceRepoVersion();
        version.setMajor(1);
        version.setMinor(0);
        repo.setVersion(version);
        model.setRepository(repo);
        return model;
    }

    public ComponentModeModel createDefaultComponentModesModel() {
        ComponentModeModel model = ComponentModeFactory.eINSTANCE.createComponentModeModel();
        ComponentModeRepository repo = ComponentModeFactory.eINSTANCE.createComponentModeRepository();
        repo.setName(this.getProject().getName());
        model.setRepository(repo);
        return model;
    }

    public ParamDefModel createDefaultParametersModel() {
        ParamDefModel model = ParameterDefinitionFactory.eINSTANCE.createParamDefModel();
        ParameterSetRepository repo = ParameterDefinitionFactory.eINSTANCE.createParameterSetRepository();
        repo.setName(this.getProject().getName());
        model.setRepository(repo);
        return model;
    }

    public DomainModelsDatasheet createDefaultDomainModelsDatasheet() {
        DomainModelsDatasheet datasheet = DomainModelsDatasheetFactory.eINSTANCE.createDomainModelsDatasheet();
        datasheet.setName(this.getProject().getName());
        MandatoryDatasheetElement baseURI = GenericDatasheetFactory.eINSTANCE.createMandatoryDatasheetElement();
        baseURI.setName(MandatoryDatasheetElementNames.BASE_URI);
        baseURI.setValue("http://www.servicerobotik-ulm.de");
        datasheet.getElements().add((Object)baseURI);
        MandatoryDatasheetElement short_description = GenericDatasheetFactory.eINSTANCE.createMandatoryDatasheetElement();
        short_description.setName(MandatoryDatasheetElementNames.SHORT_DESCRIPTION);
        short_description.setValue("TODO: add short description for " + this.getProject().getName() + " datasheet");
        datasheet.getElements().add((Object)short_description);
        return datasheet;
    }
}

