/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.factories;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.GenericDatasheetFactory;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElement;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.MandatoryDatasheetElementNames;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ActivityArchitectureFactory;
import org.eclipse.smartmdsd.ecore.system.activityArchitecture.ActivityArchitectureModel;
import org.eclipse.smartmdsd.ecore.system.causeEffectChain.CauseEffectChainFactory;
import org.eclipse.smartmdsd.ecore.system.causeEffectChain.CuaseEffectChainModel;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentArchitectureFactory;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.SystemComponentArchitecture;
import org.eclipse.smartmdsd.ecore.system.deployment.DeploymentFactory;
import org.eclipse.smartmdsd.ecore.system.deployment.DeploymentModel;
import org.eclipse.smartmdsd.ecore.system.systemDatasheet.SystemDatasheet;
import org.eclipse.smartmdsd.ecore.system.systemDatasheet.SystemDatasheetFactory;
import org.eclipse.smartmdsd.ecore.system.systemParameter.SystemParamModel;
import org.eclipse.smartmdsd.ecore.system.systemParameter.SystemParameterFactory;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.TargetPlatformFactory;
import org.eclipse.smartmdsd.ecore.system.targetPlatform.TargetPlatformModel;
import org.eclipse.smartmdsd.ui.factories.AbstractSelectedModelsFactory;
import org.eclipse.smartmdsd.ui.natures.SystemNature;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class SystemModelsFactory
extends AbstractSelectedModelsFactory {
    public SystemModelsFactory(IProject project, IFolder modelFolder) {
        super(project, modelFolder);
    }

    @Override
    public boolean createSelectedModels(List<String> selectedModelTypes, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Create selected models", (int)60);
        ArrayList<Resource> relatedResources = new ArrayList<Resource>();
        Resource activityArchitectureResource = this.loadEMFResource(SystemNature.DSL.SystemActivityArchitecture.getInjector());
        ActivityArchitectureModel activityArchitecture = null;
        if (activityArchitectureResource != null && activityArchitectureResource.isLoaded()) {
            activityArchitecture = (ActivityArchitectureModel)activityArchitectureResource.getContents().get(0);
            relatedResources.add(activityArchitectureResource);
        } else if (selectedModelTypes.contains(SystemNature.DSL.SystemActivityArchitecture.name()) || selectedModelTypes.contains(SystemNature.DSL.CauseEffectChains.name())) {
            activityArchitecture = this.createDefaultActivityArchitectureModel();
            activityArchitectureResource = this.createNewXtextResource(SystemNature.DSL.SystemActivityArchitecture.getInjector(), relatedResources);
            this.saveEMFModelInResource((EObject)activityArchitecture, activityArchitectureResource);
            relatedResources.add(activityArchitectureResource);
        }
        subMonitor.split(10);
        Resource systemCompArchResource = this.loadEMFResource(SystemNature.DSL.SystemComponentArchitecture.getInjector());
        SystemComponentArchitecture systemCompArch = null;
        if (systemCompArchResource != null && systemCompArchResource.isLoaded()) {
            systemCompArch = (SystemComponentArchitecture)systemCompArchResource.getContents().get(0);
            relatedResources.add(systemCompArchResource);
        } else if (selectedModelTypes.contains(SystemNature.DSL.SystemComponentArchitecture.name()) || selectedModelTypes.contains(SystemNature.DSL.Deployment.name()) || selectedModelTypes.contains(SystemNature.DSL.SystemParameters.name())) {
            systemCompArch = this.createDefaultComponentArchitectureModel(activityArchitecture);
            systemCompArchResource = this.createNewXtextResource(SystemNature.DSL.SystemComponentArchitecture.getInjector(), relatedResources);
            this.saveEMFModelInResource((EObject)systemCompArch, systemCompArchResource);
            relatedResources.add(systemCompArchResource);
        }
        for (String modelName : selectedModelTypes) {
            subMonitor.split(10);
            SystemNature.DSL dsl = SystemNature.DSL.valueOf(modelName);
            TargetPlatformModel model = null;
            switch (dsl) {
                case TargetPlatform: {
                    model = this.createDefaultTargetPlatformModel();
                    break;
                }
                case Deployment: {
                    model = this.createDefaultDeploymentModel(systemCompArch);
                    break;
                }
                case SystemParameters: {
                    model = this.createDefaultSystemParameterModel(systemCompArch);
                    break;
                }
                case SystemDatasheet: {
                    model = this.createDefaultSystemDatasheetModel();
                    break;
                }
                case CauseEffectChains: {
                    model = this.createDefaultCauseEffectChainsModel(activityArchitecture);
                }
            }
            if (model == null) continue;
            Resource resource = this.createNewXtextResource(dsl.getInjector(), relatedResources);
            this.saveEMFModelInResource((EObject)model, resource);
        }
        subMonitor.done();
        return true;
    }

    @Override
    public void openSelectedModelsInEditor(IWorkbench workbench, List<String> selectedModelTypes) {
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        for (String modelName : selectedModelTypes) {
            SystemNature.DSL dsl = SystemNature.DSL.valueOf(modelName);
            if (dsl.getSiriusViewpointName() != null) continue;
            String fileName = String.valueOf(this.getProject().getName()) + "." + dsl.getModelFileExtension();
            IFile modelFile = this.getModelFolder().getFile(fileName);
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)modelFile);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    private SystemComponentArchitecture createDefaultComponentArchitectureModel(ActivityArchitectureModel activityArch) {
        SystemComponentArchitecture model = ComponentArchitectureFactory.eINSTANCE.createSystemComponentArchitecture();
        model.setName(this.getProject().getName());
        if (activityArch != null) {
            model.setActivityArch(activityArch);
        }
        return model;
    }

    private TargetPlatformModel createDefaultTargetPlatformModel() {
        TargetPlatformModel model = TargetPlatformFactory.eINSTANCE.createTargetPlatformModel();
        model.setName(this.getProject().getName());
        return model;
    }

    private DeploymentModel createDefaultDeploymentModel(SystemComponentArchitecture compArch) {
        DeploymentModel model = DeploymentFactory.eINSTANCE.createDeploymentModel();
        model.setName(this.getProject().getName());
        model.setComponentArch(compArch);
        return model;
    }

    private SystemParamModel createDefaultSystemParameterModel(SystemComponentArchitecture compArch) {
        SystemParamModel model = SystemParameterFactory.eINSTANCE.createSystemParamModel();
        model.setName(this.getProject().getName());
        model.setSystem(compArch);
        return model;
    }

    private ActivityArchitectureModel createDefaultActivityArchitectureModel() {
        ActivityArchitectureModel model = ActivityArchitectureFactory.eINSTANCE.createActivityArchitectureModel();
        model.setName(this.getProject().getName());
        return model;
    }

    private CuaseEffectChainModel createDefaultCauseEffectChainsModel(ActivityArchitectureModel activityArch) {
        CuaseEffectChainModel model = CauseEffectChainFactory.eINSTANCE.createCuaseEffectChainModel();
        model.setName(this.getProject().getName());
        model.setActArch(activityArch);
        return model;
    }

    private SystemDatasheet createDefaultSystemDatasheetModel() {
        SystemDatasheet datasheet = SystemDatasheetFactory.eINSTANCE.createSystemDatasheet();
        datasheet.setName(this.getProject().getName());
        MandatoryDatasheetElement baseURI = GenericDatasheetFactory.eINSTANCE.createMandatoryDatasheetElement();
        baseURI.setName(MandatoryDatasheetElementNames.BASE_URI);
        baseURI.setValue("http://www.servicerobotik-ulm.de");
        datasheet.getElements().add((Object)baseURI);
        MandatoryDatasheetElement short_description = GenericDatasheetFactory.eINSTANCE.createMandatoryDatasheetElement();
        short_description.setName(MandatoryDatasheetElementNames.SHORT_DESCRIPTION);
        short_description.setValue("TODO: add short description for " + this.getProject().getName() + " datasheet");
        datasheet.getElements().add((Object)short_description);
        return datasheet;
    }
}

