/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.natures;

import com.google.inject.Injector;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.smartmdsd.ui.natures.AbstractSmartMDSDNature;
import org.eclipse.smartmdsd.ui.natures.LanguageInterface;
import org.eclipse.smartmdsd.xtext.behavior.taskRealization.ui.internal.TaskRealizationActivator;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.FileExtensionProvider;

public class BehaviorNature
extends AbstractSmartMDSDNature {
    public static final String NATURE_ID = "org.eclipse.smartmdsd.ui.natures.BehaviorNature";

    @Override
    public LanguageInterface getLanguageInterfaceFrom(IResource modelResource) {
        try {
            IEditorRegistry editorRegistry;
            IEditorDescriptor editor;
            IProject project = modelResource.getProject();
            if (project.hasNature(NATURE_ID) && (editor = (editorRegistry = PlatformUI.getWorkbench().getEditorRegistry()).getDefaultEditor(modelResource.getName())) != null) {
                return DSL.getFromID(editor.getId());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public LanguageInterface getLanguageInterfaceOf(String languageName) {
        return DSL.valueOf(languageName);
    }

    @Override
    public List<String> getImportedProjectNatureIds() {
        return Arrays.asList("org.eclipse.smartmdsd.ui.natures.DomainModelsNature");
    }

    @Override
    public LanguageInterface[] getAllSupportedLanguages() {
        return DSL.values();
    }

    public static enum DSL implements LanguageInterface
    {
        TaskRealization("org.eclipse.smartmdsd.xtext.behavior.taskRealization.TaskRealization");

        private static final Map<String, DSL> lookup;
        private String languageID;

        static {
            lookup = new HashMap<String, DSL>();
            DSL[] dSLArray = DSL.values();
            int n = dSLArray.length;
            int n2 = 0;
            while (n2 < n) {
                DSL lang = dSLArray[n2];
                lookup.put(lang.getLanguageID(), lang);
                ++n2;
            }
        }

        public static DSL getFromID(String languageID) {
            return lookup.get(languageID);
        }

        private DSL(String languageID) {
            this.languageID = languageID;
        }

        @Override
        public String getLanguageID() {
            return this.languageID;
        }

        @Override
        public Injector getInjector() {
            switch (this) {
                case TaskRealization: {
                    return TaskRealizationActivator.getInstance().getInjector(this.languageID);
                }
            }
            return null;
        }

        @Override
        public String getModelFileExtension() {
            return ((FileExtensionProvider)this.getInjector().getInstance(FileExtensionProvider.class)).getPrimaryFileExtension();
        }

        @Override
        public String getSiriusViewpointName() {
            return null;
        }

        @Override
        public String getKey() {
            return this.name();
        }

        @Override
        public boolean isDefaultLanguage() {
            switch (this) {
                case TaskRealization: {
                    return true;
                }
            }
            return false;
        }
    }
}

