/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.natures;

import com.google.inject.Injector;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.smartmdsd.ui.natures.AbstractSmartMDSDNature;
import org.eclipse.smartmdsd.ui.natures.LanguageInterface;
import org.eclipse.smartmdsd.xtext.behavior.skillRealization.ui.internal.SkillRealizationActivator;
import org.eclipse.smartmdsd.xtext.component.componentDatasheet.ui.internal.ComponentDatasheetActivator;
import org.eclipse.smartmdsd.xtext.component.componentDefinition.ui.internal.ComponentDefinitionActivator;
import org.eclipse.smartmdsd.xtext.component.componentParameter.ui.internal.ComponentParameterActivator;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.FileExtensionProvider;

public class ComponentNature
extends AbstractSmartMDSDNature {
    public static final String NATURE_ID = "org.eclipse.smartmdsd.ui.natures.ComponentNature";

    @Override
    public LanguageInterface getLanguageInterfaceOf(String languageName) {
        return DSL.valueOf(languageName);
    }

    @Override
    public LanguageInterface getLanguageInterfaceFrom(IResource modelResource) {
        try {
            IEditorRegistry editorRegistry;
            IEditorDescriptor editor;
            IProject project = modelResource.getProject();
            if (project.hasNature(NATURE_ID) && (editor = (editorRegistry = PlatformUI.getWorkbench().getEditorRegistry()).getDefaultEditor(modelResource.getName())) != null) {
                return DSL.getFromID(editor.getId());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public LanguageInterface[] getAllSupportedLanguages() {
        return DSL.values();
    }

    @Override
    public List<String> getImportedProjectNatureIds() {
        return Arrays.asList("org.eclipse.smartmdsd.ui.natures.DomainModelsNature");
    }

    public static enum DSL implements LanguageInterface
    {
        ComponentDefinition("org.eclipse.smartmdsd.xtext.component.componentDefinition.ComponentDefinition"),
        ComponentParameters("org.eclipse.smartmdsd.xtext.component.componentParameter.ComponentParameter"),
        ComponentDatasheet("org.eclipse.smartmdsd.xtext.component.componentDatasheet.ComponentDatasheet"),
        SkillRealization("org.eclipse.smartmdsd.xtext.behavior.skillRealization.SkillRealization");

        private static final Map<String, DSL> lookup;
        private String languageID;
        private static final Map<String, String> siriusViewpoints;

        static {
            lookup = new HashMap<String, DSL>();
            DSL[] dSLArray = DSL.values();
            int n = dSLArray.length;
            int n2 = 0;
            while (n2 < n) {
                DSL lang = dSLArray[n2];
                lookup.put(lang.getLanguageID(), lang);
                ++n2;
            }
            siriusViewpoints = new HashMap<String, String>();
            siriusViewpoints.put(DSL.ComponentDefinition.languageID, "ComponentDefinitionViewpoint");
        }

        public static DSL getFromID(String languageID) {
            return lookup.get(languageID);
        }

        private DSL(String languageID) {
            this.languageID = languageID;
        }

        @Override
        public String getLanguageID() {
            return this.languageID;
        }

        @Override
        public String getKey() {
            return this.name();
        }

        @Override
        public Injector getInjector() {
            switch (this) {
                case ComponentDefinition: {
                    return ComponentDefinitionActivator.getInstance().getInjector(this.languageID);
                }
                case ComponentParameters: {
                    return ComponentParameterActivator.getInstance().getInjector(this.languageID);
                }
                case ComponentDatasheet: {
                    return ComponentDatasheetActivator.getInstance().getInjector(this.languageID);
                }
                case SkillRealization: {
                    return SkillRealizationActivator.getInstance().getInjector(this.languageID);
                }
            }
            return null;
        }

        @Override
        public String getModelFileExtension() {
            return ((FileExtensionProvider)this.getInjector().getInstance(FileExtensionProvider.class)).getPrimaryFileExtension();
        }

        @Override
        public String getSiriusViewpointName() {
            return siriusViewpoints.get(this.languageID);
        }

        @Override
        public boolean isDefaultLanguage() {
            switch (this) {
                case ComponentDefinition: {
                    return true;
                }
            }
            return false;
        }
    }
}

