/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.natures;

import com.google.inject.Injector;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.smartmdsd.ui.natures.AbstractSmartMDSDNature;
import org.eclipse.smartmdsd.ui.natures.LanguageInterface;
import org.eclipse.smartmdsd.xtext.behavior.taskDefinition.ui.internal.TaskDefinitionActivator;
import org.eclipse.smartmdsd.xtext.service.communicationObject.ui.internal.CommunicationObjectActivator;
import org.eclipse.smartmdsd.xtext.service.componentMode.ui.internal.ComponentModeActivator;
import org.eclipse.smartmdsd.xtext.service.domainModelsDatasheet.ui.internal.DomainModelsDatasheetActivator;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.ui.internal.ParameterDefinitionActivator;
import org.eclipse.smartmdsd.xtext.service.serviceDefinition.ui.internal.ServiceDefinitionActivator;
import org.eclipse.smartmdsd.xtext.service.skillDefinition.ui.internal.SkillDefinitionActivator;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.FileExtensionProvider;

public class DomainModelsNature
extends AbstractSmartMDSDNature {
    public static final String NATURE_ID = "org.eclipse.smartmdsd.ui.natures.DomainModelsNature";

    @Override
    public LanguageInterface getLanguageInterfaceOf(String languageName) {
        return DSL.valueOf(languageName);
    }

    @Override
    public LanguageInterface getLanguageInterfaceFrom(IResource modelResource) {
        try {
            IEditorRegistry editorRegistry;
            IEditorDescriptor editor;
            IProject project = modelResource.getProject();
            if (project.hasNature(NATURE_ID) && (editor = (editorRegistry = PlatformUI.getWorkbench().getEditorRegistry()).getDefaultEditor(modelResource.getName())) != null) {
                return DSL.getFromID(editor.getId());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public LanguageInterface[] getAllSupportedLanguages() {
        return DSL.values();
    }

    @Override
    public List<String> getImportedProjectNatureIds() {
        return Arrays.asList(NATURE_ID);
    }

    public static enum DSL implements LanguageInterface
    {
        ServiceDefinition("org.eclipse.smartmdsd.xtext.service.serviceDefinition.ServiceDefinition"),
        CommunicationObjects("org.eclipse.smartmdsd.xtext.service.communicationObject.CommunicationObject"),
        ParameterDefinition("org.eclipse.smartmdsd.xtext.service.parameterDefinition.ParameterDefinition"),
        ComponentModeDefinition("org.eclipse.smartmdsd.xtext.service.componentMode.ComponentMode"),
        DomainModelsDatasheet("org.eclipse.smartmdsd.xtext.service.domainModelsDatasheet.DomainModelsDatasheet"),
        SkillDefinition("org.eclipse.smartmdsd.xtext.service.skillDefinition.SkillDefinition"),
        TaskDefinition("org.eclipse.smartmdsd.xtext.behavior.taskDefinition.TaskDefinition");

        private static final Map<String, DSL> lookup;
        private String languageID;

        static {
            lookup = new HashMap<String, DSL>();
            DSL[] dSLArray = DSL.values();
            int n = dSLArray.length;
            int n2 = 0;
            while (n2 < n) {
                DSL lang = dSLArray[n2];
                lookup.put(lang.getLanguageID(), lang);
                ++n2;
            }
        }

        public static DSL getFromID(String languageID) {
            return lookup.get(languageID);
        }

        private DSL(String languageID) {
            this.languageID = languageID;
        }

        @Override
        public String getLanguageID() {
            return this.languageID;
        }

        @Override
        public String getKey() {
            return this.name();
        }

        @Override
        public Injector getInjector() {
            switch (this) {
                case ServiceDefinition: {
                    return ServiceDefinitionActivator.getInstance().getInjector(this.languageID);
                }
                case CommunicationObjects: {
                    return CommunicationObjectActivator.getInstance().getInjector(this.languageID);
                }
                case ParameterDefinition: {
                    return ParameterDefinitionActivator.getInstance().getInjector(this.languageID);
                }
                case ComponentModeDefinition: {
                    return ComponentModeActivator.getInstance().getInjector(this.languageID);
                }
                case DomainModelsDatasheet: {
                    return DomainModelsDatasheetActivator.getInstance().getInjector(this.languageID);
                }
                case SkillDefinition: {
                    return SkillDefinitionActivator.getInstance().getInjector(this.languageID);
                }
                case TaskDefinition: {
                    return TaskDefinitionActivator.getInstance().getInjector(this.languageID);
                }
            }
            return null;
        }

        @Override
        public String getModelFileExtension() {
            return ((FileExtensionProvider)this.getInjector().getInstance(FileExtensionProvider.class)).getPrimaryFileExtension();
        }

        @Override
        public String getSiriusViewpointName() {
            return null;
        }

        @Override
        public boolean isDefaultLanguage() {
            switch (this) {
                case ServiceDefinition: 
                case CommunicationObjects: 
                case ParameterDefinition: {
                    return true;
                }
            }
            return false;
        }
    }
}

