/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.natures;

import com.google.inject.Injector;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.smartmdsd.ui.Activator;
import org.eclipse.smartmdsd.ui.builder.CDTProjectHelpers;
import org.eclipse.smartmdsd.ui.natures.AbstractSmartMDSDNature;
import org.eclipse.smartmdsd.ui.natures.LanguageInterface;
import org.eclipse.smartmdsd.xtext.system.activityArchitecture.ui.internal.ActivityArchitectureActivator;
import org.eclipse.smartmdsd.xtext.system.causeEffectChain.ui.internal.CauseEffectChainActivator;
import org.eclipse.smartmdsd.xtext.system.componentArchitecture.ui.internal.ComponentArchitectureActivator;
import org.eclipse.smartmdsd.xtext.system.deployment.ui.internal.DeploymentActivator;
import org.eclipse.smartmdsd.xtext.system.systemDatasheet.ui.internal.SystemDatasheetActivator;
import org.eclipse.smartmdsd.xtext.system.systemParameter.ui.internal.SystemParameterActivator;
import org.eclipse.smartmdsd.xtext.system.targetPlatform.ui.internal.TargetPlatformActivator;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.FileExtensionProvider;

public class SystemNature
extends AbstractSmartMDSDNature {
    public static final String NATURE_ID = "org.eclipse.smartmdsd.ui.natures.SystemNature";

    @Override
    public void configure() throws CoreException {
        if (this.project != null && this.project.isOpen()) {
            if (!this.project.hasNature("org.eclipse.cdt.core.ccnature")) {
                WorkspaceJob addCppSettingsJob = new WorkspaceJob("Add C++ project configuration to " + this.project.getName()){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        try {
                            String activeBuildType = Activator.getDefault().getPreferenceStore().getString("CMakeBuildType");
                            CDTProjectHelpers.addDefaultSettingsTo(SystemNature.this.project, activeBuildType, monitor);
                        }
                        catch (BuildException e) {
                            e.printStackTrace();
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
                addCppSettingsJob.setUser(true);
                addCppSettingsJob.schedule();
            } else {
                super.configure();
            }
        }
    }

    @Override
    public LanguageInterface getLanguageInterfaceOf(String languageName) {
        return DSL.valueOf(languageName);
    }

    @Override
    public LanguageInterface getLanguageInterfaceFrom(IResource modelResource) {
        try {
            IEditorRegistry editorRegistry;
            IEditorDescriptor editor;
            IProject project = modelResource.getProject();
            if (project.hasNature(NATURE_ID) && (editor = (editorRegistry = PlatformUI.getWorkbench().getEditorRegistry()).getDefaultEditor(modelResource.getName())) != null) {
                return DSL.getFromID(editor.getId());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public LanguageInterface[] getAllSupportedLanguages() {
        return DSL.values();
    }

    @Override
    public List<String> getImportedProjectNatureIds() {
        return Arrays.asList("org.eclipse.smartmdsd.ui.natures.ComponentNature", "org.eclipse.smartmdsd.ui.natures.BehaviorNature");
    }

    public static enum DSL implements LanguageInterface
    {
        SystemComponentArchitecture("org.eclipse.smartmdsd.xtext.system.componentArchitecture.ComponentArchitecture"),
        SystemActivityArchitecture("org.eclipse.smartmdsd.xtext.system.activityArchitecture.ActivityArchitecture"),
        CauseEffectChains("org.eclipse.smartmdsd.xtext.system.causeEffectChain.CauseEffectChain"),
        SystemParameters("org.eclipse.smartmdsd.xtext.system.systemParameter.SystemParameter"),
        SystemDatasheet("org.eclipse.smartmdsd.xtext.system.systemDatasheet.SystemDatasheet"),
        TargetPlatform("org.eclipse.smartmdsd.xtext.system.targetPlatform.TargetPlatform"),
        Deployment("org.eclipse.smartmdsd.xtext.system.deployment.Deployment");

        private static final Map<String, DSL> lookup;
        private String languageID;
        private static final Map<String, String> siriusViewpoints;

        static {
            lookup = new HashMap<String, DSL>();
            DSL[] dSLArray = DSL.values();
            int n = dSLArray.length;
            int n2 = 0;
            while (n2 < n) {
                DSL lang = dSLArray[n2];
                lookup.put(lang.getLanguageID(), lang);
                ++n2;
            }
            siriusViewpoints = new HashMap<String, String>();
            siriusViewpoints.put(DSL.SystemComponentArchitecture.languageID, "SystemArchitectureViewpoint");
            siriusViewpoints.put(DSL.TargetPlatform.languageID, "TargetPlatformViewpoint");
            siriusViewpoints.put(DSL.Deployment.languageID, "DeploymentViewpoint");
        }

        public static DSL getFromID(String languageID) {
            return lookup.get(languageID);
        }

        private DSL(String languageID) {
            this.languageID = languageID;
        }

        @Override
        public String getLanguageID() {
            return this.languageID;
        }

        @Override
        public String getKey() {
            return this.name();
        }

        @Override
        public Injector getInjector() {
            switch (this) {
                case SystemComponentArchitecture: {
                    return ComponentArchitectureActivator.getInstance().getInjector(this.languageID);
                }
                case SystemActivityArchitecture: {
                    return ActivityArchitectureActivator.getInstance().getInjector(this.languageID);
                }
                case CauseEffectChains: {
                    return CauseEffectChainActivator.getInstance().getInjector(this.languageID);
                }
                case SystemParameters: {
                    return SystemParameterActivator.getInstance().getInjector(this.languageID);
                }
                case SystemDatasheet: {
                    return SystemDatasheetActivator.getInstance().getInjector(this.languageID);
                }
                case TargetPlatform: {
                    return TargetPlatformActivator.getInstance().getInjector(this.languageID);
                }
                case Deployment: {
                    return DeploymentActivator.getInstance().getInjector(this.languageID);
                }
            }
            return null;
        }

        @Override
        public String getModelFileExtension() {
            return ((FileExtensionProvider)this.getInjector().getInstance(FileExtensionProvider.class)).getPrimaryFileExtension();
        }

        @Override
        public String getSiriusViewpointName() {
            return siriusViewpoints.get(this.languageID);
        }

        @Override
        public boolean isDefaultLanguage() {
            switch (this) {
                case SystemComponentArchitecture: 
                case TargetPlatform: 
                case Deployment: {
                    return true;
                }
            }
            return false;
        }
    }
}

