/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.smartmdsd.ui.Activator;
import org.eclipse.smartmdsd.ui.builder.CDTProjectHelpers;
import org.eclipse.smartmdsd.ui.factories.AbstractSelectedModelsFactory;
import org.eclipse.smartmdsd.ui.factories.JavaProjectFactory;
import org.eclipse.smartmdsd.ui.factories.ModelingProjectFactory;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureEnum;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureHelpers;
import org.eclipse.smartmdsd.ui.wizards.FilteredProjectReferencePage;
import org.eclipse.smartmdsd.ui.wizards.SmartMDSDModelTypeSelectionPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;

public abstract class AbstractProjectCreationWizard
extends Wizard
implements INewWizard {
    protected WizardNewProjectCreationPage pageOne;
    protected SmartMDSDModelTypeSelectionPage pageTwo;
    protected WizardNewProjectReferencePage pageThree;
    protected IWorkbench workbench;
    protected ISelection selection;

    public AbstractProjectCreationWizard() {
        this.setNeedsProgressMonitor(true);
    }

    protected abstract WizardNewProjectCreationPage createFirstPage();

    protected abstract SmartMDSDNatureEnum getCurrentNatureEnum();

    protected abstract boolean isModelingProject();

    protected abstract void customizeProject(IProject var1, IFolder var2, IProgressMonitor var3) throws CoreException;

    public void addPages() {
        this.pageOne = this.createFirstPage();
        this.addPage((IWizardPage)this.pageOne);
        this.pageTwo = new SmartMDSDModelTypeSelectionPage("SmartMDSD-Model-Types-Selection");
        this.pageTwo.setTitle("Select SmartMDSD Model Types");
        this.pageTwo.setDescription("Select the SmartMDSD model-types that shall be created.");
        this.pageTwo.setAllModelTypeEntriesFor(this.getCurrentNatureEnum());
        this.addPage((IWizardPage)this.pageTwo);
        this.pageThree = new FilteredProjectReferencePage("ProjectReferencesPage", this.getCurrentNatureEnum());
        this.pageThree.setTitle("Select referenced projects");
        this.pageThree.setDescription("This page allows to select referenced projects");
        this.addPage((IWizardPage)this.pageThree);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public boolean performFinish() {
        boolean result = true;
        WorkspaceModifyOperation createProjectOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Project Creation Wizard", (int)350);
                String projectName = AbstractProjectCreationWizard.this.pageOne.getProjectName();
                URI projectLocation = AbstractProjectCreationWizard.this.pageOne.getLocationURI();
                List<String> selectedModelTypes = AbstractProjectCreationWizard.this.pageTwo.getSelectedModelTypes();
                IProject[] referencedProjects = AbstractProjectCreationWizard.this.pageThree.getReferencedProjects();
                String modelFolderName = Activator.getDefault().getPreferenceStore().getString("ModelsFolderName");
                IProject project = AbstractProjectCreationWizard.this.createProject(projectName, projectLocation, referencedProjects, (IProgressMonitor)subMonitor.split(10));
                SmartMDSDNatureHelpers.addProjectNature(project, "org.eclipse.xtext.ui.shared.xtextNature", (IProgressMonitor)subMonitor.split(10));
                JavaProjectFactory.createJavaProject(project, referencedProjects, modelFolderName, (IProgressMonitor)subMonitor.split(10));
                if (subMonitor.isCanceled()) {
                    return;
                }
                try {
                    String activeBuildType = Activator.getDefault().getPreferenceStore().getString("CMakeBuildType");
                    CDTProjectHelpers.addDefaultSettingsTo(project, activeBuildType, (IProgressMonitor)subMonitor.split(50));
                }
                catch (BuildException | OperationCanceledException e) {
                    e.printStackTrace();
                }
                SmartMDSDNatureHelpers.addProjectNature(project, AbstractProjectCreationWizard.this.getCurrentNatureEnum().getId(), (IProgressMonitor)subMonitor.split(10));
                if (subMonitor.isCanceled()) {
                    return;
                }
                if (project.isOpen()) {
                    IFolder modelFolder = project.getFolder(modelFolderName);
                    modelFolder.create(true, true, (IProgressMonitor)subMonitor.split(10));
                    AbstractSelectedModelsFactory modelsFactory = AbstractProjectCreationWizard.this.getCurrentNatureEnum().createModelsFactory(project, modelFolder);
                    modelsFactory.createSelectedModels(selectedModelTypes, (IProgressMonitor)subMonitor.split(50));
                    modelsFactory.openSelectedModelsInEditor(AbstractProjectCreationWizard.this.workbench, selectedModelTypes);
                    if (subMonitor.isCanceled()) {
                        return;
                    }
                    if (AbstractProjectCreationWizard.this.isModelingProject()) {
                        ModelingProjectFactory.createModelingProject(project, selectedModelTypes, (IProgressMonitor)subMonitor.split(150));
                    }
                    AbstractProjectCreationWizard.this.customizeProject(project, modelFolder, (IProgressMonitor)subMonitor.split(50));
                }
                subMonitor.done();
            }
        };
        try {
            boolean doFork = false;
            boolean cancelable = true;
            this.getContainer().run(doFork, cancelable, (IRunnableWithProgress)createProjectOperation);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            result = false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    protected IProject createProject(String projectName, URI projectLocation, IProject[] referencedProjects, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Create Project " + projectName), (int)20);
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        description.setLocationURI(projectLocation);
        description.setReferencedProjects(referencedProjects);
        projectHandle.create(description, (IProgressMonitor)subMonitor.split(10));
        projectHandle.open(128, (IProgressMonitor)subMonitor.split(10));
        return projectHandle;
    }
}

