/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.smartmdsd.ui.Activator;
import org.eclipse.smartmdsd.ui.natures.AbstractSmartMDSDNature;
import org.eclipse.smartmdsd.ui.natures.LanguageInterface;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureEnum;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SmartMDSDModelTypeSelectionPage
extends WizardPage {
    private CheckboxTableViewer selectedModelTypesViewer;
    private static final int MODELS_LIST_MULTIPLIER = 10;

    public SmartMDSDModelTypeSelectionPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public void setModelTypeEntriesFrom(final IProject project) {
        WorkspaceJob job = new WorkspaceJob("Calculate all supported model-types for project wizard"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                SmartMDSDNatureEnum[] smartMDSDNatureEnumArray = SmartMDSDNatureEnum.values();
                int n = smartMDSDNatureEnumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SmartMDSDNatureEnum natureEnum = smartMDSDNatureEnumArray[n2];
                    if (project.hasNature(natureEnum.getId())) {
                        AbstractSmartMDSDNature nature = natureEnum.getSmartMDSDNatureFrom(project);
                        LanguageInterface[] allSupportedLanguages = nature.getAllSupportedLanguages();
                        final List filteredLanguageList = SmartMDSDModelTypeSelectionPage.this.filterLanguageEntries(allSupportedLanguages, project);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                SmartMDSDModelTypeSelectionPage.this.setTableContent(filteredLanguageList);
                            }
                        });
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void setAllModelTypeEntriesFor(final SmartMDSDNatureEnum natureEnum) {
        Job job = new Job("Calculate all supported model-types for project wizard"){

            protected IStatus run(IProgressMonitor monitor) {
                AbstractSmartMDSDNature nature = natureEnum.createSmartMDSDNatureObject();
                final LanguageInterface[] allSupportedLanguages = nature.getAllSupportedLanguages();
                if (allSupportedLanguages != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SmartMDSDModelTypeSelectionPage.this.setTableContent(Arrays.asList(allSupportedLanguages));
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        Label referenceLabel = new Label(composite, 0);
        referenceLabel.setText("Selected SmartMDSD model-types");
        referenceLabel.setFont(font);
        this.selectedModelTypesViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.selectedModelTypesViewer.getTable().setFont(composite.getFont());
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = SmartMDSDModelTypeSelectionPage.getDefaultFontHeight((Control)this.selectedModelTypesViewer.getTable(), 10);
        this.selectedModelTypesViewer.getTable().setLayoutData((Object)data);
        this.selectedModelTypesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.selectedModelTypesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.selectedModelTypesViewer.setComparator(new ViewerComparator());
        ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object source = event.getSource();
                if (source instanceof CheckboxTableViewer) {
                    CheckboxTableViewer tableViewer = (CheckboxTableViewer)source;
                    Object[] checkedElements = tableViewer.getCheckedElements();
                    if (checkedElements.length > 0) {
                        SmartMDSDModelTypeSelectionPage.this.setPageComplete(true);
                    } else {
                        SmartMDSDModelTypeSelectionPage.this.setPageComplete(false);
                    }
                }
            }
        };
        this.selectedModelTypesViewer.addSelectionChangedListener(selectionChangedListener);
        this.setControl((Control)composite);
    }

    private static int getDefaultFontHeight(Control control, int lines) {
        FontData[] viewerFontData = control.getFont().getFontData();
        int fontHeight = 10;
        if (viewerFontData.length > 0) {
            fontHeight = viewerFontData[0].getHeight();
        }
        return lines * fontHeight;
    }

    public List<String> getSelectedModelTypes() {
        Object[] selectedObjects = this.selectedModelTypesViewer.getCheckedElements();
        ArrayList<String> result = new ArrayList<String>();
        Object[] objectArray = selectedObjects;
        int n = selectedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof String) {
                result.add((String)object);
            }
            ++n2;
        }
        return result;
    }

    private List<LanguageInterface> filterLanguageEntries(LanguageInterface[] allSupportedLanguages, IProject project) {
        String modelFolderName = Activator.getDefault().getPreferenceStore().getString("ModelsFolderName");
        IFolder modelFolder = project.getFolder(modelFolderName);
        if (modelFolder.exists()) {
            ArrayList<LanguageInterface> filteredLanguages = new ArrayList<LanguageInterface>();
            LanguageInterface[] languageInterfaceArray = allSupportedLanguages;
            int n = allSupportedLanguages.length;
            int n2 = 0;
            while (n2 < n) {
                LanguageInterface entry = languageInterfaceArray[n2];
                IFile modelFile = modelFolder.getFile(String.valueOf(project.getName()) + "." + entry.getModelFileExtension());
                if (!modelFile.exists()) {
                    filteredLanguages.add(entry);
                }
                ++n2;
            }
            return filteredLanguages;
        }
        return Arrays.asList(allSupportedLanguages);
    }

    private void setTableContent(List<LanguageInterface> languageEntries) {
        ArrayList<String> newModelTypes = new ArrayList<String>();
        ArrayList<String> preselectedModelTypes = new ArrayList<String>();
        for (LanguageInterface entry : languageEntries) {
            newModelTypes.add(entry.getKey());
            if (!entry.isDefaultLanguage()) continue;
            preselectedModelTypes.add(entry.getKey());
        }
        this.selectedModelTypesViewer.setInput(newModelTypes);
        this.selectedModelTypesViewer.setCheckedElements(preselectedModelTypes.toArray());
        if (!preselectedModelTypes.isEmpty()) {
            this.setPageComplete(true);
        }
    }
}

