/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.smartmdsd.ui.Activator;
import org.eclipse.smartmdsd.ui.factories.AbstractSelectedModelsFactory;
import org.eclipse.smartmdsd.ui.factories.ModelingProjectFactory;
import org.eclipse.smartmdsd.ui.natures.SmartMDSDNatureEnum;
import org.eclipse.smartmdsd.ui.wizards.SingleProjectSelectionPage;
import org.eclipse.smartmdsd.ui.wizards.SmartMDSDModelTypeSelectionPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class WizardNewSmartMDSDModel
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = "org.eclipse.smartmdsd.ui.wizards.individualModel";
    private SingleProjectSelectionPage pageOne;
    private SmartMDSDModelTypeSelectionPage pageTwo;
    private IWorkbench workbench;
    private IStructuredSelection selection;

    public WizardNewSmartMDSDModel() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.pageOne = new SingleProjectSelectionPage("Project-Selection-Page", this.workbench, (ISelection)this.selection);
        this.pageOne.setTitle("Project Selection Page");
        this.pageOne.setDescription("Select an existing project for which a SmartMDSD Model will be created.");
        this.addPage((IWizardPage)this.pageOne);
        this.pageTwo = new SmartMDSDModelTypeSelectionPage("SmartMDSD-Model-Types-Selection");
        this.pageTwo.setTitle("Select SmartMDSD Model Types");
        this.pageTwo.setDescription("Select the SmartMDSD model-types that shall be created.");
        this.addPage((IWizardPage)this.pageTwo);
    }

    public boolean performFinish() {
        boolean result = true;
        WorkspaceModifyOperation createSelectedModelsOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                String modelFolderName;
                IFolder modelFolder;
                IProject selectedProject = WizardNewSmartMDSDModel.this.pageOne.getSelectedProject();
                if (selectedProject != null && (modelFolder = selectedProject.getFolder(modelFolderName = Activator.getDefault().getPreferenceStore().getString("ModelsFolderName"))).exists()) {
                    SmartMDSDNatureEnum[] smartMDSDNatureEnumArray = SmartMDSDNatureEnum.values();
                    int n = smartMDSDNatureEnumArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        List<String> selectedModelTypes;
                        boolean creationSucceeded;
                        AbstractSelectedModelsFactory selectedModelsFactory;
                        SmartMDSDNatureEnum natureEnum = smartMDSDNatureEnumArray[n2];
                        if (selectedProject.hasNature(natureEnum.getId()) && (selectedModelsFactory = natureEnum.createModelsFactory(selectedProject, modelFolder)) != null && (creationSucceeded = selectedModelsFactory.createSelectedModels(selectedModelTypes = WizardNewSmartMDSDModel.this.pageTwo.getSelectedModelTypes(), monitor))) {
                            selectedModelsFactory.openSelectedModelsInEditor(WizardNewSmartMDSDModel.this.workbench, selectedModelTypes);
                            Session session = ModelingProjectFactory.getProjectSession(selectedProject, monitor);
                            if (session != null) {
                                ModelingProjectFactory.selectViewpoints(selectedProject, session, selectedModelTypes, monitor);
                                ModelingProjectFactory.openSelectedDiagramEditorsForSession(selectedProject, session, selectedModelTypes, monitor);
                            }
                        }
                        ++n2;
                    }
                }
            }
        };
        try {
            boolean doFork = false;
            boolean cancelable = true;
            this.getContainer().run(doFork, cancelable, (IRunnableWithProgress)createSelectedModelsOperation);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            result = false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle("New SmartMDSD Model Wizard");
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IProject selectedProject;
        if (page.equals((Object)this.pageOne) && (selectedProject = this.pageOne.getSelectedProject()) != null) {
            this.pageTwo.setModelTypeEntriesFrom(selectedProject);
        }
        return super.getNextPage(page);
    }
}

