/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Vineet Nagrath, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtend.open62541.compiler;

import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaXmlParser;

@SuppressWarnings("all")
public interface OpcUaServer {
  public abstract String getOpcUaDevice_Server_HeaderFileName(final String objectName);
  
  public abstract String getOpcUaDevice_Server_SourceFileName(final String objectName);
  
  public abstract CharSequence compileOpcUaDevice_Server_HeaderFileContent(final String objectName, final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList, final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList);
  
  public abstract CharSequence compileOpcUaDevice_Server_SourceFileContent(final String objectName, final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList, final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList);
}
