/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Vineet Nagrath, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtend.open62541.compiler;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.smartmdsd.xtend.open62541.compiler.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaObjectInterfaceImpl;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaServer;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaXmlParser;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class OpcUaServerImpl implements OpcUaServer {
  @Inject
  @Extension
  private CopyrightHelpers _copyrightHelpers;
  
  @Inject
  @Extension
  private OpcUaObjectInterfaceImpl _opcUaObjectInterfaceImpl;
  
  @Inject
  @Extension
  private OpcUaXmlParser _opcUaXmlParser;
  
  @Override
  public String getOpcUaDevice_Server_HeaderFileName(final String objectName) {
    return (("OpcUa" + objectName) + ".hh");
  }
  
  @Override
  public String getOpcUaDevice_Server_SourceFileName(final String objectName) {
    return (("OpcUa" + objectName) + ".cc");
  }
  
  @Override
  public CharSequence compileOpcUaDevice_Server_HeaderFileContent(final String objectName, final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList, final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#ifndef _");
    String _upperCase = objectName.toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_HH");
    _builder.newLineIfNotEmpty();
    _builder.append("#define _");
    String _upperCase_1 = objectName.toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_HH");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include <OpcUaGenericServer.hh>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include \"");
    String _opcUaDevice_Interface_HeaderFileName = this._opcUaObjectInterfaceImpl.getOpcUaDevice_Interface_HeaderFileName(objectName);
    _builder.append(_opcUaDevice_Interface_HeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("namespace OPCUA {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("class ");
    _builder.append(objectName);
    _builder.append(" : public OPCUA::GenericServer");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("private:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(objectName, "\t");
    _builder.append("Interface *controller;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/** this method implements the server space for ");
    _builder.append(objectName, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  Please use the methods addVariableNode() and addMethodNode() to define the server space.");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  This method is automatically called from within the method run()");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  @return true on success or false if something went wrong during initialization");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  @sa addVariableNode()");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  @sa addMethodNode()");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual bool createServerSpace() override;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/** overload this method to get notified about read requests from a remote client for the provided variable name");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  This upcall handler is triggered each time the OPC UA variable (identified by the browseName) is read from a remote client.");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  In case the variable is read internally from within the server, this method is not called as this might easily");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  cause infinite loops. You can overload this method in derived classes to implement a specific behavior for");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  incoming read requests.");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  @param browseName the browse name of the OPC UA variable");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  @param value output argument receives the new value of the OPC UA variable");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void handleOnRead(const std::string &browseName, Variant &value) override;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/** this method notifies about write requests from a remote client for the provided variable name");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  This upcall handler is triggered each time the OPC UA variable (identified by the browseName) is written from a remote client.");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  You can overload this method in derived classes to implement a specific behavior for incoming write requests.");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  @param browseName the browse name of the OPC UA variable");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  @param value the new value of the OPC UA variable");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void handleOnWrite(const std::string &browseName, const Variant &value) override;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/** this method notifies about remote method calls from a remote client for the provided OPC UA Method name");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  This upcall handler is triggered each time the OPC UA Method (identified by the browseName) is called from a remote client.");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  You can overload this method in derived classes to implement a specific behavior for incoming method calls.");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  @param browseName the browse name of the OPC UA variable");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  @param inputs a vector of input-argument-values");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*  @param outputs a reference to a vector to store the resulting output-argument-values");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void handleMethodCall(const std::string &browseName, const std::vector<Variant> &inputs, std::vector<Variant> &outputs) override;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(objectName, "\t");
    _builder.append("(");
    _builder.append(objectName, "\t");
    _builder.append("Interface *controller, const unsigned short &portNumber=4840, const bool &activateSignalHandler=true);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("virtual ~");
    _builder.append(objectName, "\t");
    _builder.append("();");
    _builder.newLineIfNotEmpty();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("} /* namespace OPCUA */");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif /* _");
    String _upperCase_2 = objectName.toUpperCase();
    _builder.append(_upperCase_2);
    _builder.append("_HH */");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Override
  public CharSequence compileOpcUaDevice_Server_SourceFileContent(final String objectName, final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList, final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    String _opcUaDevice_Server_HeaderFileName = this.getOpcUaDevice_Server_HeaderFileName(objectName);
    _builder.append(_opcUaDevice_Server_HeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("namespace OPCUA {");
    _builder.newLine();
    _builder.newLine();
    _builder.append(objectName);
    _builder.append("::");
    _builder.append(objectName);
    _builder.append("(");
    _builder.append(objectName);
    _builder.append("Interface *controller, const unsigned short &portNumber, const bool &activateSignalHandler)");
    _builder.newLineIfNotEmpty();
    _builder.append(":\tOPCUA::GenericServer(\"");
    _builder.append(objectName);
    _builder.append("\", 1, portNumber, activateSignalHandler)");
    _builder.newLineIfNotEmpty();
    _builder.append(",\tcontroller(controller)");
    _builder.newLine();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.append(objectName);
    _builder.append("::~");
    _builder.append(objectName);
    _builder.append("()");
    _builder.newLineIfNotEmpty();
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    _builder.append("bool ");
    _builder.append(objectName);
    _builder.append("::createServerSpace() ");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetENTITY entity : entityList) {
        _builder.append("\t");
        _builder.append("// add variable ");
        _builder.append(entity.name, "\t");
        _builder.newLineIfNotEmpty();
        {
          if (((entity.userAccessLevel == 2) || (entity.userAccessLevel == 3))) {
            _builder.append("\t");
            _builder.append("bool ");
            _builder.append(entity.name, "\t");
            _builder.append("ReadOnly = false;");
            _builder.newLineIfNotEmpty();
          } else {
            _builder.append("\t");
            _builder.append("bool ");
            _builder.append(entity.name, "\t");
            _builder.append("ReadOnly = true;");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        String _cppType = this._opcUaXmlParser.getCppType(entity.type);
        _builder.append(_cppType, "\t");
        _builder.append(" ");
        _builder.append(entity.name, "\t");
        _builder.append("Value = ");
        String _cppDefaultValue = this._opcUaXmlParser.getCppDefaultValue(entity.type);
        _builder.append(_cppDefaultValue, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if(addVariableNode(\"");
        _builder.append(entity.name, "\t");
        _builder.append("\", ");
        _builder.append(entity.name, "\t");
        _builder.append("Value, ");
        _builder.append(entity.name, "\t");
        _builder.append("ReadOnly) != true) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("std::cout << \"failed adding ");
        _builder.append(entity.name, "\t\t");
        _builder.append("\" << std::endl;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetMETHOD method : methodList) {
        _builder.append("\t");
        _builder.append("// add the method ");
        _builder.append(method.name, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("std::map<std::string, OPCUA::Variant> ");
        _builder.append(method.name, "\t");
        _builder.append("InputArguments;");
        _builder.newLineIfNotEmpty();
        {
          for(final OpcUaXmlParser.SeRoNetARGUMENT input : method.inputArguments) {
            {
              if ((input.ValueRank == (-1))) {
                _builder.append("\t");
                _builder.append(method.name, "\t");
                _builder.append("InputArguments[\"");
                _builder.append(input.name, "\t");
                _builder.append("\"] = ");
                String _UADataTypeDefaultValues = input.UADataTypeDefaultValues();
                _builder.append(_UADataTypeDefaultValues, "\t");
                _builder.append(";\t\t\t\t");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t");
                _builder.append(method.name, "\t");
                _builder.append("InputArguments[\"");
                _builder.append(input.name, "\t");
                _builder.append("\"] = std::vector<");
                String _DataTypeString = input.DataTypeString();
                _builder.append(_DataTypeString, "\t");
                _builder.append(">(");
                _builder.append(input.ArrayDimensions, "\t");
                _builder.append(",");
                String _UADataTypeDefaultValues_1 = input.UADataTypeDefaultValues();
                _builder.append(_UADataTypeDefaultValues_1, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t");
        _builder.append("std::map<std::string, OPCUA::Variant> ");
        _builder.append(method.name, "\t");
        _builder.append("OutputArguments;");
        _builder.newLineIfNotEmpty();
        {
          for(final OpcUaXmlParser.SeRoNetARGUMENT output : method.outputArguments) {
            {
              if ((output.ValueRank == (-1))) {
                _builder.append("\t");
                _builder.append(method.name, "\t");
                _builder.append("OutputArguments[\"");
                _builder.append(output.name, "\t");
                _builder.append("\"] = ");
                String _UADataTypeDefaultValues_2 = output.UADataTypeDefaultValues();
                _builder.append(_UADataTypeDefaultValues_2, "\t");
                _builder.append(";\t\t\t\t");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t");
                _builder.append(method.name, "\t");
                _builder.append("OutputArguments[\"");
                _builder.append(output.name, "\t");
                _builder.append("\"] = std::vector<");
                String _DataTypeString_1 = output.DataTypeString();
                _builder.append(_DataTypeString_1, "\t");
                _builder.append(">(");
                _builder.append(output.ArrayDimensions, "\t");
                _builder.append(",");
                String _UADataTypeDefaultValues_3 = output.UADataTypeDefaultValues();
                _builder.append(_UADataTypeDefaultValues_3, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(addMethodNode(\"");
        _builder.append(method.name, "\t");
        _builder.append("\", ");
        _builder.append(method.name, "\t");
        _builder.append("InputArguments, ");
        _builder.append(method.name, "\t");
        _builder.append("OutputArguments) != true) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("std::cout << \"failed adding ");
        _builder.append(method.name, "\t\t");
        _builder.append("\" << std::endl;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.append("return true;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    _builder.append(objectName);
    _builder.append("::handleOnRead(const std::string &browseName, Variant &value)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetENTITY entity_1 : entityList) {
        _builder.append("\t");
        {
          OpcUaXmlParser.SeRoNetENTITY _head = IterableExtensions.<OpcUaXmlParser.SeRoNetENTITY>head(entityList);
          boolean _notEquals = (!Objects.equal(entity_1, _head));
          if (_notEquals) {
            _builder.append("} else ");
          }
        }
        _builder.append("if(browseName == \"");
        _builder.append(entity_1.name, "\t");
        _builder.append("\") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        String _cppType_1 = this._opcUaXmlParser.getCppType(entity_1.type);
        _builder.append(_cppType_1, "\t\t");
        _builder.append(" ");
        _builder.append(entity_1.name, "\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("if(controller->get");
        String _firstUpper = StringExtensions.toFirstUpper(entity_1.name);
        _builder.append(_firstUpper, "\t\t");
        _builder.append("(");
        _builder.append(entity_1.name, "\t\t");
        _builder.append(") == OPCUA::StatusCode::ALL_OK) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("value = ");
        _builder.append(entity_1.name, "\t\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        {
          OpcUaXmlParser.SeRoNetENTITY _last = IterableExtensions.<OpcUaXmlParser.SeRoNetENTITY>last(entityList);
          boolean _equals = Objects.equal(entity_1, _last);
          if (_equals) {
            _builder.append("}");
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    _builder.append(objectName);
    _builder.append("::handleOnWrite(const std::string &browseName, const Variant &value)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// propagate the write calls to respective upcalls (only if write access is activated)");
    _builder.newLine();
    {
      Iterable<OpcUaXmlParser.SeRoNetENTITY> _filterWritableEntities = this.filterWritableEntities(entityList);
      for(final OpcUaXmlParser.SeRoNetENTITY entity_2 : _filterWritableEntities) {
        _builder.append("\t");
        {
          OpcUaXmlParser.SeRoNetENTITY _head_1 = IterableExtensions.<OpcUaXmlParser.SeRoNetENTITY>head(this.filterWritableEntities(entityList));
          boolean _notEquals_1 = (!Objects.equal(entity_2, _head_1));
          if (_notEquals_1) {
            _builder.append("} else ");
          }
        }
        _builder.append("if(browseName == \"");
        _builder.append(entity_2.name, "\t");
        _builder.append("\") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("controller->set");
        String _firstUpper_1 = StringExtensions.toFirstUpper(entity_2.name);
        _builder.append(_firstUpper_1, "\t\t");
        _builder.append("(value);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        {
          OpcUaXmlParser.SeRoNetENTITY _last_1 = IterableExtensions.<OpcUaXmlParser.SeRoNetENTITY>last(this.filterWritableEntities(entityList));
          boolean _equals_1 = Objects.equal(entity_2, _last_1);
          if (_equals_1) {
            _builder.append("}");
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    _builder.append(objectName);
    _builder.append("::handleMethodCall(const std::string &browseName, const std::vector<Variant> &inputs, std::vector<Variant> &outputs)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetMETHOD method_1 : methodList) {
        _builder.append("\t");
        {
          OpcUaXmlParser.SeRoNetMETHOD _head_2 = IterableExtensions.<OpcUaXmlParser.SeRoNetMETHOD>head(methodList);
          boolean _notEquals_2 = (!Objects.equal(method_1, _head_2));
          if (_notEquals_2) {
            _builder.append("} else ");
          }
        }
        _builder.append("if(browseName == \"");
        _builder.append(method_1.name, "\t");
        _builder.append("\") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("// expecting an input vector of size ");
        int _size = method_1.inputArguments.size();
        _builder.append(_size, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("if(inputs.size() == ");
        int _size_1 = method_1.inputArguments.size();
        _builder.append(_size_1, "\t\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("// input variables");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        int count = (-1);
        _builder.newLineIfNotEmpty();
        {
          for(final OpcUaXmlParser.SeRoNetARGUMENT input_1 : method_1.inputArguments) {
            {
              if ((input_1.DataTypeIdentifier == OpcUaXmlParser.SeRoNetARGUMENT.UA_TYPES_STRING)) {
                _builder.append("\t");
                _builder.append("\t\t");
                String _DataTypeString_2 = input_1.DataTypeString();
                _builder.append(_DataTypeString_2, "\t\t\t");
                _builder.append(" ");
                _builder.append(input_1.name, "\t\t\t");
                _builder.append(" = inputs[");
                _builder.append(count = (count + 1), "\t\t\t");
                _builder.append("].toString();");
                _builder.newLineIfNotEmpty();
              } else {
                _builder.append("\t");
                _builder.append("\t\t");
                String _DataTypeString_3 = input_1.DataTypeString();
                _builder.append(_DataTypeString_3, "\t\t\t");
                _builder.append(" ");
                _builder.append(input_1.name, "\t\t\t");
                _builder.append(" = inputs[");
                _builder.append(count = (count + 1), "\t\t\t");
                _builder.append("];");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("// output variables");
        _builder.newLine();
        {
          for(final OpcUaXmlParser.SeRoNetARGUMENT output_1 : method_1.outputArguments) {
            _builder.append("\t");
            _builder.append("\t\t");
            String _DataTypeString_4 = output_1.DataTypeString();
            _builder.append(_DataTypeString_4, "\t\t\t");
            _builder.append(" ");
            _builder.append(output_1.name, "\t\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("// method call propagation");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("controller->call");
        String _firstUpper_2 = StringExtensions.toFirstUpper(method_1.name);
        _builder.append(_firstUpper_2, "\t\t\t");
        _builder.append("(");
        String _cppMethodArgumentsCall = this._opcUaXmlParser.getCppMethodArgumentsCall(method_1);
        _builder.append(_cppMethodArgumentsCall, "\t\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("// fill output vector");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t");
        _builder.append("outputs.resize(");
        int _size_2 = method_1.outputArguments.size();
        _builder.append(_size_2, "\t\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t");
        int count2 = (-1);
        _builder.newLineIfNotEmpty();
        {
          for(final OpcUaXmlParser.SeRoNetARGUMENT output_2 : method_1.outputArguments) {
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("outputs[");
            _builder.append(count2 = (count2 + 1), "\t\t\t");
            _builder.append("] = ");
            _builder.append(output_2.name, "\t\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        {
          OpcUaXmlParser.SeRoNetMETHOD _last_2 = IterableExtensions.<OpcUaXmlParser.SeRoNetMETHOD>last(methodList);
          boolean _equals_2 = Objects.equal(method_1, _last_2);
          if (_equals_2) {
            _builder.append("}");
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("} /* namespace OPCUA */");
    _builder.newLine();
    return _builder;
  }
  
  public Iterable<OpcUaXmlParser.SeRoNetENTITY> filterWritableEntities(final Iterable<OpcUaXmlParser.SeRoNetENTITY> entities) {
    final Function1<OpcUaXmlParser.SeRoNetENTITY, Boolean> _function = (OpcUaXmlParser.SeRoNetENTITY it) -> {
      return Boolean.valueOf(((it.userAccessLevel == 2) || (it.userAccessLevel == 3)));
    };
    return IterableExtensions.<OpcUaXmlParser.SeRoNetENTITY>filter(entities, _function);
  }
}
