/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Vineet Nagrath, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtend.open62541.compiler;

import com.google.common.base.Objects;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SuppressWarnings("all")
public class OpcUaXmlParser {
  public static class SeRoNetNodeId {
    public int ns = 1001;
    
    public int i = 1;
  }
  
  public static class SeRoNetENTITY {
    public String name;
    
    public String commObjectCall;
    
    public String type;
    
    public int userAccessLevel;
    
    public OpcUaXmlParser.SeRoNetNodeId nodeid;
    
    public OpcUaXmlParser.SeRoNetNodeId Parent_nodeid;
    
    public Collection<OpcUaXmlParser.SeRoNetNodeId> Children_nodeid = new ArrayList<OpcUaXmlParser.SeRoNetNodeId>();
    
    public String UAuserAccessLevel() {
      String _switchResult = null;
      final int userAccessLevel = this.userAccessLevel;
      switch (userAccessLevel) {
        case 1:
          _switchResult = "UA_ACCESSLEVELMASK_READ";
          break;
        case 2:
          _switchResult = "UA_ACCESSLEVELMASK_WRITE";
          break;
        case 3:
          _switchResult = "UA_ACCESSLEVELMASK_READ | UA_ACCESSLEVELMASK_WRITE";
          break;
      }
      return _switchResult;
    }
    
    public String UADataTypeIdentifierString() {
      String _switchResult = null;
      final String type = this.type;
      if (type != null) {
        switch (type) {
          case "Boolean":
            _switchResult = "UA_Boolean";
            break;
          case "Int32":
            _switchResult = "UA_Int32";
            break;
          case "Double":
            _switchResult = "UA_Double";
            break;
          case "String":
            _switchResult = "UA_String";
            break;
        }
      }
      return _switchResult;
    }
    
    public String UADataTypeDefaultValues() {
      String _switchResult = null;
      final String type = this.type;
      if (type != null) {
        switch (type) {
          case "Boolean":
            _switchResult = "false";
            break;
          case "Int32":
            _switchResult = "0";
            break;
          case "Double":
            _switchResult = "0.0";
            break;
          case "String":
            _switchResult = "UA_LOCALIZEDTEXT_ALLOC(\"NA\")";
            break;
        }
      }
      return _switchResult;
    }
    
    public String DataTypeIdentifierString() {
      String _switchResult = null;
      final String type = this.type;
      if (type != null) {
        switch (type) {
          case "Boolean":
            _switchResult = "UA_TYPES_BOOLEAN";
            break;
          case "Int32":
            _switchResult = "UA_TYPES_INT32";
            break;
          case "Double":
            _switchResult = "UA_TYPES_DOUBLE";
            break;
          case "String":
            _switchResult = "UA_TYPES_STRING";
            break;
        }
      }
      return _switchResult;
    }
    
    public String DataTypeString() {
      String _switchResult = null;
      final String type = this.type;
      if (type != null) {
        switch (type) {
          case "Boolean":
            _switchResult = "bool";
            break;
          case "Int32":
            _switchResult = "int";
            break;
          case "Double":
            _switchResult = "double";
            break;
          case "String":
            _switchResult = "std::string";
            break;
        }
      }
      return _switchResult;
    }
    
    public static int UA_ACCESSLEVELMASK_READ = (0x01 << 0);
    
    public static int UA_ACCESSLEVELMASK_WRITE = (0x01 << 1);
    
    public static int UA_ACCESSLEVELMASK_HISTORYREAD = (0x01 << 2);
    
    public static int UA_ACCESSLEVELMASK_HISTORYWRITE = (0x01 << 3);
    
    public static int UA_ACCESSLEVELMASK_SEMANTICCHANGE = (0x01 << 4);
    
    public static int UA_ACCESSLEVELMASK_STATUSWRITE = (0x01 << 5);
    
    public static int UA_ACCESSLEVELMASK_TIMESTAMPWRITE = (0x01 << 6);
    
    public String Display() {
      String _xblockexpression = null;
      {
        String _DataTypeString = this.DataTypeString();
        String _plus = ((((((((((("(" + Integer.valueOf(this.Parent_nodeid.ns)) + ", ") + Integer.valueOf(this.Parent_nodeid.i)) + ")-->(") + Integer.valueOf(this.nodeid.ns)) + ", ") + Integer.valueOf(this.nodeid.i)) + ") ENTITY:   Name:") + this.name) + "  DataType:") + _DataTypeString);
        String _plus_1 = (_plus + "  UserAccessLevel:");
        String _plus_2 = (_plus_1 + Integer.valueOf(this.userAccessLevel));
        String _plus_3 = (_plus_2 + "  Children_nodeids:||");
        InputOutput.<String>print(_plus_3);
        for (final OpcUaXmlParser.SeRoNetNodeId ch : this.Children_nodeid) {
          String _plus_4 = (Integer.valueOf(ch.ns) + ", ");
          String _plus_5 = (_plus_4 + Integer.valueOf(ch.i));
          String _plus_6 = (_plus_5 + "||");
          InputOutput.<String>print(_plus_6);
        }
        _xblockexpression = InputOutput.<String>println("");
      }
      return _xblockexpression;
    }
  }
  
  public static class SeRoNetARGUMENT {
    public String name;
    
    public int DataTypeIdentifier;
    
    public static int UA_TYPES_BOOLEAN = 1;
    
    public static int UA_TYPES_INT32 = 6;
    
    public static int UA_TYPES_DOUBLE = 11;
    
    public static int UA_TYPES_STRING = 12;
    
    public String UADataTypeIdentifierString() {
      String _switchResult = null;
      final int DataTypeIdentifier = this.DataTypeIdentifier;
      switch (DataTypeIdentifier) {
        case 1:
          _switchResult = "UA_Boolean";
          break;
        case 6:
          _switchResult = "UA_Int32";
          break;
        case 11:
          _switchResult = "UA_Double";
          break;
        case 12:
          _switchResult = "UA_String";
          break;
      }
      return _switchResult;
    }
    
    public String UADataTypeDefaultValues() {
      String _switchResult = null;
      final int DataTypeIdentifier = this.DataTypeIdentifier;
      switch (DataTypeIdentifier) {
        case 1:
          _switchResult = "false";
          break;
        case 6:
          _switchResult = "0";
          break;
        case 11:
          _switchResult = "0.0";
          break;
        case 12:
          _switchResult = "std::string()";
          break;
      }
      return _switchResult;
    }
    
    public String DataTypeIdentifierString() {
      String _switchResult = null;
      final int DataTypeIdentifier = this.DataTypeIdentifier;
      switch (DataTypeIdentifier) {
        case 1:
          _switchResult = "UA_TYPES_BOOLEAN";
          break;
        case 6:
          _switchResult = "UA_TYPES_INT32";
          break;
        case 11:
          _switchResult = "UA_TYPES_DOUBLE";
          break;
        case 12:
          _switchResult = "UA_TYPES_STRING";
          break;
      }
      return _switchResult;
    }
    
    public String DataTypeString() {
      String _switchResult = null;
      final int DataTypeIdentifier = this.DataTypeIdentifier;
      switch (DataTypeIdentifier) {
        case 1:
          _switchResult = "bool";
          break;
        case 6:
          _switchResult = "int";
          break;
        case 11:
          _switchResult = "double";
          break;
        case 12:
          _switchResult = "std::string";
          break;
      }
      return _switchResult;
    }
    
    public int ValueRank;
    
    public int ArrayDimensions;
    
    public OpcUaXmlParser.SeRoNetNodeId nodeid;
    
    public OpcUaXmlParser.SeRoNetNodeId Parent_nodeid;
    
    public String Display() {
      String _DataTypeString = this.DataTypeString();
      String _plus = ((((((((("(" + Integer.valueOf(this.Parent_nodeid.ns)) + ", ") + Integer.valueOf(this.Parent_nodeid.i)) + ")-->(") + Integer.valueOf(this.nodeid.ns)) + ", ") + Integer.valueOf(this.nodeid.i)) + ") ARGUMENT: ") + _DataTypeString);
      String _plus_1 = (_plus + " ");
      String _plus_2 = (_plus_1 + this.name);
      String _plus_3 = (_plus_2 + " DataTypeIdentifier:");
      String _plus_4 = (_plus_3 + Integer.valueOf(this.DataTypeIdentifier));
      String _plus_5 = (_plus_4 + " ValueRank:");
      String _plus_6 = (_plus_5 + Integer.valueOf(this.ValueRank));
      String _plus_7 = (_plus_6 + " ArrayDimensions:");
      String _plus_8 = (_plus_7 + Integer.valueOf(this.ArrayDimensions));
      return InputOutput.<String>println(_plus_8);
    }
  }
  
  public static class SeRoNetMETHOD {
    public String name;
    
    public OpcUaXmlParser.SeRoNetNodeId nodeid;
    
    public OpcUaXmlParser.SeRoNetNodeId Parent_nodeid;
    
    public Collection<OpcUaXmlParser.SeRoNetNodeId> Children_nodeid = new ArrayList<OpcUaXmlParser.SeRoNetNodeId>();
    
    public Collection<OpcUaXmlParser.SeRoNetARGUMENT> inputArguments = new ArrayList<OpcUaXmlParser.SeRoNetARGUMENT>();
    
    public Collection<OpcUaXmlParser.SeRoNetARGUMENT> outputArguments = new ArrayList<OpcUaXmlParser.SeRoNetARGUMENT>();
    
    public String DisplaySmall() {
      String _xblockexpression = null;
      {
        InputOutput.<String>print((((((((("(" + Integer.valueOf(this.Parent_nodeid.ns)) + ", ") + Integer.valueOf(this.Parent_nodeid.i)) + ")-->(") + Integer.valueOf(this.nodeid.ns)) + ", ") + Integer.valueOf(this.nodeid.i)) + ") METHOD: ["));
        for (final OpcUaXmlParser.SeRoNetARGUMENT elem : this.inputArguments) {
          String _DataTypeString = elem.DataTypeString();
          String _plus = ("   " + _DataTypeString);
          String _plus_1 = (_plus + " ");
          String _plus_2 = (_plus_1 + elem.name);
          InputOutput.<String>print(_plus_2);
        }
        InputOutput.<String>print((("    ] = " + this.name) + " ("));
        for (final OpcUaXmlParser.SeRoNetARGUMENT elem_1 : this.outputArguments) {
          String _DataTypeString_1 = elem_1.DataTypeString();
          String _plus_3 = ("   " + _DataTypeString_1);
          String _plus_4 = (_plus_3 + " ");
          String _plus_5 = (_plus_4 + elem_1.name);
          InputOutput.<String>print(_plus_5);
        }
        InputOutput.<String>print("    )");
        _xblockexpression = InputOutput.<String>println((((((((" NodeId:" + Integer.valueOf(this.nodeid.ns)) + ", ") + Integer.valueOf(this.nodeid.i)) + "  Parent_NodeId:") + Integer.valueOf(this.Parent_nodeid.ns)) + ", ") + Integer.valueOf(this.Parent_nodeid.i)));
      }
      return _xblockexpression;
    }
    
    public void Display() {
      InputOutput.<String>print((((((((("(" + Integer.valueOf(this.Parent_nodeid.ns)) + ", ") + Integer.valueOf(this.Parent_nodeid.i)) + ")-->(") + Integer.valueOf(this.nodeid.ns)) + ", ") + Integer.valueOf(this.nodeid.i)) + ") METHOD: ["));
      for (final OpcUaXmlParser.SeRoNetARGUMENT elem : this.outputArguments) {
        String _DataTypeString = elem.DataTypeString();
        String _plus = ("   " + _DataTypeString);
        String _plus_1 = (_plus + " ");
        String _plus_2 = (_plus_1 + elem.name);
        InputOutput.<String>print(_plus_2);
      }
      InputOutput.<String>print((("    ] = " + this.name) + " ("));
      for (final OpcUaXmlParser.SeRoNetARGUMENT elem_1 : this.inputArguments) {
        String _DataTypeString_1 = elem_1.DataTypeString();
        String _plus_3 = ("   " + _DataTypeString_1);
        String _plus_4 = (_plus_3 + " ");
        String _plus_5 = (_plus_4 + elem_1.name);
        InputOutput.<String>print(_plus_5);
      }
      InputOutput.<String>print(("    )  -->" + "  Children_nodeids:||"));
      for (final OpcUaXmlParser.SeRoNetNodeId ch : this.Children_nodeid) {
        String _plus_6 = (Integer.valueOf(ch.ns) + ", ");
        String _plus_7 = (_plus_6 + Integer.valueOf(ch.i));
        String _plus_8 = (_plus_7 + "||");
        InputOutput.<String>print(_plus_8);
      }
      InputOutput.<String>println("");
      for (final OpcUaXmlParser.SeRoNetARGUMENT elem_2 : this.inputArguments) {
        {
          InputOutput.<String>print("        IN--");
          elem_2.Display();
        }
      }
      for (final OpcUaXmlParser.SeRoNetARGUMENT elem_3 : this.outputArguments) {
        {
          InputOutput.<String>print("       OUT--");
          elem_3.Display();
        }
      }
    }
  }
  
  public OpcUaXmlParser.SeRoNetNodeId getNodeIdFromString(final String StartString) {
    final OpcUaXmlParser.SeRoNetNodeId nid = new OpcUaXmlParser.SeRoNetNodeId();
    int _indexOf = StartString.indexOf("=");
    int _plus = (_indexOf + 1);
    nid.ns = Integer.parseInt(StartString.substring(_plus, StartString.indexOf(";")));
    String StartString2 = StartString.substring(StartString.indexOf("i"), StartString.length());
    int _indexOf_1 = StartString2.indexOf("=");
    int _plus_1 = (_indexOf_1 + 1);
    nid.i = Integer.parseInt(StartString2.substring(_plus_1, StartString2.length()));
    return nid;
  }
  
  public String getObjectName(final File xmlFile) {
    try {
      boolean verbose = true;
      String objectName = "NotFound";
      boolean _exists = xmlFile.exists();
      if (_exists) {
        final DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        final DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        final Document doc = dBuilder.parse(xmlFile);
        doc.getDocumentElement().normalize();
        final NodeList nl = doc.getDocumentElement().getChildNodes();
        for (int i = 0; (i < nl.getLength()); i++) {
          {
            final Node uel = nl.item(i);
            if ((uel instanceof Element)) {
              final Element el = ((Element)uel);
              final String nodeName = el.getNodeName();
              boolean _equals = Objects.equal(nodeName, "UAObjectType");
              if (_equals) {
                final NodeList cn = el.getChildNodes();
                for (int j = 0; (j < cn.getLength()); j++) {
                  {
                    final Node uuel = cn.item(j);
                    if ((uuel instanceof Element)) {
                      final Element cel = ((Element)uuel);
                      final String childNode = cel.getNodeName();
                      final String childNodeName = cel.getTextContent();
                      boolean _equals_1 = Objects.equal(childNode, "DisplayName");
                      if (_equals_1) {
                        objectName = childNodeName;
                        if (verbose) {
                          InputOutput.<String>println(("object found " + objectName));
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      return objectName;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public Iterable<OpcUaXmlParser.SeRoNetENTITY> getEntityList(final File xmlFile) {
    try {
      ArrayList<OpcUaXmlParser.SeRoNetENTITY> entityList = new ArrayList<OpcUaXmlParser.SeRoNetENTITY>();
      boolean verbose = true;
      boolean _exists = xmlFile.exists();
      if (_exists) {
        final DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        final DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        final Document doc = dBuilder.parse(xmlFile);
        doc.getDocumentElement().normalize();
        if ((verbose == true)) {
          InputOutput.<String>println("||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||");
        }
        if ((verbose == true)) {
          InputOutput.<String>println("=============================================================================");
        }
        final NodeList nl = doc.getDocumentElement().getChildNodes();
        for (int i = 0; (i < nl.getLength()); i++) {
          {
            final Node uel = nl.item(i);
            if ((uel instanceof Element)) {
              final Element el = ((Element)uel);
              final String nodeName = el.getNodeName();
              final String dataType = el.getAttribute("DataType");
              final String userAccessLevel = el.getAttribute("UserAccessLevel");
              final String EntityNodeId = el.getAttribute("NodeId");
              final String EntityParentNodeId = el.getAttribute("ParentNodeId");
              boolean _equals = Objects.equal(nodeName, "UAVariable");
              if (_equals) {
                final OpcUaXmlParser.SeRoNetENTITY entity = new OpcUaXmlParser.SeRoNetENTITY();
                final Collection<OpcUaXmlParser.SeRoNetNodeId> New_Children_nodeid = new ArrayList<OpcUaXmlParser.SeRoNetNodeId>();
                boolean addNewEntity = false;
                final NodeList cn = el.getChildNodes();
                for (int j = 0; (j < cn.getLength()); j++) {
                  {
                    final Node uuel = cn.item(j);
                    if ((uuel instanceof Element)) {
                      final Element cel = ((Element)uuel);
                      final String childNode = cel.getNodeName();
                      final String childNodeName = cel.getTextContent();
                      boolean _equals_1 = Objects.equal(childNode, "DisplayName");
                      if (_equals_1) {
                        if (((!Objects.equal(childNodeName, "InputArguments")) && (!Objects.equal(childNodeName, "OutputArguments")))) {
                          entity.name = childNodeName;
                          entity.type = dataType;
                          entity.userAccessLevel = Integer.parseInt(userAccessLevel);
                          entity.nodeid = this.getNodeIdFromString(EntityNodeId);
                          entity.Parent_nodeid = this.getNodeIdFromString(EntityParentNodeId);
                          addNewEntity = true;
                        }
                      }
                      boolean _equals_2 = Objects.equal(childNode, "References");
                      if (_equals_2) {
                        final NodeList Refs = cel.getChildNodes();
                        for (int r = 0; (r < Refs.getLength()); r++) {
                          {
                            final Node Ref = Refs.item(r);
                            if ((Ref instanceof Element)) {
                              final String RefChildNodeType = ((Element)Ref).getAttribute("ReferenceType");
                              final String IsForward = ((Element)Ref).getAttribute("IsForward");
                              if ((Objects.equal(RefChildNodeType, "HasComponent") && (!Objects.equal(IsForward, "false")))) {
                                final String childnodeid = ((Element)Ref).getTextContent();
                                New_Children_nodeid.add(this.getNodeIdFromString(childnodeid));
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
                if (addNewEntity) {
                  entity.Children_nodeid = New_Children_nodeid;
                  if ((verbose == true)) {
                    entity.Display();
                  }
                  entityList.add(entity);
                }
              }
            }
          }
        }
        if ((verbose == true)) {
          InputOutput.<String>println("=============================================================================");
        }
      }
      return entityList;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public Iterable<OpcUaXmlParser.SeRoNetMETHOD> getMethodList(final File xmlFile) {
    try {
      ArrayList<OpcUaXmlParser.SeRoNetMETHOD> methodList = new ArrayList<OpcUaXmlParser.SeRoNetMETHOD>();
      boolean verbose = true;
      boolean _exists = xmlFile.exists();
      if (_exists) {
        final DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        final DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        final Document doc = dBuilder.parse(xmlFile);
        doc.getDocumentElement().normalize();
        final NodeList nl = doc.getDocumentElement().getChildNodes();
        for (int i = 0; (i < nl.getLength()); i++) {
          {
            final Node uel = nl.item(i);
            if ((uel instanceof Element)) {
              final Element el = ((Element)uel);
              final String nodeName = el.getNodeName();
              final String MethodNodeId = el.getAttribute("NodeId");
              final String MethodParentNodeId = el.getAttribute("ParentNodeId");
              boolean _equals = Objects.equal(nodeName, "UAMethod");
              if (_equals) {
                final OpcUaXmlParser.SeRoNetMETHOD method = new OpcUaXmlParser.SeRoNetMETHOD();
                final Collection<OpcUaXmlParser.SeRoNetNodeId> New_Children_nodeid = new ArrayList<OpcUaXmlParser.SeRoNetNodeId>();
                boolean addNewMethod = false;
                final NodeList cn = el.getChildNodes();
                for (int j = 0; (j < cn.getLength()); j++) {
                  {
                    final Node uuel = cn.item(j);
                    if ((uuel instanceof Element)) {
                      final Element cel = ((Element)uuel);
                      final String childNode = cel.getNodeName();
                      final String childNodeName = cel.getTextContent();
                      boolean _equals_1 = Objects.equal(childNode, "References");
                      if (_equals_1) {
                        final NodeList Refs = cel.getChildNodes();
                        for (int r = 0; (r < Refs.getLength()); r++) {
                          {
                            final Node Ref = Refs.item(r);
                            if ((Ref instanceof Element)) {
                              final String RefChildNodeType = ((Element)Ref).getAttribute("ReferenceType");
                              final String IsForward = ((Element)Ref).getAttribute("IsForward");
                              if ((Objects.equal(RefChildNodeType, "HasProperty") && (!Objects.equal(IsForward, "false")))) {
                                final String childnodeid = ((Element)Ref).getTextContent();
                                New_Children_nodeid.add(this.getNodeIdFromString(childnodeid));
                              }
                            }
                          }
                        }
                      }
                      boolean _equals_2 = Objects.equal(childNode, "DisplayName");
                      if (_equals_2) {
                        method.name = childNodeName;
                        boolean verboseSAVED = verbose;
                        verbose = true;
                        for (int ib = 0; (ib < nl.getLength()); ib++) {
                          {
                            final Node B = nl.item(ib);
                            if ((B instanceof Element)) {
                              final Element C = ((Element)B);
                              final String C_Node = C.getNodeName();
                              final String C_ParentNodeId = C.getAttribute("ParentNodeId");
                              final String ArgumentNodeId = C.getAttribute("NodeId");
                              if ((Objects.equal(C_Node, "UAVariable") && Objects.equal(C_ParentNodeId, MethodNodeId))) {
                                final NodeList D = C.getChildNodes();
                                String F_InOrOutl = "";
                                for (int id = 0; (id < D.getLength()); id++) {
                                  {
                                    final Node E = D.item(id);
                                    if ((E instanceof Element)) {
                                      final Element F = ((Element)E);
                                      final String F_Node = F.getNodeName();
                                      final String F_NodeName = F.getTextContent();
                                      boolean _equals_3 = Objects.equal(F_Node, "DisplayName");
                                      if (_equals_3) {
                                        F_InOrOutl = F_NodeName;
                                      }
                                    }
                                  }
                                }
                                boolean _notEquals = (!Objects.equal(F_InOrOutl, ""));
                                if (_notEquals) {
                                  for (int id = 0; (id < D.getLength()); id++) {
                                    {
                                      final Node E = D.item(id);
                                      if (((E instanceof Element) && E.getNodeName().equals("Value"))) {
                                        final NodeList F = E.getChildNodes();
                                        for (int iff = 0; (iff < F.getLength()); iff++) {
                                          {
                                            final Node G = F.item(iff);
                                            if (((G instanceof Element) && G.getNodeName().equals("ListOfExtensionObject"))) {
                                              final NodeList H = G.getChildNodes();
                                              for (int ih = 0; (ih < H.getLength()); ih++) {
                                                {
                                                  final Node I = H.item(ih);
                                                  if (((I instanceof Element) && I.getNodeName().equals("ExtensionObject"))) {
                                                    final NodeList J = I.getChildNodes();
                                                    for (int ij = 0; (ij < J.getLength()); ij++) {
                                                      {
                                                        final Node K = J.item(ij);
                                                        if (((K instanceof Element) && K.getNodeName().equals("Body"))) {
                                                          final NodeList L = K.getChildNodes();
                                                          for (int il = 0; (il < L.getLength()); il++) {
                                                            {
                                                              final Node M = L.item(il);
                                                              if (((M instanceof Element) && M.getNodeName().equals("Argument"))) {
                                                                OpcUaXmlParser.SeRoNetARGUMENT NewArg = new OpcUaXmlParser.SeRoNetARGUMENT();
                                                                final NodeList N = M.getChildNodes();
                                                                for (int in = 0; (in < N.getLength()); in++) {
                                                                  {
                                                                    final Node O = N.item(in);
                                                                    if ((((O instanceof Element) && O.getNodeName().equals("Name")) && (!O.getTextContent().equals("")))) {
                                                                      NewArg.name = O.getTextContent();
                                                                    }
                                                                    if ((((O instanceof Element) && O.getNodeName().equals("DataType")) && (!O.getTextContent().equals("")))) {
                                                                      final NodeList P = O.getChildNodes();
                                                                      for (int ip = 0; (ip < P.getLength()); ip++) {
                                                                        {
                                                                          final Node Q = P.item(ip);
                                                                          if ((((Q instanceof Element) && Q.getNodeName().equals("Identifier")) && (!Q.getTextContent().equals("")))) {
                                                                            String tmp = Q.getTextContent();
                                                                            tmp = tmp.substring(2);
                                                                            NewArg.DataTypeIdentifier = Integer.parseInt(tmp);
                                                                          }
                                                                        }
                                                                      }
                                                                    }
                                                                    if ((((O instanceof Element) && O.getNodeName().equals("ValueRank")) && (!O.getTextContent().equals("")))) {
                                                                      NewArg.ValueRank = Integer.parseInt(O.getTextContent());
                                                                    }
                                                                    if ((((O instanceof Element) && O.getNodeName().equals("ArrayDimensions")) && (!O.getTextContent().equals("")))) {
                                                                      NewArg.ArrayDimensions = Integer.parseInt(O.getTextContent());
                                                                    }
                                                                  }
                                                                }
                                                                NewArg.nodeid = this.getNodeIdFromString(ArgumentNodeId);
                                                                NewArg.Parent_nodeid = this.getNodeIdFromString(C_ParentNodeId);
                                                                boolean _equals_3 = Objects.equal(F_InOrOutl, "InputArguments");
                                                                if (_equals_3) {
                                                                  method.inputArguments.add(NewArg);
                                                                } else {
                                                                  method.outputArguments.add(NewArg);
                                                                }
                                                              }
                                                            }
                                                          }
                                                        }
                                                      }
                                                    }
                                                  }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                        method.nodeid = this.getNodeIdFromString(MethodNodeId);
                        method.Parent_nodeid = this.getNodeIdFromString(MethodParentNodeId);
                        addNewMethod = true;
                        verbose = verboseSAVED;
                      }
                    }
                  }
                }
                if (addNewMethod) {
                  method.Children_nodeid = New_Children_nodeid;
                  if ((verbose == true)) {
                    method.Display();
                  }
                  methodList.add(method);
                }
              }
            }
          }
        }
        if ((verbose == true)) {
          InputOutput.<String>println("=============================================================================");
        }
      }
      return methodList;
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public String getCppType(final String opcUaType) {
    String _switchResult = null;
    if (opcUaType != null) {
      switch (opcUaType) {
        case "Boolean":
          _switchResult = "bool";
          break;
        case "String":
          _switchResult = "std::string";
          break;
        case "Byte":
          _switchResult = "unsigned char";
          break;
        case "Int16":
          _switchResult = "short";
          break;
        case "UInt16":
          _switchResult = "unsigned short";
          break;
        case "Int32":
          _switchResult = "int";
          break;
        case "UInt32":
          _switchResult = "unsigned int";
          break;
        case "Int64":
          _switchResult = "long";
          break;
        case "UInt64":
          _switchResult = "unsigned long";
          break;
        case "Float":
          _switchResult = "float";
          break;
        case "Double":
          _switchResult = "double";
          break;
        case "std::vector<Boolean>":
          _switchResult = "std::vector<bool>";
          break;
        case "std::vector<String>":
          _switchResult = "std::vector<std::string>";
          break;
        case "std::vector<Byte>":
          _switchResult = "std::vector<unsigned char>";
          break;
        case "std::vector<Int16>":
          _switchResult = "std::vector<short>";
          break;
        case "std::vector<UInt16>":
          _switchResult = "std::vector<unsigned short>";
          break;
        case "std::vector<Int32>":
          _switchResult = "std::vector<int>";
          break;
        case "std::vector<UInt32>":
          _switchResult = "std::vector<unsigned int>";
          break;
        case "std::vector<Int64>":
          _switchResult = "std::vector<long>";
          break;
        case "std::vector<UInt64>":
          _switchResult = "std::vector<unsigned long>";
          break;
        case "std::vector<Float>":
          _switchResult = "std::vector<float>";
          break;
        case "std::vector<Double>":
          _switchResult = "std::vector<double>";
          break;
      }
    }
    return _switchResult;
  }
  
  public String getCppDefaultValue(final String opcUaType) {
    String _switchResult = null;
    if (opcUaType != null) {
      switch (opcUaType) {
        case "Boolean":
          _switchResult = "false";
          break;
        case "String":
          _switchResult = "std::string(\"\")";
          break;
        case "Byte":
          _switchResult = "0";
          break;
        case "Int16":
          _switchResult = "0";
          break;
        case "UInt16":
          _switchResult = "0";
          break;
        case "Int32":
          _switchResult = "0";
          break;
        case "UInt32":
          _switchResult = "0";
          break;
        case "Int64":
          _switchResult = "0";
          break;
        case "UInt64":
          _switchResult = "0";
          break;
        case "Float":
          _switchResult = "0.0";
          break;
        case "Double":
          _switchResult = "0.0";
          break;
        case "std::vector<Boolean>":
          _switchResult = "std::vector<bool>()";
          break;
        case "std::vector<String>":
          _switchResult = "std::vector<std::string>()";
          break;
        case "std::vector<Byte>":
          _switchResult = "std::vector<unsigned char>()";
          break;
        case "std::vector<Int16>":
          _switchResult = "std::vector<short>()";
          break;
        case "std::vector<UInt16>":
          _switchResult = "std::vector<unsigned short>()";
          break;
        case "std::vector<Int32>":
          _switchResult = "std::vector<int>()";
          break;
        case "std::vector<UInt32>":
          _switchResult = "std::vector<unsigned int>()";
          break;
        case "std::vector<Int64>":
          _switchResult = "std::vector<long>()";
          break;
        case "std::vector<UInt64>":
          _switchResult = "std::vector<unsigned long>()";
          break;
        case "std::vector<Float>":
          _switchResult = "std::vector<float>()";
          break;
        case "std::vector<Double>":
          _switchResult = "std::vector<double>()";
          break;
      }
    }
    return _switchResult;
  }
  
  public String getCppMethodArgumentsDef(final OpcUaXmlParser.SeRoNetMETHOD method) {
    String result = "";
    for (final OpcUaXmlParser.SeRoNetARGUMENT argIn : method.inputArguments) {
      {
        result = (result + "const ");
        if ((argIn.ValueRank == 1)) {
          String _DataTypeString = argIn.DataTypeString();
          String _plus = ((result + "std::vector<") + _DataTypeString);
          String _plus_1 = (_plus + ">");
          result = _plus_1;
        } else {
          String _DataTypeString_1 = argIn.DataTypeString();
          String _plus_2 = (result + _DataTypeString_1);
          result = _plus_2;
        }
        result = ((result + " &") + argIn.name);
        OpcUaXmlParser.SeRoNetARGUMENT _last = IterableExtensions.<OpcUaXmlParser.SeRoNetARGUMENT>last(method.inputArguments);
        boolean _notEquals = (!Objects.equal(argIn, _last));
        if (_notEquals) {
          result = (result + ", ");
        }
      }
    }
    for (final OpcUaXmlParser.SeRoNetARGUMENT argOut : method.outputArguments) {
      {
        OpcUaXmlParser.SeRoNetARGUMENT _head = IterableExtensions.<OpcUaXmlParser.SeRoNetARGUMENT>head(method.outputArguments);
        boolean _equals = Objects.equal(argOut, _head);
        if (_equals) {
          boolean _isEmpty = method.inputArguments.isEmpty();
          boolean _not = (!_isEmpty);
          if (_not) {
            result = (result + ", ");
          }
        } else {
          result = (result + ", ");
        }
        if ((argOut.ValueRank == 1)) {
          String _DataTypeString = argOut.DataTypeString();
          String _plus = ((result + "std::vector<") + _DataTypeString);
          String _plus_1 = (_plus + ">");
          result = _plus_1;
        } else {
          String _DataTypeString_1 = argOut.DataTypeString();
          String _plus_2 = (result + _DataTypeString_1);
          result = _plus_2;
        }
        result = ((result + " &") + argOut.name);
      }
    }
    return result;
  }
  
  public String getCppMethodArgumentsCall(final OpcUaXmlParser.SeRoNetMETHOD method) {
    String result = "";
    for (final OpcUaXmlParser.SeRoNetARGUMENT argIn : method.inputArguments) {
      {
        result = (result + argIn.name);
        OpcUaXmlParser.SeRoNetARGUMENT _last = IterableExtensions.<OpcUaXmlParser.SeRoNetARGUMENT>last(method.inputArguments);
        boolean _notEquals = (!Objects.equal(argIn, _last));
        if (_notEquals) {
          result = (result + ", ");
        }
      }
    }
    for (final OpcUaXmlParser.SeRoNetARGUMENT argOut : method.outputArguments) {
      {
        OpcUaXmlParser.SeRoNetARGUMENT _head = IterableExtensions.<OpcUaXmlParser.SeRoNetARGUMENT>head(method.outputArguments);
        boolean _equals = Objects.equal(argOut, _head);
        if (_equals) {
          boolean _isEmpty = method.inputArguments.isEmpty();
          boolean _not = (!_isEmpty);
          if (_not) {
            result = (result + ", ");
          }
        } else {
          result = (result + ", ");
        }
        result = (result + argOut.name);
      }
    }
    return result;
  }
}
