/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Vineet Nagrath, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtend.open62541.compiler;

import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaXmlParser;

@SuppressWarnings("all")
public interface SpecificModelViewController {
  public abstract String getSpecificDriverModelHeader(final String name);
  
  public abstract String getSpecificViewHeader(final String name);
  
  public abstract String getSpecificViewSource(final String name);
  
  public abstract String getSpecificControllerHeader(final String name);
  
  public abstract String getSpecificControllerSource(final String name);
  
  public abstract String getSpecificTestServer(final String name);
  
  public abstract CharSequence compileSpecificDriverModelHeader(final String name);
  
  public abstract CharSequence compileSpecificViewHeader(final String name);
  
  public abstract CharSequence compileSpecificViewSource(final String name);
  
  public abstract CharSequence compileSpecificControllerHeader(final String name, final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList, final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList);
  
  public abstract CharSequence compileSpecificControllerSource(final String name, final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList, final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList);
  
  public abstract CharSequence compileSpecificTestServer(final String name);
  
  public abstract CharSequence compileSpecificCMakeLists(final String name);
}
