/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Vineet Nagrath, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtend.open62541.compiler;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.smartmdsd.xtend.open62541.compiler.AbstractModelViewControllerImpl;
import org.eclipse.smartmdsd.xtend.open62541.compiler.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaObjectInterfaceImpl;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaServerImpl;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaXmlParser;
import org.eclipse.smartmdsd.xtend.open62541.compiler.SpecificModelViewController;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class SpecificModelViewControllerImpl implements SpecificModelViewController {
  @Inject
  @Extension
  private CopyrightHelpers _copyrightHelpers;
  
  @Inject
  @Extension
  private AbstractModelViewControllerImpl _abstractModelViewControllerImpl;
  
  @Inject
  @Extension
  private OpcUaObjectInterfaceImpl _opcUaObjectInterfaceImpl;
  
  @Inject
  @Extension
  private OpcUaServerImpl _opcUaServerImpl;
  
  @Inject
  @Extension
  private OpcUaXmlParser _opcUaXmlParser;
  
  @Override
  public String getSpecificDriverModelHeader(final String name) {
    return (name + "DriverModel.hh");
  }
  
  @Override
  public String getSpecificViewHeader(final String name) {
    return (name + "View.hh");
  }
  
  @Override
  public String getSpecificViewSource(final String name) {
    return (name + "View.cc");
  }
  
  @Override
  public String getSpecificControllerHeader(final String name) {
    return (name + "Controller.hh");
  }
  
  @Override
  public String getSpecificControllerSource(final String name) {
    return (name + "Controller.cc");
  }
  
  @Override
  public String getSpecificTestServer(final String name) {
    return (name + "ServerMain.cc");
  }
  
  @Override
  public CharSequence compileSpecificDriverModelHeader(final String name) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#ifndef ");
    String _upperCase = name.toUpperCase();
    _builder.append(_upperCase);
    _builder.append("DRIVERMODEL_H_");
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    String _upperCase_1 = name.toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("DRIVERMODEL_H_");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include <MVC/");
    String _abstractModelHeader = this._abstractModelViewControllerImpl.getAbstractModelHeader();
    _builder.append(_abstractModelHeader);
    _builder.append(">");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("namespace Smart {");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("class ");
    _builder.append(name);
    _builder.append("DriverModel : public AbstractModel {");
    _builder.newLineIfNotEmpty();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append(name, "\t");
    _builder.append("DriverModel() {  };");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("virtual ~");
    _builder.append(name, "\t");
    _builder.append("DriverModel() {  };");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// FIXME: modify and extend this class on your needs");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("} // end namespace Smart");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif // ");
    String _upperCase_2 = name.toUpperCase();
    _builder.append(_upperCase_2);
    _builder.append("DRIVERMODEL_H_");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Override
  public CharSequence compileSpecificViewHeader(final String name) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#ifndef ");
    String _upperCase = name.toUpperCase();
    _builder.append(_upperCase);
    _builder.append("TVIEW_H_");
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    String _upperCase_1 = name.toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("TVIEW_H_");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include <MVC/");
    String _abstractViewHeader = this._abstractModelViewControllerImpl.getAbstractViewHeader();
    _builder.append(_abstractViewHeader);
    _builder.append(">");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("//FIXME: use your specific DriverModel class (in case its is different to the generated one)");
    _builder.newLine();
    _builder.append("#include \"");
    _builder.append(name);
    _builder.append("DriverModel.hh\"");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("namespace Smart {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* This class implements the View part of the Model-View-Controller (MVC)");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* design pattern. Please implement the method update() to realize your");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* view update strategy. In addition, it is recommended to refine the");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* method getModel() such that it returns your specific model class");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* rather than the AbstractModel. This is particularly useful for the");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Controller class of the MVC pattern.");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("class ");
    String _firstUpper = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper);
    _builder.append("View : public AbstractView");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// constructor requires a pointer to a specific model");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//FIXME: use your specific DriverModel class (in case its is different to the generated one)");
    _builder.newLine();
    _builder.append("\t");
    String _firstUpper_1 = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper_1, "\t");
    _builder.append("View(");
    _builder.append(name, "\t");
    _builder.append("DriverModel *model);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("virtual ~");
    String _firstUpper_2 = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper_2, "\t");
    _builder.append("View();");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// implements AbstractModelObserver");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void update() override;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// returns a pointer to the internally used model");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//FIXME: use your specific DriverModel class (in case its is different to the generated one)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual ");
    _builder.append(name, "\t");
    _builder.append("DriverModel* getModel() const override;");
    _builder.newLineIfNotEmpty();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("} /* namespace Smart */");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif /* ");
    String _upperCase_2 = name.toUpperCase();
    _builder.append(_upperCase_2);
    _builder.append("TVIEW_H_ */");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Override
  public CharSequence compileSpecificViewSource(final String name) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    String _specificViewHeader = this.getSpecificViewHeader(name);
    _builder.append(_specificViewHeader);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("namespace Smart {");
    _builder.newLine();
    _builder.newLine();
    String _firstUpper = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper);
    _builder.append("View::");
    String _firstUpper_1 = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper_1);
    _builder.append("View(");
    _builder.append(name);
    _builder.append("DriverModel *model)");
    _builder.newLineIfNotEmpty();
    _builder.append(":\tAbstractView(model)");
    _builder.newLine();
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    String _firstUpper_2 = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper_2);
    _builder.append("View::~");
    String _firstUpper_3 = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper_3);
    _builder.append("View()");
    _builder.newLineIfNotEmpty();
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    String _firstUpper_4 = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper_4);
    _builder.append("View::update()");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//implement this method (if needed)");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append(name);
    _builder.append("DriverModel* ");
    String _firstUpper_5 = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper_5);
    _builder.append("View::getModel() const {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return dynamic_cast<");
    _builder.append(name, "\t");
    _builder.append("DriverModel*>(model);");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("} /* namespace Smart */");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence compileSpecificControllerHeader(final String objectName, final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList, final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#ifndef ");
    String _upperCase = objectName.toUpperCase();
    _builder.append(_upperCase);
    _builder.append("CONTROLLER_H_");
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    String _upperCase_1 = objectName.toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("CONTROLLER_H_");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include <MVC/");
    String _abstractControllerHeader = this._abstractModelViewControllerImpl.getAbstractControllerHeader();
    _builder.append(_abstractControllerHeader);
    _builder.append(">");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    String _specificViewHeader = this.getSpecificViewHeader(objectName);
    _builder.append(_specificViewHeader);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    String _opcUaDevice_Interface_HeaderFileName = this._opcUaObjectInterfaceImpl.getOpcUaDevice_Interface_HeaderFileName(objectName);
    _builder.append(_opcUaDevice_Interface_HeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.append("#include \"");
    String _opcUaDevice_Server_HeaderFileName = this._opcUaServerImpl.getOpcUaDevice_Server_HeaderFileName(objectName);
    _builder.append(_opcUaDevice_Server_HeaderFileName);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("namespace Smart {");
    _builder.newLine();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* This class implements the Controller part of the Model-View-Controller (MVC)");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* design pattern. As a second responsibility, this class also implements");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* the generated interface which is used by the internally initialized OPC UA");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* server to interact with the actual model. The actual model can be internally");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* accessed over the given view pointer. Conceptually, this class decouples");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* the OPC UA server from the Model and handles the lifecycle of the OPC UA server.");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("class ");
    String _firstUpper = StringExtensions.toFirstUpper(objectName);
    _builder.append(_firstUpper);
    _builder.append("Controller : public AbstractController, public ");
    _builder.append(objectName);
    _builder.append("Interface");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("private:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("OPCUA::");
    _builder.append(objectName, "\t");
    _builder.append(" server;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _firstUpper_1 = StringExtensions.toFirstUpper(objectName);
    _builder.append(_firstUpper_1, "\t");
    _builder.append("View *view;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    String _firstUpper_2 = StringExtensions.toFirstUpper(objectName);
    _builder.append(_firstUpper_2, "\t");
    _builder.append("Controller(");
    String _firstUpper_3 = StringExtensions.toFirstUpper(objectName);
    _builder.append(_firstUpper_3, "\t");
    _builder.append("View *view);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("virtual ~");
    String _firstUpper_4 = StringExtensions.toFirstUpper(objectName);
    _builder.append(_firstUpper_4, "\t");
    _builder.append("Controller();");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// implements AbstractModelObserver");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void update() override;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetENTITY entity : entityList) {
        _builder.append("\t");
        _builder.append("/** XML Specific Getter function for entity ");
        _builder.append(entity.name, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  This function gets ");
        _builder.append(entity.name, "\t ");
        _builder.append("  from the Server");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  When class ");
        _builder.append(objectName, "\t ");
        _builder.append(" is used with a Specific XML file to connect to");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  SeRoNet Servers which implements the device information model.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  @param value\t:output parameter, returns the new value if StatusCode is ALL_OK");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  @return status code");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*\t- ALL_OK");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  - DISCONNECTED");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  - ERROR_COMMUNICATION");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("virtual OPCUA::StatusCode get");
        String _firstUpper_5 = StringExtensions.toFirstUpper(entity.name);
        _builder.append(_firstUpper_5, "\t");
        _builder.append("(");
        String _cppType = this._opcUaXmlParser.getCppType(entity.type);
        _builder.append(_cppType, "\t");
        _builder.append(" &");
        String _firstLower = StringExtensions.toFirstLower(entity.name);
        _builder.append(_firstLower, "\t");
        _builder.append(") const override;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        {
          if (((entity.userAccessLevel == 2) || (entity.userAccessLevel == 3))) {
            _builder.append("\t");
            _builder.append("/** XML Specific Setter function for entity ");
            _builder.append(entity.name, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*  This function sets ");
            _builder.append(entity.name, "\t ");
            _builder.append("  at the Server");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*  When class ");
            _builder.append(objectName, "\t ");
            _builder.append(" is used with a Specific XML file to connect to");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*  SeRoNet Servers which implements the device information model.");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*  @param value\t\t\t:Value to be set");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("* ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*  @return status code");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*\t- ALL_OK");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*  - DISCONNECTED");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*  - ERROR_COMMUNICATION");
            _builder.newLine();
            _builder.append("\t");
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("virtual OPCUA::StatusCode set");
            String _firstUpper_6 = StringExtensions.toFirstUpper(entity.name);
            _builder.append(_firstUpper_6, "\t");
            _builder.append("(const ");
            String _cppType_1 = this._opcUaXmlParser.getCppType(entity.type);
            _builder.append(_cppType_1, "\t");
            _builder.append(" &value) override;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
          }
        }
      }
    }
    {
      for(final OpcUaXmlParser.SeRoNetMETHOD method : methodList) {
        _builder.append("\t");
        _builder.append("/** XML Specific Caller function for method ");
        _builder.append(method.name, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  This function calls ");
        _builder.append(method.name, "\t ");
        _builder.append(" at the Server");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  When class ConveyorBelt is used with a Specific XML file to connect to");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  SeRoNet Servers which implements the device information model.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        {
          for(final OpcUaXmlParser.SeRoNetARGUMENT argIn : method.inputArguments) {
            _builder.append("\t");
            _builder.append("*  @param ");
            _builder.append(argIn.name, "\t");
            _builder.append("\t\t\t: Input | DataTypeIdentifier:");
            _builder.append(argIn.DataTypeIdentifier, "\t");
            _builder.append("(");
            String _DataTypeString = argIn.DataTypeString();
            _builder.append(_DataTypeString, "\t");
            _builder.append(") ValueRank:");
            _builder.append(argIn.ValueRank, "\t");
            _builder.append(" ArrayDimensions:");
            _builder.append(argIn.ArrayDimensions, "\t");
            _builder.append("\t\t\t \t");
            _builder.newLineIfNotEmpty();
          }
        }
        {
          for(final OpcUaXmlParser.SeRoNetARGUMENT argIn_1 : method.outputArguments) {
            _builder.append("\t");
            _builder.append("*  @param ");
            _builder.append(argIn_1.name, "\t");
            _builder.append("\t\t\t: Output| DataTypeIdentifier:");
            _builder.append(argIn_1.DataTypeIdentifier, "\t");
            _builder.append("(");
            String _DataTypeString_1 = argIn_1.DataTypeString();
            _builder.append(_DataTypeString_1, "\t");
            _builder.append(") ValueRank:");
            _builder.append(argIn_1.ValueRank, "\t");
            _builder.append(" ArrayDimensions:");
            _builder.append(argIn_1.ArrayDimensions, "\t");
            _builder.append("\t\t\t \t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("* ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  @return status code");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*\t- ALL_OK");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  - DISCONNECTED");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*  - ERROR_COMMUNICATION");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("virtual OPCUA::StatusCode call");
        String _firstUpper_7 = StringExtensions.toFirstUpper(method.name);
        _builder.append(_firstUpper_7, "\t ");
        _builder.append("(");
        String _cppMethodArgumentsDef = this._opcUaXmlParser.getCppMethodArgumentsDef(method);
        _builder.append(_cppMethodArgumentsDef, "\t ");
        _builder.append(") override;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/// call this method at the end of the main function");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual int run() override;");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("} /* namespace Smart */");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif /* ");
    String _upperCase_2 = objectName.toUpperCase();
    _builder.append(_upperCase_2);
    _builder.append("CONTROLLER_H_ */");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Override
  public CharSequence compileSpecificControllerSource(final String name, final Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList, final Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    String _specificControllerHeader = this.getSpecificControllerHeader(name);
    _builder.append(_specificControllerHeader);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("namespace Smart {");
    _builder.newLine();
    _builder.newLine();
    String _firstUpper = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper);
    _builder.append("Controller::");
    String _firstUpper_1 = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper_1);
    _builder.append("Controller(");
    String _firstUpper_2 = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper_2);
    _builder.append("View *view)");
    _builder.newLineIfNotEmpty();
    _builder.append(":\tAbstractController(view)");
    _builder.newLine();
    _builder.append(",\tserver(this)");
    _builder.newLine();
    _builder.append(",\tview(view)");
    _builder.newLine();
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    String _firstUpper_3 = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper_3);
    _builder.append("Controller::~");
    String _firstUpper_4 = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper_4);
    _builder.append("Controller()");
    _builder.newLineIfNotEmpty();
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    String _firstUpper_5 = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper_5);
    _builder.append("Controller::update()");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//FIXME: implement this method");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("//Getter methods for all OPCUA Variable nodes.");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetENTITY entity : entityList) {
        _builder.append("OPCUA::StatusCode ");
        String _firstUpper_6 = StringExtensions.toFirstUpper(name);
        _builder.append(_firstUpper_6);
        _builder.append("Controller::get");
        String _firstUpper_7 = StringExtensions.toFirstUpper(entity.name);
        _builder.append(_firstUpper_7);
        _builder.append("(");
        String _cppType = this._opcUaXmlParser.getCppType(entity.type);
        _builder.append(_cppType);
        _builder.append(" &");
        String _firstLower = StringExtensions.toFirstLower(entity.name);
        _builder.append(_firstLower);
        _builder.append(") const");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// FIXME: implement this method, use: view->getModel()->... to get the most recent model values");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return OPCUA::StatusCode::ERROR_COMMUNICATION;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("//Setter methods for OPCUA Entity nodes with write access.");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetENTITY entity_1 : entityList) {
        {
          if (((entity_1.userAccessLevel == 2) || (entity_1.userAccessLevel == 3))) {
            _builder.append("OPCUA::StatusCode ");
            String _firstUpper_8 = StringExtensions.toFirstUpper(name);
            _builder.append(_firstUpper_8);
            _builder.append("Controller::set");
            String _firstUpper_9 = StringExtensions.toFirstUpper(entity_1.name);
            _builder.append(_firstUpper_9);
            _builder.append("(const ");
            String _cppType_1 = this._opcUaXmlParser.getCppType(entity_1.type);
            _builder.append(_cppType_1);
            _builder.append(" &value)");
            _builder.newLineIfNotEmpty();
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("// FIXME: implement this method, use: view->getModel()->... to change (i.e. to write) model values");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return OPCUA::StatusCode::ERROR_COMMUNICATION;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
          }
        }
      }
    }
    _builder.newLine();
    _builder.append("//Access methods for OPCUA Method nodes.");
    _builder.newLine();
    {
      for(final OpcUaXmlParser.SeRoNetMETHOD method : methodList) {
        _builder.append("OPCUA::StatusCode ");
        String _firstUpper_10 = StringExtensions.toFirstUpper(name);
        _builder.append(_firstUpper_10);
        _builder.append("Controller::call");
        String _firstUpper_11 = StringExtensions.toFirstUpper(method.name);
        _builder.append(_firstUpper_11);
        _builder.append("(");
        {
          for(final OpcUaXmlParser.SeRoNetARGUMENT argIn : method.inputArguments) {
            _builder.append("const ");
            String _DataTypeString = argIn.DataTypeString();
            _builder.append(_DataTypeString);
            _builder.append(" &");
            String _firstUpper_12 = StringExtensions.toFirstUpper(argIn.name);
            _builder.append(_firstUpper_12);
            {
              OpcUaXmlParser.SeRoNetARGUMENT _last = IterableExtensions.<OpcUaXmlParser.SeRoNetARGUMENT>last(method.inputArguments);
              boolean _notEquals = (!Objects.equal(argIn, _last));
              if (_notEquals) {
                _builder.append(",");
              }
            }
          }
        }
        {
          for(final OpcUaXmlParser.SeRoNetARGUMENT argIn_1 : method.outputArguments) {
            _builder.append(",");
            String _DataTypeString_1 = argIn_1.DataTypeString();
            _builder.append(_DataTypeString_1);
            _builder.append(" &");
            String _firstUpper_13 = StringExtensions.toFirstUpper(argIn_1.name);
            _builder.append(_firstUpper_13);
          }
        }
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// FIXME: implement the logic of this method, use view->getModel()->... to access the most recent model values");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return OPCUA::StatusCode::ERROR_COMMUNICATION;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("int ");
    String _firstUpper_14 = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper_14);
    _builder.append("Controller::run()");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// this call executes the OPCUA server (until it is killed)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return server.run();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("} /* namespace Smart */");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence compileSpecificTestServer(final String name) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    String _specificControllerHeader = this.getSpecificControllerHeader(name);
    _builder.append(_specificControllerHeader);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("int main(int argc, char*argv[]) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Smart::");
    String _firstUpper = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper, "\t");
    _builder.append("DriverModel model;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("Smart::");
    String _firstUpper_1 = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper_1, "\t");
    _builder.append("View view(&model);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("Smart::");
    String _firstUpper_2 = StringExtensions.toFirstUpper(name);
    _builder.append(_firstUpper_2, "\t");
    _builder.append("Controller controller(&view);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return controller.run();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence compileSpecificCMakeLists(final String name) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("CMAKE_MINIMUM_REQUIRED(VERSION 3.5)");
    _builder.newLine();
    _builder.newLine();
    _builder.append("PROJECT(");
    _builder.append(name);
    _builder.append("ServerTest)");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("# find Open62541CppWrapper as the main dependency");
    _builder.newLine();
    _builder.append("FIND_PACKAGE(Open62541CppWrapper 1.0)");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# setup default include directoy");
    _builder.newLine();
    _builder.append("INCLUDE_DIRECTORIES(");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("${PROJECT_SOURCE_DIR}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("${PROJECT_SOURCE_DIR}/..");
    _builder.newLine();
    _builder.append(")");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# setup server source files");
    _builder.newLine();
    _builder.append("SET(SERVER_SRCS");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("${PROJECT_SOURCE_DIR}/");
    String _specificViewSource = this.getSpecificViewSource(name);
    _builder.append(_specificViewSource, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("${PROJECT_SOURCE_DIR}/");
    String _specificControllerSource = this.getSpecificControllerSource(name);
    _builder.append(_specificControllerSource, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("${PROJECT_SOURCE_DIR}/");
    String _opcUaDevice_Server_SourceFileName = this._opcUaServerImpl.getOpcUaDevice_Server_SourceFileName(name);
    _builder.append(_opcUaDevice_Server_SourceFileName, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("${PROJECT_SOURCE_DIR}/");
    String _specificTestServer = this.getSpecificTestServer(name);
    _builder.append(_specificTestServer, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append(")");
    _builder.newLine();
    _builder.newLine();
    _builder.append("# create server test executable");
    _builder.newLine();
    _builder.append("ADD_EXECUTABLE(${PROJECT_NAME} ${SERVER_SRCS})");
    _builder.newLine();
    _builder.append("TARGET_LINK_LIBRARIES(${PROJECT_NAME} Open62541CppWrapper)");
    _builder.newLine();
    _builder.append("SET_TARGET_PROPERTIES(${PROJECT_NAME} PROPERTIES");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("CXX_STANDARD 14");
    _builder.newLine();
    _builder.append(")");
    _builder.newLine();
    return _builder;
  }
}
