/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Vineet Nagrath, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtend.plainOPCUA.generator.component;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaDeviceClient;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaReadServer;
import org.eclipse.smartmdsd.xtend.plainOPCUA.generator.component.PlainOpcUaDeviceClient;
import org.eclipse.smartmdsd.xtend.plainOPCUA.generator.component.PlainOpcUaStatusServer;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartComponent;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartComponentExtension;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class PlainOpcUaComponentExtension {
  @Inject
  @Extension
  private CopyrightHelpers _copyrightHelpers;
  
  @Inject
  @Extension
  private SmartComponentExtension _smartComponentExtension;
  
  @Inject
  @Extension
  private SmartComponent _smartComponent;
  
  @Inject
  @Extension
  private PlainOpcUaDeviceClient _plainOpcUaDeviceClient;
  
  @Inject
  @Extension
  private PlainOpcUaStatusServer _plainOpcUaStatusServer;
  
  public String getPlainOpcUaExtensionHeaderFilename(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("PlainOpcUa");
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("Extension.hh");
    return _builder.toString();
  }
  
  public String getPlainOpcUaExtensionSourceFilename(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("PlainOpcUa");
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("Extension.cc");
    return _builder.toString();
  }
  
  public CharSequence compilePlainOpcUaExtensionHeader(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#ifndef PLAINOPCUACOMPONENTEXTENSION_H_");
    _builder.newLine();
    _builder.append("#define PLAINOPCUACOMPONENTEXTENSION_H_");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include \"");
    String _componentExtensionHeaderFilename = this._smartComponentExtension.getComponentExtensionHeaderFilename(component);
    _builder.append(_componentExtensionHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// include component\'s main class");
    _builder.newLine();
    _builder.append("#include \"");
    String _compHeaderFilename = this._smartComponent.getCompHeaderFilename(component);
    _builder.append(_compHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// include plain OPC UA device clients");
    _builder.newLine();
    {
      Iterable<OpcUaDeviceClient> _filter = Iterables.<OpcUaDeviceClient>filter(component.getElements(), OpcUaDeviceClient.class);
      for(final OpcUaDeviceClient opcDeviceClient : _filter) {
        _builder.append("#include \"");
        String _opcUaDeviceClientHeader = this._plainOpcUaDeviceClient.getOpcUaDeviceClientHeader(opcDeviceClient);
        _builder.append(_opcUaDeviceClientHeader);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("// include plain OPC UA status servers");
    _builder.newLine();
    {
      Iterable<OpcUaReadServer> _filter_1 = Iterables.<OpcUaReadServer>filter(component.getElements(), OpcUaReadServer.class);
      for(final OpcUaReadServer server : _filter_1) {
        _builder.append("#include \"");
        String _serverControllerHeaderFileName = this._plainOpcUaStatusServer.getServerControllerHeaderFileName(server);
        _builder.append(_serverControllerHeaderFileName);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("class PlainOpcUa");
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("Extension : public ");
    String _name_1 = component.getName();
    _builder.append(_name_1);
    _builder.append("Extension ");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("private:");
    _builder.newLine();
    {
      Iterable<OpcUaDeviceClient> _filter_2 = Iterables.<OpcUaDeviceClient>filter(component.getElements(), OpcUaDeviceClient.class);
      for(final OpcUaDeviceClient opcDeviceClient_1 : _filter_2) {
        _builder.append("\t");
        _builder.append("OPCUA::");
        String _firstUpper = StringExtensions.toFirstUpper(opcDeviceClient_1.getName());
        _builder.append(_firstUpper, "\t");
        _builder.append(" *");
        String _firstLower = StringExtensions.toFirstLower(opcDeviceClient_1.getName());
        _builder.append(_firstLower, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("bool ");
        String _firstLower_1 = StringExtensions.toFirstLower(opcDeviceClient_1.getName());
        _builder.append(_firstLower_1, "\t");
        _builder.append("AutoConnect;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("std::string ");
        String _firstLower_2 = StringExtensions.toFirstLower(opcDeviceClient_1.getName());
        _builder.append(_firstLower_2, "\t");
        _builder.append("DeviceURI;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("std::string ");
        String _firstLower_3 = StringExtensions.toFirstLower(opcDeviceClient_1.getName());
        _builder.append(_firstLower_3, "\t");
        _builder.append("RootObjectPath;");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      Iterable<OpcUaReadServer> _filter_3 = Iterables.<OpcUaReadServer>filter(component.getElements(), OpcUaReadServer.class);
      for(final OpcUaReadServer opcStatusServer : _filter_3) {
        _builder.append("\t");
        _builder.append("unsigned short ");
        String _firstLower_4 = StringExtensions.toFirstLower(opcStatusServer.getName());
        _builder.append(_firstLower_4, "\t");
        _builder.append("PortNumber;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("OPCUA::");
        String _className = this._plainOpcUaStatusServer.getClassName(opcStatusServer);
        _builder.append(_className, "\t");
        _builder.append(" *");
        String _firstLower_5 = StringExtensions.toFirstLower(opcStatusServer.getName());
        _builder.append(_firstLower_5, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("PlainOpcUa");
    String _name_2 = component.getName();
    _builder.append(_name_2, "\t");
    _builder.append("Extension();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("virtual ~PlainOpcUa");
    String _name_3 = component.getName();
    _builder.append(_name_3, "\t");
    _builder.append("Extension();");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void loadParameters(const SmartACE::SmartIniParameter &parameter);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void initialize(");
    String _name_4 = component.getName();
    _builder.append(_name_4, "\t");
    _builder.append(" *component, int argc, char* argv[]) override;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("virtual int onStartup() override;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual int extensionExecution() override;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual int onShutdown(const std::chrono::steady_clock::duration &timeoutTime=std::chrono::seconds(2)) override;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void destroy() override;");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif /* PLAINOPCUACOMPONENTEXTENSION_H_ */");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compilePlainOpcUaExtensionSource(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    String _plainOpcUaExtensionHeaderFilename = this.getPlainOpcUaExtensionHeaderFilename(component);
    _builder.append(_plainOpcUaExtensionHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// the ace port-factory is used as a default port-mapping");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// statically create a global PlainOpcUa");
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("Extension instance");
    _builder.newLineIfNotEmpty();
    _builder.append("static PlainOpcUa");
    String _name_1 = component.getName();
    _builder.append(_name_1);
    _builder.append("Extension extension;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("PlainOpcUa");
    String _name_2 = component.getName();
    _builder.append(_name_2);
    _builder.append("Extension::PlainOpcUa");
    String _name_3 = component.getName();
    _builder.append(_name_3);
    _builder.append("Extension()");
    _builder.newLineIfNotEmpty();
    _builder.append(":\t");
    String _name_4 = component.getName();
    _builder.append(_name_4);
    _builder.append("Extension(\"PlainOpcUa");
    String _name_5 = component.getName();
    _builder.append(_name_5);
    _builder.append("Extension\")");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    {
      Iterable<OpcUaDeviceClient> _filter = Iterables.<OpcUaDeviceClient>filter(component.getElements(), OpcUaDeviceClient.class);
      for(final OpcUaDeviceClient client : _filter) {
        _builder.append("\t");
        String _firstLower = StringExtensions.toFirstLower(client.getName());
        _builder.append(_firstLower, "\t");
        _builder.append(" = 0;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _firstLower_1 = StringExtensions.toFirstLower(client.getName());
        _builder.append(_firstLower_1, "\t");
        _builder.append("AutoConnect = ");
        boolean _isAutoConnect = client.isAutoConnect();
        _builder.append(_isAutoConnect, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _firstLower_2 = StringExtensions.toFirstLower(client.getName());
        _builder.append(_firstLower_2, "\t");
        _builder.append("DeviceURI = \"");
        String _deviceURI = client.getDeviceURI();
        _builder.append(_deviceURI, "\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _firstLower_3 = StringExtensions.toFirstLower(client.getName());
        _builder.append(_firstLower_3, "\t");
        _builder.append("RootObjectPath = \"");
        String _rootObjectPath = client.getRootObjectPath();
        _builder.append(_rootObjectPath, "\t");
        _builder.append("\";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    {
      Iterable<OpcUaReadServer> _filter_1 = Iterables.<OpcUaReadServer>filter(component.getElements(), OpcUaReadServer.class);
      for(final OpcUaReadServer opcStatusServer : _filter_1) {
        _builder.append("\t");
        String _firstLower_4 = StringExtensions.toFirstLower(opcStatusServer.getName());
        _builder.append(_firstLower_4, "\t");
        _builder.append(" = 0;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _firstLower_5 = StringExtensions.toFirstLower(opcStatusServer.getName());
        _builder.append(_firstLower_5, "\t");
        _builder.append("PortNumber = ");
        int _portNumber = opcStatusServer.getPortNumber();
        _builder.append(_portNumber, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("PlainOpcUa");
    String _name_6 = component.getName();
    _builder.append(_name_6);
    _builder.append("Extension::~PlainOpcUa");
    String _name_7 = component.getName();
    _builder.append(_name_7);
    _builder.append("Extension()");
    _builder.newLineIfNotEmpty();
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void PlainOpcUa");
    String _name_8 = component.getName();
    _builder.append(_name_8);
    _builder.append("Extension::loadParameters(const SmartACE::SmartIniParameter &parameter)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    {
      Iterable<OpcUaDeviceClient> _filter_2 = Iterables.<OpcUaDeviceClient>filter(component.getElements(), OpcUaDeviceClient.class);
      for(final OpcUaDeviceClient client_1 : _filter_2) {
        _builder.append("\t");
        _builder.append("parameter.getBoolean(\"");
        String _name_9 = client_1.getName();
        _builder.append(_name_9, "\t");
        _builder.append("\", \"autoConnect\", ");
        String _firstLower_6 = StringExtensions.toFirstLower(client_1.getName());
        _builder.append(_firstLower_6, "\t");
        _builder.append("AutoConnect);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("parameter.getString(\"");
        String _name_10 = client_1.getName();
        _builder.append(_name_10, "\t");
        _builder.append("\", \"deviceURI\", ");
        String _firstLower_7 = StringExtensions.toFirstLower(client_1.getName());
        _builder.append(_firstLower_7, "\t");
        _builder.append("DeviceURI);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("parameter.getString(\"");
        String _name_11 = client_1.getName();
        _builder.append(_name_11, "\t");
        _builder.append("\", \"rootObjectPath\", ");
        String _firstLower_8 = StringExtensions.toFirstLower(client_1.getName());
        _builder.append(_firstLower_8, "\t");
        _builder.append("RootObjectPath);");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      Iterable<OpcUaReadServer> _filter_3 = Iterables.<OpcUaReadServer>filter(component.getElements(), OpcUaReadServer.class);
      for(final OpcUaReadServer server : _filter_3) {
        _builder.append("\t");
        _builder.append("parameter.getInteger(\"");
        String _name_12 = server.getName();
        _builder.append(_name_12, "\t");
        _builder.append("\", \"portNumber\", ");
        String _firstLower_9 = StringExtensions.toFirstLower(server.getName());
        _builder.append(_firstLower_9, "\t");
        _builder.append("PortNumber);");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void PlainOpcUa");
    String _name_13 = component.getName();
    _builder.append(_name_13);
    _builder.append("Extension::initialize(");
    String _name_14 = component.getName();
    _builder.append(_name_14);
    _builder.append(" *component, int argc, char* argv[])");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    {
      Iterable<OpcUaDeviceClient> _filter_4 = Iterables.<OpcUaDeviceClient>filter(component.getElements(), OpcUaDeviceClient.class);
      for(final OpcUaDeviceClient opcDeviceClient : _filter_4) {
        _builder.append("\t");
        String _firstLower_10 = StringExtensions.toFirstLower(opcDeviceClient.getName());
        _builder.append(_firstLower_10, "\t");
        _builder.append(" = new OPCUA::");
        String _firstUpper = StringExtensions.toFirstUpper(opcDeviceClient.getName());
        _builder.append(_firstUpper, "\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("component->");
        String _firstLower_11 = StringExtensions.toFirstLower(opcDeviceClient.getName());
        _builder.append(_firstLower_11, "\t");
        _builder.append(" = ");
        String _firstLower_12 = StringExtensions.toFirstLower(opcDeviceClient.getName());
        _builder.append(_firstLower_12, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      Iterable<OpcUaReadServer> _filter_5 = Iterables.<OpcUaReadServer>filter(component.getElements(), OpcUaReadServer.class);
      for(final OpcUaReadServer opcStatusServer_1 : _filter_5) {
        _builder.append("\t");
        String _firstLower_13 = StringExtensions.toFirstLower(opcStatusServer_1.getName());
        _builder.append(_firstLower_13, "\t");
        _builder.append(" = new OPCUA::");
        String _className = this._plainOpcUaStatusServer.getClassName(opcStatusServer_1);
        _builder.append(_className, "\t");
        _builder.append("(NULL, ");
        String _firstLower_14 = StringExtensions.toFirstLower(opcStatusServer_1.getName());
        _builder.append(_firstLower_14, "\t");
        _builder.append("PortNumber);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("component->");
        String _firstLower_15 = StringExtensions.toFirstLower(opcStatusServer_1.getName());
        _builder.append(_firstLower_15, "\t");
        _builder.append(" = ");
        String _firstLower_16 = StringExtensions.toFirstLower(opcStatusServer_1.getName());
        _builder.append(_firstLower_16, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("int PlainOpcUa");
    String _name_15 = component.getName();
    _builder.append(_name_15);
    _builder.append("Extension::onStartup()");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    {
      Iterable<OpcUaDeviceClient> _filter_6 = Iterables.<OpcUaDeviceClient>filter(component.getElements(), OpcUaDeviceClient.class);
      for(final OpcUaDeviceClient client_2 : _filter_6) {
        _builder.append("\t");
        _builder.append("if(");
        String _firstLower_17 = StringExtensions.toFirstLower(client_2.getName());
        _builder.append(_firstLower_17, "\t");
        _builder.append("AutoConnect == true) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        _builder.append("// connect OPC/UA DeviceClient ");
        String _name_16 = client_2.getName();
        _builder.append(_name_16, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t");
        String _firstLower_18 = StringExtensions.toFirstLower(client_2.getName());
        _builder.append(_firstLower_18, "\t\t");
        _builder.append("->connect(");
        String _firstLower_19 = StringExtensions.toFirstLower(client_2.getName());
        _builder.append(_firstLower_19, "\t\t");
        _builder.append("DeviceURI, ");
        String _firstLower_20 = StringExtensions.toFirstLower(client_2.getName());
        _builder.append(_firstLower_20, "\t\t");
        _builder.append("RootObjectPath, false);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    {
      Iterable<OpcUaReadServer> _filter_7 = Iterables.<OpcUaReadServer>filter(component.getElements(), OpcUaReadServer.class);
      for(final OpcUaReadServer opcStatusServer_2 : _filter_7) {
        _builder.append("\t");
        String _firstLower_21 = StringExtensions.toFirstLower(opcStatusServer_2.getName());
        _builder.append(_firstLower_21, "\t");
        _builder.append("->start();");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return startExtensionThread();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("int PlainOpcUa");
    String _name_17 = component.getName();
    _builder.append(_name_17);
    _builder.append("Extension::extensionExecution()");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("while(cancelled == false) {");
    _builder.newLine();
    {
      Iterable<OpcUaDeviceClient> _filter_8 = Iterables.<OpcUaDeviceClient>filter(component.getElements(), OpcUaDeviceClient.class);
      for(final OpcUaDeviceClient client_3 : _filter_8) {
        _builder.append("\t\t");
        String _firstLower_22 = StringExtensions.toFirstLower(client_3.getName());
        _builder.append(_firstLower_22, "\t\t");
        _builder.append("->run_once();");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return 0;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("int PlainOpcUa");
    String _name_18 = component.getName();
    _builder.append(_name_18);
    _builder.append("Extension::onShutdown(const std::chrono::steady_clock::duration &timeoutTime)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    {
      Iterable<OpcUaDeviceClient> _filter_9 = Iterables.<OpcUaDeviceClient>filter(component.getElements(), OpcUaDeviceClient.class);
      for(final OpcUaDeviceClient client_4 : _filter_9) {
        _builder.append("\t");
        _builder.append("// disconnect OPC/UA DeviceClient ");
        String _name_19 = client_4.getName();
        _builder.append(_name_19, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _firstLower_23 = StringExtensions.toFirstLower(client_4.getName());
        _builder.append(_firstLower_23, "\t");
        _builder.append("->disconnect();");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    {
      Iterable<OpcUaReadServer> _filter_10 = Iterables.<OpcUaReadServer>filter(component.getElements(), OpcUaReadServer.class);
      for(final OpcUaReadServer opcStatusServer_3 : _filter_10) {
        _builder.append("\t");
        String _firstLower_24 = StringExtensions.toFirstLower(opcStatusServer_3.getName());
        _builder.append(_firstLower_24, "\t");
        _builder.append("->stop();");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return stopExtensionThread(timeoutTime);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void PlainOpcUa");
    String _name_20 = component.getName();
    _builder.append(_name_20);
    _builder.append("Extension::destroy()");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    {
      Iterable<OpcUaDeviceClient> _filter_11 = Iterables.<OpcUaDeviceClient>filter(component.getElements(), OpcUaDeviceClient.class);
      for(final OpcUaDeviceClient opcDeviceClient_1 : _filter_11) {
        _builder.append("\t");
        _builder.append("delete ");
        String _firstLower_25 = StringExtensions.toFirstLower(opcDeviceClient_1.getName());
        _builder.append(_firstLower_25, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    {
      Iterable<OpcUaReadServer> _filter_12 = Iterables.<OpcUaReadServer>filter(component.getElements(), OpcUaReadServer.class);
      for(final OpcUaReadServer opcStatusServer_4 : _filter_12) {
        _builder.append("\t");
        _builder.append("delete ");
        String _firstLower_26 = StringExtensions.toFirstLower(opcStatusServer_4.getName());
        _builder.append(_firstLower_26, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
