/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Vineet Nagrath, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtend.plainOPCUA.generator.component;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaDeviceClient;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaClientImpl;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaObjectInterfaceImpl;
import org.eclipse.smartmdsd.xtend.open62541.compiler.OpcUaXmlParser;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class PlainOpcUaDeviceClient {
  @Inject
  @Extension
  private OpcUaClientImpl _opcUaClientImpl;
  
  @Inject
  @Extension
  private OpcUaObjectInterfaceImpl _opcUaObjectInterfaceImpl;
  
  @Inject
  private OpcUaXmlParser xmlParser;
  
  public String getOpcUaDeviceClientHeader(final OpcUaDeviceClient client) {
    return this._opcUaClientImpl.getOpcUa_DeviceClient_HeaderFileName(client.getName());
  }
  
  public void compilePlainOpcUaDeviceClient(final OpcUaDeviceClient client, final IFileSystemAccess2 fsa) {
    Iterable<OpcUaXmlParser.SeRoNetENTITY> entityList = new ArrayList<OpcUaXmlParser.SeRoNetENTITY>();
    Iterable<OpcUaXmlParser.SeRoNetMETHOD> methodList = new ArrayList<OpcUaXmlParser.SeRoNetMETHOD>();
    if (((client.getOpcuaXmlFile() != null) && (!Objects.equal(client.getOpcuaXmlFile(), "")))) {
      final IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
      String _opcuaXmlFile = client.getOpcuaXmlFile();
      Path _path = new Path(_opcuaXmlFile);
      final IFile xmlFile = workspaceRoot.getFile(_path);
      entityList = this.xmlParser.getEntityList(xmlFile.getLocation().toFile());
      methodList = this.xmlParser.getMethodList(xmlFile.getLocation().toFile());
    }
    fsa.generateFile(
      this._opcUaObjectInterfaceImpl.getOpcUaDevice_Interface_HeaderFileName(client.getName()), 
      this._opcUaObjectInterfaceImpl.compileOpcUaDevice_Interface_HeaderFileContent(client.getName(), entityList, methodList));
    fsa.generateFile(
      this._opcUaClientImpl.getOpcUa_DeviceClient_HeaderFileName(client.getName()), 
      this._opcUaClientImpl.compileOpcUa_DeviceClient_HeaderFileContent(client.getName(), entityList, methodList));
    fsa.generateFile(
      this._opcUaClientImpl.getOpcUa_DeviceClient_SourceFileName(client.getName()), 
      this._opcUaClientImpl.compileOpcUa_DeviceClient_SourceFileContent(client.getName(), entityList, methodList));
  }
}
