/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Vineet Nagrath, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtend.plainOPCUA.generator.component;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaDeviceClient;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaReadServer;
import org.eclipse.smartmdsd.xtend.plainOPCUA.generator.component.PlainOpcUaComponentExtension;
import org.eclipse.smartmdsd.xtend.plainOPCUA.generator.component.PlainOpcUaDeviceClient;
import org.eclipse.smartmdsd.xtend.plainOPCUA.generator.component.PlainOpcUaStatusServer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@SuppressWarnings("all")
public class PlainOpcUaGenerator2Impl extends AbstractGenerator {
  @Inject
  @Extension
  private PlainOpcUaDeviceClient _plainOpcUaDeviceClient;
  
  @Inject
  @Extension
  private PlainOpcUaStatusServer _plainOpcUaStatusServer;
  
  @Inject
  @Extension
  private PlainOpcUaComponentExtension _plainOpcUaComponentExtension;
  
  @Override
  public void doGenerate(final Resource input, final IFileSystemAccess2 fsa, final IGeneratorContext context) {
    Iterable<ComponentDefinition> _filter = Iterables.<ComponentDefinition>filter(IteratorExtensions.<EObject>toIterable(input.getAllContents()), ComponentDefinition.class);
    for (final ComponentDefinition comp : _filter) {
      {
        fsa.generateFile(
          this._plainOpcUaComponentExtension.getPlainOpcUaExtensionHeaderFilename(comp), 
          this._plainOpcUaComponentExtension.compilePlainOpcUaExtensionHeader(comp));
        fsa.generateFile(
          this._plainOpcUaComponentExtension.getPlainOpcUaExtensionSourceFilename(comp), 
          this._plainOpcUaComponentExtension.compilePlainOpcUaExtensionSource(comp));
        String _name = comp.getName();
        String _plus = (_name + "PlainOpcUa.cmake");
        fsa.generateFile(_plus, 
          this.compileCMakeFile(comp));
        Iterable<OpcUaDeviceClient> _filter_1 = Iterables.<OpcUaDeviceClient>filter(comp.getElements(), OpcUaDeviceClient.class);
        for (final OpcUaDeviceClient opcUaDevClient : _filter_1) {
          this._plainOpcUaDeviceClient.compilePlainOpcUaDeviceClient(opcUaDevClient, fsa);
        }
        Iterable<OpcUaReadServer> _filter_2 = Iterables.<OpcUaReadServer>filter(comp.getElements(), OpcUaReadServer.class);
        for (final OpcUaReadServer opcUaStatusServer : _filter_2) {
          this._plainOpcUaStatusServer.compilePlainOpcUaReadServer(opcUaStatusServer, fsa);
        }
      }
    }
  }
  
  public CharSequence compileCMakeFile(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("CMAKE_MINIMUM_REQUIRED(VERSION 3.5)");
    _builder.newLine();
    _builder.newLine();
    _builder.append("FIND_PACKAGE(Open62541CppWrapper 1.0 QUIET)");
    _builder.newLine();
    _builder.newLine();
    _builder.append("IF(Open62541CppWrapper_FOUND)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("SET(CMAKE_CXX_STANDARD 14)");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("INCLUDE_DIRECTORIES(${CMAKE_CURRENT_LIST_DIR})");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("FILE(GLOB PLAIN_OPCUA_SRCS ${CMAKE_CURRENT_LIST_DIR}/*.cc)");
    _builder.newLine();
    _builder.append("ENDIF(Open62541CppWrapper_FOUND)");
    _builder.newLine();
    return _builder;
  }
}
