/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Vineet Nagrath, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtend.plainOPCUA.generator.component.extensions;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaClientLink;
import org.eclipse.smartmdsd.xtend.plainOPCUA.generator.component.PlainOpcUaDeviceClient;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ActivityGeneratorExtension;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class PlainOpcUaActivityGeneratorExtensionImpl implements ActivityGeneratorExtension {
  @Inject
  @Extension
  private PlainOpcUaDeviceClient _plainOpcUaDeviceClient;
  
  @Override
  public String getExtensionName() {
    return "PlainOpcUaActivityGeneratorExtension";
  }
  
  @Override
  public CharSequence getHeaderIncludes(final Activity activity) {
    StringConcatenation _builder = new StringConcatenation();
    {
      Iterable<OpcUaClientLink> _filter = Iterables.<OpcUaClientLink>filter(activity.getLinks(), OpcUaClientLink.class);
      for(final OpcUaClientLink link : _filter) {
        _builder.append("#include \"");
        String _opcUaDeviceClientHeader = this._plainOpcUaDeviceClient.getOpcUaDeviceClientHeader(link.getClient());
        _builder.append(_opcUaDeviceClientHeader);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence getClassMemberProtectedDefinition(final Activity activity) {
    StringConcatenation _builder = new StringConcatenation();
    {
      Iterable<OpcUaClientLink> _filter = Iterables.<OpcUaClientLink>filter(activity.getLinks(), OpcUaClientLink.class);
      for(final OpcUaClientLink link : _filter) {
        _builder.append("OPCUA::");
        String _firstUpper = StringExtensions.toFirstUpper(link.getClient().getName());
        _builder.append(_firstUpper);
        _builder.append(" *");
        String _firstLower = StringExtensions.toFirstLower(link.getClient().getName());
        _builder.append(_firstLower);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence getClassMemberConstruction(final Activity activity) {
    StringConcatenation _builder = new StringConcatenation();
    {
      Iterable<OpcUaClientLink> _filter = Iterables.<OpcUaClientLink>filter(activity.getLinks(), OpcUaClientLink.class);
      for(final OpcUaClientLink link : _filter) {
        String _firstLower = StringExtensions.toFirstLower(link.getClient().getName());
        _builder.append(_firstLower);
        _builder.append(" = COMP->");
        String _firstLower_1 = StringExtensions.toFirstLower(link.getClient().getName());
        _builder.append(_firstLower_1);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public ComponentDefinition getComponent(final Activity activity) {
    EObject _eContainer = activity.eContainer();
    return ((ComponentDefinition) _eContainer);
  }
}
