/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.basicAttributes;

import com.google.common.base.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PRIMITIVE_TYPE_NAME;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PrimitiveType;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public abstract class BasicAttributesGenHelpers {
  public String compileCppType(final AbstractAttributeType type) {
    String _xifexpression = null;
    if ((type instanceof PrimitiveType)) {
      String _switchResult = null;
      boolean _matched = false;
      PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)type).getTypeName();
      boolean _equals = Objects.equal(_typeName, PRIMITIVE_TYPE_NAME.INT8);
      if (_equals) {
        _matched=true;
        _switchResult = "char";
      }
      if (!_matched) {
        PRIMITIVE_TYPE_NAME _typeName_1 = ((PrimitiveType)type).getTypeName();
        boolean _equals_1 = Objects.equal(_typeName_1, PRIMITIVE_TYPE_NAME.INT16);
        if (_equals_1) {
          _matched=true;
          _switchResult = "short";
        }
      }
      if (!_matched) {
        PRIMITIVE_TYPE_NAME _typeName_2 = ((PrimitiveType)type).getTypeName();
        boolean _equals_2 = Objects.equal(_typeName_2, PRIMITIVE_TYPE_NAME.INT32);
        if (_equals_2) {
          _matched=true;
          _switchResult = "int";
        }
      }
      if (!_matched) {
        PRIMITIVE_TYPE_NAME _typeName_3 = ((PrimitiveType)type).getTypeName();
        boolean _equals_3 = Objects.equal(_typeName_3, PRIMITIVE_TYPE_NAME.INT64);
        if (_equals_3) {
          _matched=true;
          _switchResult = "long int";
        }
      }
      if (!_matched) {
        PRIMITIVE_TYPE_NAME _typeName_4 = ((PrimitiveType)type).getTypeName();
        boolean _equals_4 = Objects.equal(_typeName_4, PRIMITIVE_TYPE_NAME.UINT8);
        if (_equals_4) {
          _matched=true;
          _switchResult = "unsigned char";
        }
      }
      if (!_matched) {
        PRIMITIVE_TYPE_NAME _typeName_5 = ((PrimitiveType)type).getTypeName();
        boolean _equals_5 = Objects.equal(_typeName_5, PRIMITIVE_TYPE_NAME.UINT16);
        if (_equals_5) {
          _matched=true;
          _switchResult = "unsigned short";
        }
      }
      if (!_matched) {
        PRIMITIVE_TYPE_NAME _typeName_6 = ((PrimitiveType)type).getTypeName();
        boolean _equals_6 = Objects.equal(_typeName_6, PRIMITIVE_TYPE_NAME.UINT32);
        if (_equals_6) {
          _matched=true;
          _switchResult = "unsigned int";
        }
      }
      if (!_matched) {
        PRIMITIVE_TYPE_NAME _typeName_7 = ((PrimitiveType)type).getTypeName();
        boolean _equals_7 = Objects.equal(_typeName_7, PRIMITIVE_TYPE_NAME.UINT64);
        if (_equals_7) {
          _matched=true;
          _switchResult = "unsigned long int";
        }
      }
      if (!_matched) {
        PRIMITIVE_TYPE_NAME _typeName_8 = ((PrimitiveType)type).getTypeName();
        boolean _equals_8 = Objects.equal(_typeName_8, PRIMITIVE_TYPE_NAME.FLOAT);
        if (_equals_8) {
          _matched=true;
          _switchResult = "float";
        }
      }
      if (!_matched) {
        PRIMITIVE_TYPE_NAME _typeName_9 = ((PrimitiveType)type).getTypeName();
        boolean _equals_9 = Objects.equal(_typeName_9, PRIMITIVE_TYPE_NAME.DOUBLE);
        if (_equals_9) {
          _matched=true;
          _switchResult = "double";
        }
      }
      if (!_matched) {
        PRIMITIVE_TYPE_NAME _typeName_10 = ((PrimitiveType)type).getTypeName();
        boolean _equals_10 = Objects.equal(_typeName_10, PRIMITIVE_TYPE_NAME.STRING);
        if (_equals_10) {
          _matched=true;
          _switchResult = "std::string";
        }
      }
      if (!_matched) {
        PRIMITIVE_TYPE_NAME _typeName_11 = ((PrimitiveType)type).getTypeName();
        boolean _equals_11 = Objects.equal(_typeName_11, PRIMITIVE_TYPE_NAME.BOOLEAN);
        if (_equals_11) {
          _matched=true;
          _switchResult = "bool";
        }
      }
      _xifexpression = _switchResult;
    } else {
      String _xifexpression_1 = null;
      if ((type instanceof InlineEnumerationType)) {
        _xifexpression_1 = this.compileInlineEnumCppType(((InlineEnumerationType)type));
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }
  
  public String compileInlineEnumCppType(final InlineEnumerationType en) {
    EObject attribute = en.eContainer();
    if ((attribute instanceof AttributeDefinition)) {
      final String parentName = this.compileAttributeParentTypeName(((AttributeDefinition)attribute));
      StringConcatenation _builder = new StringConcatenation();
      _builder.append(parentName);
      _builder.append("Type::");
      String _name = ((AttributeDefinition)attribute).getName();
      _builder.append(_name);
      _builder.append("Type");
      return _builder.toString();
    }
    StringConcatenation _builder_1 = new StringConcatenation();
    _builder_1.append("#warning \"type InlineEnumerationType is not (yet) implemented\"");
    return _builder_1.toString();
  }
  
  public String compileCppType(final AttributeDefinition attr) {
    return this.compileCppType(attr.getType());
  }
  
  public abstract String compileAttributeParentTypeName(final AttributeDefinition attr);
}
