/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj;

import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PrimitiveType;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommElementReference;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObjectUtility;
import org.eclipse.smartmdsd.ecore.service.communicationObject.Enumeration;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.CommObjectGenHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class CommObjectMarshalling {
  @Inject
  @Extension
  private CommObjectGenHelpers _commObjectGenHelpers;
  
  @Inject
  @Extension
  private CommunicationObjectUtility _communicationObjectUtility;
  
  /**
   * Helpers to get the referenced NameSpace independent of the type
   */
  private CharSequence _getFullyQualifiedIdlType(final CommElementReference cor) {
    CharSequence _xblockexpression = null;
    {
      final AbstractCommElement id = cor.getTypeName();
      CharSequence _switchResult = null;
      boolean _matched = false;
      if (id instanceof CommunicationObject) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(id);
        _builder.append(_repoNamespace);
        _builder.append("IDL::");
        CharSequence _idlStructName = this._commObjectGenHelpers.getIdlStructName(id);
        _builder.append(_idlStructName);
        _switchResult = _builder;
      }
      if (!_matched) {
        if (id instanceof Enumeration) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(id);
          _builder.append(_repoNamespace);
          _builder.append("IDL::");
          CharSequence _idlStructName = this._commObjectGenHelpers.getIdlStructName(id);
          _builder.append(_idlStructName);
          _switchResult = _builder;
        }
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
  
  private CharSequence _getFullyQualifiedIdlType(final PrimitiveType t) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _compileType = this._commObjectGenHelpers.compileType(t);
    _builder.append(_compileType);
    return _builder;
  }
  
  private CharSequence _getFullyQualifiedUserType(final CommElementReference cor) {
    CharSequence _xblockexpression = null;
    {
      final AbstractCommElement id = cor.getTypeName();
      CharSequence _switchResult = null;
      boolean _matched = false;
      if (id instanceof CommunicationObject) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(id);
        _builder.append(_repoNamespace);
        _builder.append("::");
        CharSequence _idlStructName = this._commObjectGenHelpers.getIdlStructName(id);
        _builder.append(_idlStructName);
        _switchResult = _builder;
      }
      if (!_matched) {
        if (id instanceof Enumeration) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace(id);
          _builder.append(_repoNamespace);
          _builder.append("::");
          CharSequence _idlStructName = this._commObjectGenHelpers.getIdlStructName(id);
          _builder.append(_idlStructName);
          _switchResult = _builder;
        }
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
  
  private CharSequence _getFullyQualifiedUserType(final PrimitiveType t) {
    StringConcatenation _builder = new StringConcatenation();
    String _compileCppType = this._commObjectGenHelpers.compileCppType(t);
    _builder.append(_compileCppType);
    return _builder;
  }
  
  /**
   * Generate CDR Output pipe
   */
  public String generateOutputCdr(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String result = _builder.toString();
    EList<AttributeDefinition> _attributes = co.getAttributes();
    for (final AttributeDefinition el : _attributes) {
      boolean _many = this._commObjectGenHelpers.getMany(el);
      boolean _equals = (_many == true);
      if (_equals) {
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("cdr << static_cast<ACE_CDR::Long>(data.");
        String _name = el.getName();
        _builder_1.append(_name);
        _builder_1.append(".size());");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("std::vector<");
        CharSequence _fullyQualifiedIdlType = this.getFullyQualifiedIdlType(el.getType());
        _builder_1.append(_fullyQualifiedIdlType);
        _builder_1.append(">::const_iterator data_");
        String _name_1 = el.getName();
        _builder_1.append(_name_1);
        _builder_1.append("It;");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("for(data_");
        String _name_2 = el.getName();
        _builder_1.append(_name_2);
        _builder_1.append("It=data.");
        String _name_3 = el.getName();
        _builder_1.append(_name_3);
        _builder_1.append(".begin(); data_");
        String _name_4 = el.getName();
        _builder_1.append(_name_4);
        _builder_1.append("It!=data.");
        String _name_5 = el.getName();
        _builder_1.append(_name_5);
        _builder_1.append(".end(); data_");
        String _name_6 = el.getName();
        _builder_1.append(_name_6);
        _builder_1.append("It++) {");
        _builder_1.newLineIfNotEmpty();
        {
          boolean _isComposedType = this._communicationObjectUtility.isComposedType(el.getType());
          if (_isComposedType) {
            _builder_1.append("\t");
            CharSequence _fullyQualifiedUserType = this.getFullyQualifiedUserType(el.getType());
            _builder_1.append(_fullyQualifiedUserType, "\t");
            _builder_1.append("::serialize(*data_");
            String _name_7 = el.getName();
            _builder_1.append(_name_7, "\t");
            _builder_1.append("It, cdr);");
            _builder_1.newLineIfNotEmpty();
          } else {
            _builder_1.append("\t");
            _builder_1.append("cdr.write_");
            String _firstLower = StringExtensions.toFirstLower(this._commObjectGenHelpers.compileCdrType(el.getType()));
            _builder_1.append(_firstLower, "\t");
            _builder_1.append("(*data_");
            String _name_8 = el.getName();
            _builder_1.append(_name_8, "\t");
            _builder_1.append("It);");
            _builder_1.newLineIfNotEmpty();
          }
        }
        _builder_1.append("}");
        _builder_1.newLine();
        String _plus = (result + _builder_1);
        result = _plus;
      } else {
        boolean _isComposedType_1 = this._communicationObjectUtility.isComposedType(el.getType());
        if (_isComposedType_1) {
          StringConcatenation _builder_2 = new StringConcatenation();
          CharSequence _fullyQualifiedUserType_1 = this.getFullyQualifiedUserType(el.getType());
          _builder_2.append(_fullyQualifiedUserType_1);
          _builder_2.append("::serialize(data.");
          String _name_9 = el.getName();
          _builder_2.append(_name_9);
          _builder_2.append(", cdr);");
          _builder_2.newLineIfNotEmpty();
          String _plus_1 = (result + _builder_2);
          result = _plus_1;
        } else {
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append("cdr.write_");
          String _firstLower_1 = StringExtensions.toFirstLower(this._commObjectGenHelpers.compileCdrType(el.getType()));
          _builder_3.append(_firstLower_1);
          _builder_3.append("(data.");
          String _name_10 = el.getName();
          _builder_3.append(_name_10);
          _builder_3.append(");");
          _builder_3.newLineIfNotEmpty();
          String _plus_2 = (result + _builder_3);
          result = _plus_2;
        }
      }
    }
    return result;
  }
  
  public String generateOutputCdrOperator(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String result = _builder.toString();
    EList<AttributeDefinition> _attributes = co.getAttributes();
    for (final AttributeDefinition el : _attributes) {
      boolean _many = this._commObjectGenHelpers.getMany(el);
      boolean _equals = (_many == true);
      if (_equals) {
        if (((this._communicationObjectUtility.isComposedType(el.getType()) || this._communicationObjectUtility.isStringType(el.getType())) || this._communicationObjectUtility.isBooleanType(el.getType()))) {
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("// serialize list-element ");
          String _name = el.getName();
          _builder_1.append(_name);
          _builder_1.newLineIfNotEmpty();
          _builder_1.append("good_bit = good_bit && cdr << ACE_Utils::truncate_cast<ACE_CDR::ULong>(data.");
          String _name_1 = el.getName();
          _builder_1.append(_name_1);
          _builder_1.append(".size());");
          _builder_1.newLineIfNotEmpty();
          {
            boolean _isStringType = this._communicationObjectUtility.isStringType(el.getType());
            if (_isStringType) {
              _builder_1.append("std::vector<std::string>::const_iterator data_");
              String _name_2 = el.getName();
              _builder_1.append(_name_2);
              _builder_1.append("It;");
              _builder_1.newLineIfNotEmpty();
            } else {
              _builder_1.append("std::vector<");
              CharSequence _fullyQualifiedIdlType = this.getFullyQualifiedIdlType(el.getType());
              _builder_1.append(_fullyQualifiedIdlType);
              _builder_1.append(">::const_iterator data_");
              String _name_3 = el.getName();
              _builder_1.append(_name_3);
              _builder_1.append("It;");
              _builder_1.newLineIfNotEmpty();
            }
          }
          _builder_1.append("for(data_");
          String _name_4 = el.getName();
          _builder_1.append(_name_4);
          _builder_1.append("It=data.");
          String _name_5 = el.getName();
          _builder_1.append(_name_5);
          _builder_1.append(".begin(); data_");
          String _name_6 = el.getName();
          _builder_1.append(_name_6);
          _builder_1.append("It!=data.");
          String _name_7 = el.getName();
          _builder_1.append(_name_7);
          _builder_1.append(".end(); data_");
          String _name_8 = el.getName();
          _builder_1.append(_name_8);
          _builder_1.append("It++) {");
          _builder_1.newLineIfNotEmpty();
          {
            boolean _isComposedType = this._communicationObjectUtility.isComposedType(el.getType());
            if (_isComposedType) {
              _builder_1.append("\t");
              _builder_1.append("good_bit = good_bit && cdr << *data_");
              String _name_9 = el.getName();
              _builder_1.append(_name_9, "\t");
              _builder_1.append("It;");
              _builder_1.newLineIfNotEmpty();
            } else {
              boolean _isStringType_1 = this._communicationObjectUtility.isStringType(el.getType());
              if (_isStringType_1) {
                _builder_1.append("\t");
                _builder_1.append("good_bit = good_bit && cdr << ACE_CString(data_");
                String _name_10 = el.getName();
                _builder_1.append(_name_10, "\t");
                _builder_1.append("It->c_str());");
                _builder_1.newLineIfNotEmpty();
              } else {
                _builder_1.append("\t");
                _builder_1.append("good_bit = good_bit && cdr.write_");
                String _lowerCase = this._commObjectGenHelpers.compileCdrType(el.getType()).toLowerCase();
                _builder_1.append(_lowerCase, "\t");
                _builder_1.append("(*data_");
                String _name_11 = el.getName();
                _builder_1.append(_name_11, "\t");
                _builder_1.append("It);");
                _builder_1.newLineIfNotEmpty();
              }
            }
          }
          _builder_1.append("}");
          _builder_1.newLine();
          String _plus = (result + _builder_1);
          result = _plus;
        } else {
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("// serialize list-element ");
          String _name_12 = el.getName();
          _builder_2.append(_name_12);
          _builder_2.newLineIfNotEmpty();
          _builder_2.append("good_bit = good_bit && cdr << ACE_Utils::truncate_cast<ACE_CDR::ULong>(data.");
          String _name_13 = el.getName();
          _builder_2.append(_name_13);
          _builder_2.append(".size());");
          _builder_2.newLineIfNotEmpty();
          _builder_2.append("good_bit = good_bit && cdr.write_");
          String _lowerCase_1 = this._commObjectGenHelpers.compileCdrType(el.getType()).toLowerCase();
          _builder_2.append(_lowerCase_1);
          _builder_2.append("_array(data.");
          String _name_14 = el.getName();
          _builder_2.append(_name_14);
          _builder_2.append(".data(), data.");
          String _name_15 = el.getName();
          _builder_2.append(_name_15);
          _builder_2.append(".size());");
          _builder_2.newLineIfNotEmpty();
          String _plus_1 = (result + _builder_2);
          result = _plus_1;
        }
      } else {
        boolean _isComposedType_1 = this._communicationObjectUtility.isComposedType(el.getType());
        if (_isComposedType_1) {
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append("// serialize list-element ");
          String _name_16 = el.getName();
          _builder_3.append(_name_16);
          _builder_3.newLineIfNotEmpty();
          _builder_3.append("good_bit = good_bit && cdr << data.");
          String _name_17 = el.getName();
          _builder_3.append(_name_17);
          _builder_3.append(";");
          _builder_3.newLineIfNotEmpty();
          String _plus_2 = (result + _builder_3);
          result = _plus_2;
        } else {
          boolean _isStringType_2 = this._communicationObjectUtility.isStringType(el.getType());
          if (_isStringType_2) {
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("// serialize list-element ");
            String _name_18 = el.getName();
            _builder_4.append(_name_18);
            _builder_4.newLineIfNotEmpty();
            _builder_4.append("good_bit = good_bit && cdr << ACE_CString(data.");
            String _name_19 = el.getName();
            _builder_4.append(_name_19);
            _builder_4.append(".c_str());");
            _builder_4.newLineIfNotEmpty();
            String _plus_3 = (result + _builder_4);
            result = _plus_3;
          } else {
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("// serialize list-element ");
            String _name_20 = el.getName();
            _builder_5.append(_name_20);
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("good_bit = good_bit && cdr.write_");
            String _lowerCase_2 = this._commObjectGenHelpers.compileCdrType(el.getType()).toLowerCase();
            _builder_5.append(_lowerCase_2);
            _builder_5.append("(data.");
            String _name_21 = el.getName();
            _builder_5.append(_name_21);
            _builder_5.append(");");
            _builder_5.newLineIfNotEmpty();
            String _plus_4 = (result + _builder_5);
            result = _plus_4;
          }
        }
      }
    }
    return result;
  }
  
  /**
   * Generate CDR Input pipe
   */
  public String generateInputCdr(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String result = _builder.toString();
    EList<AttributeDefinition> _attributes = co.getAttributes();
    for (final AttributeDefinition el : _attributes) {
      {
        AbstractAttributeType type = el.getType();
        boolean _many = this._commObjectGenHelpers.getMany(el);
        if (_many) {
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("ACE_CDR::Long data_");
          String _name = el.getName();
          _builder_1.append(_name);
          _builder_1.append("Nbr;");
          _builder_1.newLineIfNotEmpty();
          _builder_1.append("cdr >> data_");
          String _name_1 = el.getName();
          _builder_1.append(_name_1);
          _builder_1.append("Nbr;");
          _builder_1.newLineIfNotEmpty();
          _builder_1.append("data.");
          String _name_2 = el.getName();
          _builder_1.append(_name_2);
          _builder_1.append(".clear();");
          _builder_1.newLineIfNotEmpty();
          CharSequence _fullyQualifiedIdlType = this.getFullyQualifiedIdlType(el.getType());
          _builder_1.append(_fullyQualifiedIdlType);
          _builder_1.append(" data_");
          String _name_3 = el.getName();
          _builder_1.append(_name_3);
          _builder_1.append("Item;");
          _builder_1.newLineIfNotEmpty();
          _builder_1.append("for(ACE_CDR::Long i=0; i<data_");
          String _name_4 = el.getName();
          _builder_1.append(_name_4);
          _builder_1.append("Nbr; ++i) {");
          _builder_1.newLineIfNotEmpty();
          {
            boolean _isComposedType = this._communicationObjectUtility.isComposedType(el.getType());
            if (_isComposedType) {
              _builder_1.append("\t");
              CharSequence _fullyQualifiedUserType = this.getFullyQualifiedUserType(el.getType());
              _builder_1.append(_fullyQualifiedUserType, "\t");
              _builder_1.append("::deserialize(cdr, data_");
              String _name_5 = el.getName();
              _builder_1.append(_name_5, "\t");
              _builder_1.append("Item);");
              _builder_1.newLineIfNotEmpty();
            } else {
              _builder_1.append("\t");
              _builder_1.append("cdr >> data_");
              String _name_6 = el.getName();
              _builder_1.append(_name_6, "\t");
              _builder_1.append("Item;");
              _builder_1.newLineIfNotEmpty();
            }
          }
          _builder_1.append("\t");
          _builder_1.append("data.");
          String _name_7 = el.getName();
          _builder_1.append(_name_7, "\t");
          _builder_1.append(".push_back(data_");
          String _name_8 = el.getName();
          _builder_1.append(_name_8, "\t");
          _builder_1.append("Item);");
          _builder_1.newLineIfNotEmpty();
          _builder_1.append("}");
          _builder_1.newLine();
          String _plus = (result + _builder_1);
          result = _plus;
        } else {
          boolean _isComposedType_1 = this._communicationObjectUtility.isComposedType(el.getType());
          if (_isComposedType_1) {
            StringConcatenation _builder_2 = new StringConcatenation();
            CharSequence _fullyQualifiedUserType_1 = this.getFullyQualifiedUserType(el.getType());
            _builder_2.append(_fullyQualifiedUserType_1);
            _builder_2.append("::deserialize(cdr, data.");
            String _name_9 = el.getName();
            _builder_2.append(_name_9);
            _builder_2.append(");");
            _builder_2.newLineIfNotEmpty();
            String _plus_1 = (result + _builder_2);
            result = _plus_1;
          } else {
            boolean _isStringType = this._communicationObjectUtility.isStringType(type);
            if (_isStringType) {
              StringConcatenation _builder_3 = new StringConcatenation();
              _builder_3.append("ACE_CString data_");
              String _name_10 = el.getName();
              _builder_3.append(_name_10);
              _builder_3.append("_str;");
              _builder_3.newLineIfNotEmpty();
              _builder_3.append("cdr >> data_");
              String _name_11 = el.getName();
              _builder_3.append(_name_11);
              _builder_3.append("_str;");
              _builder_3.newLineIfNotEmpty();
              _builder_3.append("data.");
              String _name_12 = el.getName();
              _builder_3.append(_name_12);
              _builder_3.append(" = data_");
              String _name_13 = el.getName();
              _builder_3.append(_name_13);
              _builder_3.append("_str.c_str();");
              _builder_3.newLineIfNotEmpty();
              String _plus_2 = (result + _builder_3);
              result = _plus_2;
            } else {
              boolean _isLonglongType = this._communicationObjectUtility.isLonglongType(el.getType());
              if (_isLonglongType) {
                StringConcatenation _builder_4 = new StringConcatenation();
                _builder_4.append("// deserialize string-type element ");
                String _name_14 = el.getName();
                _builder_4.append(_name_14);
                _builder_4.newLineIfNotEmpty();
                _builder_4.append("ACE_CDR::");
                String _compileCdrType = this._commObjectGenHelpers.compileCdrType(el.getType());
                _builder_4.append(_compileCdrType);
                _builder_4.append(" data_");
                String _name_15 = el.getName();
                _builder_4.append(_name_15);
                _builder_4.append("_ll;");
                _builder_4.newLineIfNotEmpty();
                _builder_4.append("good_bit = good_bit && cdr.read_");
                String _lowerCase = this._commObjectGenHelpers.compileCdrType(el.getType()).toLowerCase();
                _builder_4.append(_lowerCase);
                _builder_4.append("(data_");
                String _name_16 = el.getName();
                _builder_4.append(_name_16);
                _builder_4.append("_ll);");
                _builder_4.newLineIfNotEmpty();
                _builder_4.append("data.");
                String _name_17 = el.getName();
                _builder_4.append(_name_17);
                _builder_4.append(" = data_");
                String _name_18 = el.getName();
                _builder_4.append(_name_18);
                _builder_4.append("_ll;");
                _builder_4.newLineIfNotEmpty();
                String _plus_3 = (result + _builder_4);
                result = _plus_3;
              } else {
                StringConcatenation _builder_5 = new StringConcatenation();
                _builder_5.append("cdr.read_");
                String _lowerCase_1 = this._commObjectGenHelpers.compileCdrType(el.getType()).toLowerCase();
                _builder_5.append(_lowerCase_1);
                _builder_5.append("(data.");
                String _name_19 = el.getName();
                _builder_5.append(_name_19);
                _builder_5.append(");");
                _builder_5.newLineIfNotEmpty();
                String _plus_4 = (result + _builder_5);
                result = _plus_4;
              }
            }
          }
        }
      }
    }
    return result;
  }
  
  public String generateInputCdrOperator(final CommunicationObject co) {
    StringConcatenation _builder = new StringConcatenation();
    String result = _builder.toString();
    EList<AttributeDefinition> _attributes = co.getAttributes();
    for (final AttributeDefinition el : _attributes) {
      boolean _many = this._commObjectGenHelpers.getMany(el);
      boolean _equals = (_many == true);
      if (_equals) {
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("// deserialize list-type element ");
        String _name = el.getName();
        _builder_1.append(_name);
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("ACE_CDR::ULong data_");
        String _name_1 = el.getName();
        _builder_1.append(_name_1);
        _builder_1.append("Nbr;");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("good_bit = good_bit && cdr >> data_");
        String _name_2 = el.getName();
        _builder_1.append(_name_2);
        _builder_1.append("Nbr;");
        _builder_1.newLineIfNotEmpty();
        String _plus = (result + _builder_1);
        result = _plus;
        if (((this._communicationObjectUtility.isComposedType(el.getType()) || this._communicationObjectUtility.isStringType(el.getType())) || this._communicationObjectUtility.isBooleanType(el.getType()))) {
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("data.");
          String _name_3 = el.getName();
          _builder_2.append(_name_3);
          _builder_2.append(".clear();");
          _builder_2.newLineIfNotEmpty();
          CharSequence _fullyQualifiedIdlType = this.getFullyQualifiedIdlType(el.getType());
          _builder_2.append(_fullyQualifiedIdlType);
          _builder_2.append(" data_");
          String _name_4 = el.getName();
          _builder_2.append(_name_4);
          _builder_2.append("Item;");
          _builder_2.newLineIfNotEmpty();
          _builder_2.append("for(ACE_CDR::ULong i=0; i<data_");
          String _name_5 = el.getName();
          _builder_2.append(_name_5);
          _builder_2.append("Nbr; ++i) {");
          _builder_2.newLineIfNotEmpty();
          {
            boolean _isBooleanType = this._communicationObjectUtility.isBooleanType(el.getType());
            if (_isBooleanType) {
              _builder_2.append("\t");
              _builder_2.append("good_bit = good_bit && cdr.read_boolean(data_");
              String _name_6 = el.getName();
              _builder_2.append(_name_6, "\t");
              _builder_2.append("Item);");
              _builder_2.newLineIfNotEmpty();
            } else {
              _builder_2.append("\t");
              _builder_2.append("good_bit = good_bit && cdr >> data_");
              String _name_7 = el.getName();
              _builder_2.append(_name_7, "\t");
              _builder_2.append("Item;");
              _builder_2.newLineIfNotEmpty();
            }
          }
          {
            boolean _isStringType = this._communicationObjectUtility.isStringType(el.getType());
            if (_isStringType) {
              _builder_2.append("\t");
              _builder_2.append("data.");
              String _name_8 = el.getName();
              _builder_2.append(_name_8, "\t");
              _builder_2.append(".push_back(data_");
              String _name_9 = el.getName();
              _builder_2.append(_name_9, "\t");
              _builder_2.append("Item.c_str());");
              _builder_2.newLineIfNotEmpty();
            } else {
              _builder_2.append("\t");
              _builder_2.append("data.");
              String _name_10 = el.getName();
              _builder_2.append(_name_10, "\t");
              _builder_2.append(".push_back(data_");
              String _name_11 = el.getName();
              _builder_2.append(_name_11, "\t");
              _builder_2.append("Item);");
              _builder_2.newLineIfNotEmpty();
            }
          }
          _builder_2.append("}");
          _builder_2.newLine();
          String _plus_1 = (result + _builder_2);
          result = _plus_1;
        } else {
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append("data.");
          String _name_12 = el.getName();
          _builder_3.append(_name_12);
          _builder_3.append(".resize(data_");
          String _name_13 = el.getName();
          _builder_3.append(_name_13);
          _builder_3.append("Nbr);");
          _builder_3.newLineIfNotEmpty();
          _builder_3.append("good_bit = good_bit && cdr.read_");
          String _lowerCase = this._commObjectGenHelpers.compileCdrType(el.getType()).toLowerCase();
          _builder_3.append(_lowerCase);
          _builder_3.append("_array(data.");
          String _name_14 = el.getName();
          _builder_3.append(_name_14);
          _builder_3.append(".data(), data_");
          String _name_15 = el.getName();
          _builder_3.append(_name_15);
          _builder_3.append("Nbr);");
          _builder_3.newLineIfNotEmpty();
          String _plus_2 = (result + _builder_3);
          result = _plus_2;
        }
      } else {
        boolean _isComposedType = this._communicationObjectUtility.isComposedType(el.getType());
        if (_isComposedType) {
          StringConcatenation _builder_4 = new StringConcatenation();
          _builder_4.append("// deserialize type element ");
          String _name_16 = el.getName();
          _builder_4.append(_name_16);
          _builder_4.newLineIfNotEmpty();
          _builder_4.append("good_bit = good_bit && cdr >> data.");
          String _name_17 = el.getName();
          _builder_4.append(_name_17);
          _builder_4.append(";");
          _builder_4.newLineIfNotEmpty();
          String _plus_3 = (result + _builder_4);
          result = _plus_3;
        } else {
          boolean _isStringType_1 = this._communicationObjectUtility.isStringType(el.getType());
          if (_isStringType_1) {
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("// deserialize string-type element ");
            String _name_18 = el.getName();
            _builder_5.append(_name_18);
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("ACE_CString data_");
            String _name_19 = el.getName();
            _builder_5.append(_name_19);
            _builder_5.append("_str;");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("good_bit = good_bit && cdr >> data_");
            String _name_20 = el.getName();
            _builder_5.append(_name_20);
            _builder_5.append("_str;");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append("data.");
            String _name_21 = el.getName();
            _builder_5.append(_name_21);
            _builder_5.append(" = data_");
            String _name_22 = el.getName();
            _builder_5.append(_name_22);
            _builder_5.append("_str.c_str();");
            _builder_5.newLineIfNotEmpty();
            String _plus_4 = (result + _builder_5);
            result = _plus_4;
          } else {
            boolean _isLonglongType = this._communicationObjectUtility.isLonglongType(el.getType());
            if (_isLonglongType) {
              StringConcatenation _builder_6 = new StringConcatenation();
              _builder_6.append("// deserialize string-type element ");
              String _name_23 = el.getName();
              _builder_6.append(_name_23);
              _builder_6.newLineIfNotEmpty();
              _builder_6.append("ACE_CDR::");
              String _compileCdrType = this._commObjectGenHelpers.compileCdrType(el.getType());
              _builder_6.append(_compileCdrType);
              _builder_6.append(" data_");
              String _name_24 = el.getName();
              _builder_6.append(_name_24);
              _builder_6.append("_ll;");
              _builder_6.newLineIfNotEmpty();
              _builder_6.append("good_bit = good_bit && cdr.read_");
              String _lowerCase_1 = this._commObjectGenHelpers.compileCdrType(el.getType()).toLowerCase();
              _builder_6.append(_lowerCase_1);
              _builder_6.append("(data_");
              String _name_25 = el.getName();
              _builder_6.append(_name_25);
              _builder_6.append("_ll);");
              _builder_6.newLineIfNotEmpty();
              _builder_6.append("data.");
              String _name_26 = el.getName();
              _builder_6.append(_name_26);
              _builder_6.append(" = data_");
              String _name_27 = el.getName();
              _builder_6.append(_name_27);
              _builder_6.append("_ll;");
              _builder_6.newLineIfNotEmpty();
              String _plus_5 = (result + _builder_6);
              result = _plus_5;
            } else {
              StringConcatenation _builder_7 = new StringConcatenation();
              _builder_7.append("// deserialize type element ");
              String _name_28 = el.getName();
              _builder_7.append(_name_28);
              _builder_7.newLineIfNotEmpty();
              _builder_7.append("good_bit = good_bit && cdr.read_");
              String _lowerCase_2 = this._commObjectGenHelpers.compileCdrType(el.getType()).toLowerCase();
              _builder_7.append(_lowerCase_2);
              _builder_7.append("(data.");
              String _name_29 = el.getName();
              _builder_7.append(_name_29);
              _builder_7.append(");");
              _builder_7.newLineIfNotEmpty();
              String _plus_6 = (result + _builder_7);
              result = _plus_6;
            }
          }
        }
      }
    }
    return result;
  }
  
  public String generateSTLOutputStream(final CommunicationObject co) {
    String _xblockexpression = null;
    {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("os << \"");
      String _name = co.getName();
      _builder.append(_name);
      _builder.append("(\";");
      _builder.newLineIfNotEmpty();
      String result = _builder.toString();
      EList<AttributeDefinition> _attributes = co.getAttributes();
      for (final AttributeDefinition el : _attributes) {
        boolean _many = this._commObjectGenHelpers.getMany(el);
        if (_many) {
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("std::vector<");
          CharSequence _fullyQualifiedUserType = this.getFullyQualifiedUserType(el.getType());
          _builder_1.append(_fullyQualifiedUserType);
          _builder_1.append(">::const_iterator ");
          String _name_1 = el.getName();
          _builder_1.append(_name_1);
          _builder_1.append("It;");
          _builder_1.newLineIfNotEmpty();
          _builder_1.append("std::vector<");
          CharSequence _fullyQualifiedUserType_1 = this.getFullyQualifiedUserType(el.getType());
          _builder_1.append(_fullyQualifiedUserType_1);
          _builder_1.append("> ");
          String _name_2 = el.getName();
          _builder_1.append(_name_2);
          _builder_1.append("List = get");
          String _firstUpper = StringExtensions.toFirstUpper(el.getName());
          _builder_1.append(_firstUpper);
          _builder_1.append("Copy();");
          _builder_1.newLineIfNotEmpty();
          _builder_1.append("for(");
          String _name_3 = el.getName();
          _builder_1.append(_name_3);
          _builder_1.append("It=");
          String _name_4 = el.getName();
          _builder_1.append(_name_4);
          _builder_1.append("List.begin(); ");
          String _name_5 = el.getName();
          _builder_1.append(_name_5);
          _builder_1.append("It!=");
          String _name_6 = el.getName();
          _builder_1.append(_name_6);
          _builder_1.append("List.end(); ");
          String _name_7 = el.getName();
          _builder_1.append(_name_7);
          _builder_1.append("It++) {");
          _builder_1.newLineIfNotEmpty();
          {
            AbstractAttributeType _type = el.getType();
            if ((_type instanceof PrimitiveType)) {
              _builder_1.append("\t");
              _builder_1.append("os << *");
              String _name_8 = el.getName();
              _builder_1.append(_name_8, "\t");
              _builder_1.append("It << \" \";");
              _builder_1.newLineIfNotEmpty();
            } else {
              _builder_1.append("\t");
              String _name_9 = el.getName();
              _builder_1.append(_name_9, "\t");
              _builder_1.append("It->to_ostream(os);");
              _builder_1.newLineIfNotEmpty();
            }
          }
          _builder_1.append("}");
          _builder_1.newLine();
          String _plus = (result + _builder_1);
          result = _plus;
        } else {
          StringConcatenation _builder_2 = new StringConcatenation();
          {
            AbstractAttributeType _type_1 = el.getType();
            if ((_type_1 instanceof PrimitiveType)) {
              _builder_2.append("os << get");
              String _firstUpper_1 = StringExtensions.toFirstUpper(el.getName());
              _builder_2.append(_firstUpper_1);
              _builder_2.append("() << \" \";");
              _builder_2.newLineIfNotEmpty();
            } else {
              _builder_2.append("get");
              String _firstUpper_2 = StringExtensions.toFirstUpper(el.getName());
              _builder_2.append(_firstUpper_2);
              _builder_2.append("().to_ostream(os);");
              _builder_2.newLineIfNotEmpty();
            }
          }
          String _plus_1 = (result + _builder_2);
          result = _plus_1;
        }
      }
      StringConcatenation _builder_3 = new StringConcatenation();
      _builder_3.append("os << \") \";");
      _builder_3.newLine();
      String _plus_2 = (result + _builder_3);
      result = _plus_2;
      _xblockexpression = result;
    }
    return _xblockexpression;
  }
  
  public String generateXmlOutputStream(final CommunicationObject co) {
    String _xblockexpression = null;
    {
      String result = "";
      final Function1<AttributeDefinition, Boolean> _function = (AttributeDefinition el) -> {
        return Boolean.valueOf(this._commObjectGenHelpers.getMany(el));
      };
      boolean _exists = IterableExtensions.<AttributeDefinition>exists(co.getAttributes(), _function);
      if (_exists) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("size_t counter = 0;");
        _builder.newLine();
        _builder.newLine();
        result = _builder.toString();
      }
      EList<AttributeDefinition> _attributes = co.getAttributes();
      for (final AttributeDefinition el : _attributes) {
        boolean _many = this._commObjectGenHelpers.getMany(el);
        if (_many) {
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("std::vector<");
          CharSequence _fullyQualifiedUserType = this.getFullyQualifiedUserType(el.getType());
          _builder_1.append(_fullyQualifiedUserType);
          _builder_1.append(">::const_iterator ");
          String _name = el.getName();
          _builder_1.append(_name);
          _builder_1.append("It;");
          _builder_1.newLineIfNotEmpty();
          _builder_1.append("std::vector<");
          CharSequence _fullyQualifiedUserType_1 = this.getFullyQualifiedUserType(el.getType());
          _builder_1.append(_fullyQualifiedUserType_1);
          _builder_1.append("> ");
          String _name_1 = el.getName();
          _builder_1.append(_name_1);
          _builder_1.append("List = get");
          String _firstUpper = StringExtensions.toFirstUpper(el.getName());
          _builder_1.append(_firstUpper);
          _builder_1.append("Copy();");
          _builder_1.newLineIfNotEmpty();
          _builder_1.append("counter = 0;");
          _builder_1.newLine();
          _builder_1.append("os << indent << \"<");
          String _name_2 = el.getName();
          _builder_1.append(_name_2);
          _builder_1.append("List n=\\\"\" << ");
          String _name_3 = el.getName();
          _builder_1.append(_name_3);
          _builder_1.append("List.size() << \"\\\">\";");
          _builder_1.newLineIfNotEmpty();
          _builder_1.append("for(");
          String _name_4 = el.getName();
          _builder_1.append(_name_4);
          _builder_1.append("It=");
          String _name_5 = el.getName();
          _builder_1.append(_name_5);
          _builder_1.append("List.begin(); ");
          String _name_6 = el.getName();
          _builder_1.append(_name_6);
          _builder_1.append("It!=");
          String _name_7 = el.getName();
          _builder_1.append(_name_7);
          _builder_1.append("List.end(); ");
          String _name_8 = el.getName();
          _builder_1.append(_name_8);
          _builder_1.append("It++) {");
          _builder_1.newLineIfNotEmpty();
          {
            AbstractAttributeType _type = el.getType();
            if ((_type instanceof PrimitiveType)) {
              _builder_1.append("\t");
              _builder_1.append("os << indent << \"<");
              String _name_9 = el.getName();
              _builder_1.append(_name_9, "\t");
              _builder_1.append(" i=\\\"\" << counter++ << \"\\\">\" << *");
              String _name_10 = el.getName();
              _builder_1.append(_name_10, "\t");
              _builder_1.append("It << \"</");
              String _name_11 = el.getName();
              _builder_1.append(_name_11, "\t");
              _builder_1.append(">\";");
              _builder_1.newLineIfNotEmpty();
            } else {
              _builder_1.append("\t");
              _builder_1.append("os << indent << \"<");
              String _name_12 = el.getName();
              _builder_1.append(_name_12, "\t");
              _builder_1.append(" i=\\\"\" << counter++ << \"\\\">\";");
              _builder_1.newLineIfNotEmpty();
              _builder_1.append("\t");
              String _name_13 = el.getName();
              _builder_1.append(_name_13, "\t");
              _builder_1.append("It->to_xml(os, indent);");
              _builder_1.newLineIfNotEmpty();
              _builder_1.append("\t");
              _builder_1.append("os << indent << \"</");
              String _name_14 = el.getName();
              _builder_1.append(_name_14, "\t");
              _builder_1.append(">\";");
              _builder_1.newLineIfNotEmpty();
            }
          }
          _builder_1.append("}");
          _builder_1.newLine();
          _builder_1.append("os << indent << \"</");
          String _name_15 = el.getName();
          _builder_1.append(_name_15);
          _builder_1.append("List>\";");
          _builder_1.newLineIfNotEmpty();
          String _plus = (result + _builder_1);
          result = _plus;
        } else {
          StringConcatenation _builder_2 = new StringConcatenation();
          {
            AbstractAttributeType _type_1 = el.getType();
            if ((_type_1 instanceof PrimitiveType)) {
              _builder_2.append("os << indent << \"<");
              String _name_16 = el.getName();
              _builder_2.append(_name_16);
              _builder_2.append(">\" << get");
              String _firstUpper_1 = StringExtensions.toFirstUpper(el.getName());
              _builder_2.append(_firstUpper_1);
              _builder_2.append("() << \"</");
              String _name_17 = el.getName();
              _builder_2.append(_name_17);
              _builder_2.append(">\";");
              _builder_2.newLineIfNotEmpty();
            } else {
              _builder_2.append("os << indent << \"<");
              String _name_18 = el.getName();
              _builder_2.append(_name_18);
              _builder_2.append(">\";");
              _builder_2.newLineIfNotEmpty();
              _builder_2.append("get");
              String _firstUpper_2 = StringExtensions.toFirstUpper(el.getName());
              _builder_2.append(_firstUpper_2);
              _builder_2.append("().to_xml(os, indent);");
              _builder_2.newLineIfNotEmpty();
              _builder_2.append("os << indent << \"</");
              String _name_19 = el.getName();
              _builder_2.append(_name_19);
              _builder_2.append(">\";");
              _builder_2.newLineIfNotEmpty();
            }
          }
          String _plus_1 = (result + _builder_2);
          result = _plus_1;
        }
      }
      _xblockexpression = result;
    }
    return _xblockexpression;
  }
  
  public String generateXmlInputStream(final CommunicationObject co) {
    String _xblockexpression = null;
    {
      String result = "";
      final Function1<AttributeDefinition, Boolean> _function = (AttributeDefinition el) -> {
        return Boolean.valueOf(this._commObjectGenHelpers.getMany(el));
      };
      boolean _exists = IterableExtensions.<AttributeDefinition>exists(co.getAttributes(), _function);
      if (_exists) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("size_t counter = 0;");
        _builder.newLine();
        _builder.newLine();
        result = _builder.toString();
      }
      EList<AttributeDefinition> _attributes = co.getAttributes();
      for (final AttributeDefinition el : _attributes) {
        boolean _many = this._commObjectGenHelpers.getMany(el);
        if (_many) {
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("static const Smart::KnuthMorrisPratt kmp_");
          String _name = el.getName();
          _builder_1.append(_name);
          _builder_1.append("List(\"<");
          String _name_1 = el.getName();
          _builder_1.append(_name_1);
          _builder_1.append("List n=\\\"\");");
          _builder_1.newLineIfNotEmpty();
          _builder_1.append("static const Smart::KnuthMorrisPratt kmp_");
          String _name_2 = el.getName();
          _builder_1.append(_name_2);
          _builder_1.append("(\"\\\">\");");
          _builder_1.newLineIfNotEmpty();
          String _plus = (result + _builder_1);
          result = _plus;
        } else {
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("static const Smart::KnuthMorrisPratt kmp_");
          String _name_3 = el.getName();
          _builder_2.append(_name_3);
          _builder_2.append("(\"<");
          String _name_4 = el.getName();
          _builder_2.append(_name_4);
          _builder_2.append(">\");");
          _builder_2.newLineIfNotEmpty();
          String _plus_1 = (result + _builder_2);
          result = _plus_1;
        }
      }
      result = (result + "\n");
      EList<AttributeDefinition> _attributes_1 = co.getAttributes();
      for (final AttributeDefinition el_1 : _attributes_1) {
        boolean _many_1 = this._commObjectGenHelpers.getMany(el_1);
        if (_many_1) {
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append("if(kmp_");
          String _name_5 = el_1.getName();
          _builder_3.append(_name_5);
          _builder_3.append("List.search(is)) {");
          _builder_3.newLineIfNotEmpty();
          _builder_3.append("\t");
          _builder_3.append("size_t numberElements;");
          _builder_3.newLine();
          _builder_3.append("\t");
          _builder_3.append("is >> numberElements;");
          _builder_3.newLine();
          _builder_3.append("\t");
          CharSequence _fullyQualifiedUserType = this.getFullyQualifiedUserType(el_1.getType());
          _builder_3.append(_fullyQualifiedUserType, "\t");
          _builder_3.append(" ");
          String _name_6 = el_1.getName();
          _builder_3.append(_name_6, "\t");
          _builder_3.append("Item;");
          _builder_3.newLineIfNotEmpty();
          _builder_3.append("\t");
          _builder_3.append("std::vector<");
          CharSequence _fullyQualifiedUserType_1 = this.getFullyQualifiedUserType(el_1.getType());
          _builder_3.append(_fullyQualifiedUserType_1, "\t");
          _builder_3.append("> ");
          String _name_7 = el_1.getName();
          _builder_3.append(_name_7, "\t");
          _builder_3.append("List;");
          _builder_3.newLineIfNotEmpty();
          _builder_3.append("\t");
          _builder_3.append("kmp_");
          String _name_8 = el_1.getName();
          _builder_3.append(_name_8, "\t");
          _builder_3.append(".search(is);");
          _builder_3.newLineIfNotEmpty();
          _builder_3.append("\t");
          _builder_3.append("for(counter=0; counter<numberElements; counter++) {");
          _builder_3.newLine();
          _builder_3.append("\t\t");
          _builder_3.append("if(kmp_");
          String _name_9 = el_1.getName();
          _builder_3.append(_name_9, "\t\t");
          _builder_3.append(".search(is)) {");
          _builder_3.newLineIfNotEmpty();
          {
            AbstractAttributeType _type = el_1.getType();
            if ((_type instanceof PrimitiveType)) {
              _builder_3.append("\t\t\t");
              _builder_3.append("is >> ");
              String _name_10 = el_1.getName();
              _builder_3.append(_name_10, "\t\t\t");
              _builder_3.append("Item;");
              _builder_3.newLineIfNotEmpty();
            } else {
              _builder_3.append("\t\t\t");
              String _name_11 = el_1.getName();
              _builder_3.append(_name_11, "\t\t\t");
              _builder_3.append("Item.from_xml(is);");
              _builder_3.newLineIfNotEmpty();
            }
          }
          _builder_3.append("\t\t\t");
          String _name_12 = el_1.getName();
          _builder_3.append(_name_12, "\t\t\t");
          _builder_3.append("List.push_back(");
          String _name_13 = el_1.getName();
          _builder_3.append(_name_13, "\t\t\t");
          _builder_3.append("Item);");
          _builder_3.newLineIfNotEmpty();
          _builder_3.append("\t\t");
          _builder_3.append("}");
          _builder_3.newLine();
          _builder_3.append("\t");
          _builder_3.append("}");
          _builder_3.newLine();
          _builder_3.append("\t");
          _builder_3.append("set");
          String _firstUpper = StringExtensions.toFirstUpper(el_1.getName());
          _builder_3.append(_firstUpper, "\t");
          _builder_3.append("(");
          String _name_14 = el_1.getName();
          _builder_3.append(_name_14, "\t");
          _builder_3.append("List);");
          _builder_3.newLineIfNotEmpty();
          _builder_3.append("}");
          _builder_3.newLine();
          String _plus_2 = (result + _builder_3);
          result = _plus_2;
        } else {
          StringConcatenation _builder_4 = new StringConcatenation();
          _builder_4.append("if(kmp_");
          String _name_15 = el_1.getName();
          _builder_4.append(_name_15);
          _builder_4.append(".search(is)) {");
          _builder_4.newLineIfNotEmpty();
          _builder_4.append("\t");
          CharSequence _fullyQualifiedUserType_2 = this.getFullyQualifiedUserType(el_1.getType());
          _builder_4.append(_fullyQualifiedUserType_2, "\t");
          _builder_4.append(" ");
          String _name_16 = el_1.getName();
          _builder_4.append(_name_16, "\t");
          _builder_4.append("Item;");
          _builder_4.newLineIfNotEmpty();
          {
            AbstractAttributeType _type_1 = el_1.getType();
            if ((_type_1 instanceof PrimitiveType)) {
              _builder_4.append("\t");
              _builder_4.append("is >> ");
              String _name_17 = el_1.getName();
              _builder_4.append(_name_17, "\t");
              _builder_4.append("Item;");
              _builder_4.newLineIfNotEmpty();
            } else {
              _builder_4.append("\t");
              String _name_18 = el_1.getName();
              _builder_4.append(_name_18, "\t");
              _builder_4.append("Item.from_xml(is);");
              _builder_4.newLineIfNotEmpty();
            }
          }
          _builder_4.append("\t");
          _builder_4.append("set");
          String _firstUpper_1 = StringExtensions.toFirstUpper(el_1.getName());
          _builder_4.append(_firstUpper_1, "\t");
          _builder_4.append("(");
          String _name_19 = el_1.getName();
          _builder_4.append(_name_19, "\t");
          _builder_4.append("Item);");
          _builder_4.newLineIfNotEmpty();
          _builder_4.append("}");
          _builder_4.newLine();
          String _plus_3 = (result + _builder_4);
          result = _plus_3;
        }
      }
      _xblockexpression = result;
    }
    return _xblockexpression;
  }
  
  /**
   * Generate Data-Hash
   */
  public String generateDataHash(final CommunicationObject co) {
    return this.generateDataHashInternal(co.getAttributes());
  }
  
  private String generateDataHashInternal(final EList<AttributeDefinition> elements) {
    StringConcatenation _builder = new StringConcatenation();
    String result = _builder.toString();
    for (final AttributeDefinition el : elements) {
      boolean _many = this._commObjectGenHelpers.getMany(el);
      boolean _equals = (_many == true);
      if (_equals) {
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("std::vector<");
        CharSequence _fullyQualifiedIdlType = this.getFullyQualifiedIdlType(el.getType());
        _builder_1.append(_fullyQualifiedIdlType);
        _builder_1.append(">::const_iterator data_");
        String _name = el.getName();
        _builder_1.append(_name);
        _builder_1.append("It;");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("for(data_");
        String _name_1 = el.getName();
        _builder_1.append(_name_1);
        _builder_1.append("It=data.");
        String _name_2 = el.getName();
        _builder_1.append(_name_2);
        _builder_1.append(".begin(); data_");
        String _name_3 = el.getName();
        _builder_1.append(_name_3);
        _builder_1.append("It!=data.");
        String _name_4 = el.getName();
        _builder_1.append(_name_4);
        _builder_1.append(".end(); data_");
        String _name_5 = el.getName();
        _builder_1.append(_name_5);
        _builder_1.append("It++) {");
        _builder_1.newLineIfNotEmpty();
        {
          boolean _isComposedType = this._communicationObjectUtility.isComposedType(el.getType());
          if (_isComposedType) {
            _builder_1.append("\t");
            _builder_1.append("seed += ");
            CharSequence _fullyQualifiedUserType = this.getFullyQualifiedUserType(el.getType());
            _builder_1.append(_fullyQualifiedUserType, "\t");
            _builder_1.append("::generateDataHash(*data_");
            String _name_6 = el.getName();
            _builder_1.append(_name_6, "\t");
            _builder_1.append("It);");
            _builder_1.newLineIfNotEmpty();
          } else {
            {
              boolean _isStringType = this._communicationObjectUtility.isStringType(el.getType());
              if (_isStringType) {
                _builder_1.append("\t");
                _builder_1.append("boost::hash_combine(seed, std::string(data_");
                String _name_7 = el.getName();
                _builder_1.append(_name_7, "\t");
                _builder_1.append("It->c_str()));");
                _builder_1.newLineIfNotEmpty();
              } else {
                _builder_1.append("\t");
                _builder_1.append("boost::hash_combine(seed, *data_");
                String _name_8 = el.getName();
                _builder_1.append(_name_8, "\t");
                _builder_1.append("It);");
                _builder_1.newLineIfNotEmpty();
              }
            }
          }
        }
        _builder_1.append("}");
        _builder_1.newLine();
        String _plus = (result + _builder_1);
        result = _plus;
      } else {
        boolean _isComposedType_1 = this._communicationObjectUtility.isComposedType(el.getType());
        if (_isComposedType_1) {
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("seed += ");
          CharSequence _fullyQualifiedUserType_1 = this.getFullyQualifiedUserType(el.getType());
          _builder_2.append(_fullyQualifiedUserType_1);
          _builder_2.append("::generateDataHash(data.");
          String _name_9 = el.getName();
          _builder_2.append(_name_9);
          _builder_2.append(");");
          _builder_2.newLineIfNotEmpty();
          String _plus_1 = (result + _builder_2);
          result = _plus_1;
        } else {
          AbstractAttributeType type = el.getType();
          boolean _isStringType_1 = this._communicationObjectUtility.isStringType(type);
          if (_isStringType_1) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("boost::hash_combine(seed, std::string(data.");
            String _name_10 = el.getName();
            _builder_3.append(_name_10);
            _builder_3.append(".c_str()));");
            _builder_3.newLineIfNotEmpty();
            String _plus_2 = (result + _builder_3);
            result = _plus_2;
          } else {
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("boost::hash_combine(seed, data.");
            String _name_11 = el.getName();
            _builder_4.append(_name_11);
            _builder_4.append(");");
            _builder_4.newLineIfNotEmpty();
            String _plus_3 = (result + _builder_4);
            result = _plus_3;
          }
        }
      }
    }
    return result;
  }
  
  private CharSequence getFullyQualifiedIdlType(final AbstractAttributeType t) {
    if (t instanceof PrimitiveType) {
      return _getFullyQualifiedIdlType((PrimitiveType)t);
    } else if (t instanceof CommElementReference) {
      return _getFullyQualifiedIdlType((CommElementReference)t);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(t).toString());
    }
  }
  
  private CharSequence getFullyQualifiedUserType(final AbstractAttributeType t) {
    if (t instanceof PrimitiveType) {
      return _getFullyQualifiedUserType((PrimitiveType)t);
    } else if (t instanceof CommElementReference) {
      return _getFullyQualifiedUserType((CommElementReference)t);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(t).toString());
    }
  }
}
