/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinition;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentPort;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.roboticMiddleware.ACE_SmartSoft;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.CommObjectGenHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.ComponentGenHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.SmartComponent;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class SmartComponentPortFactory {
  @Inject
  @Extension
  private SmartComponent _smartComponent;
  
  @Inject
  @Extension
  private CopyrightHelpers _copyrightHelpers;
  
  @Inject
  @Extension
  private ComponentGenHelpers _componentGenHelpers;
  
  @Inject
  @Extension
  private CommObjectGenHelpers _commObjectGenHelpers;
  
  public String getPortFactoryInterfaceFilename(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("PortFactoryInterface.hh");
    return _builder.toString();
  }
  
  public String getAcePortFactoryHeaderFilename(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("AcePortFactory.hh");
    return _builder.toString();
  }
  
  public String getAcePortFactorySourceFilename(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("AcePortFactory.cc");
    return _builder.toString();
  }
  
  public CharSequence compilePortFactoryInterface(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#ifndef ");
    String _upperCase = component.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_PORTFACTORYINTERFACE_HH_");
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    String _upperCase_1 = component.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_PORTFACTORYINTERFACE_HH_");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// include communication objects");
    _builder.newLine();
    {
      final Function1<CommunicationObject, String> _function = (CommunicationObject it) -> {
        return it.getName();
      };
      List<CommunicationObject> _sortBy = IterableExtensions.<CommunicationObject, String>sortBy(ComponentDefinitionModelUtility.getAllCommObjects(component), _function);
      for(final CommunicationObject obj : _sortBy) {
        _builder.append("#include <");
        CharSequence _userClassHeaderFileNameFQN = this._commObjectGenHelpers.getUserClassHeaderFileNameFQN(obj);
        _builder.append(_userClassHeaderFileNameFQN);
        _builder.append(">");
        _builder.newLineIfNotEmpty();
        _builder.append("#include <");
        CharSequence _serailizationHeaderFileNameFQN = this._commObjectGenHelpers.getSerailizationHeaderFileNameFQN(obj);
        _builder.append(_serailizationHeaderFileNameFQN);
        _builder.append(">");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("#include <chrono>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("// include component\'s main class");
    _builder.newLine();
    _builder.append("#include \"");
    String _compHeaderFilename = this._smartComponent.getCompHeaderFilename(component);
    _builder.append(_compHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// forward declaration");
    _builder.newLine();
    _builder.append("class ");
    String _nameClass = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("class ");
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("PortFactoryInterface {");
    _builder.newLineIfNotEmpty();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    String _name_1 = component.getName();
    _builder.append(_name_1, "\t");
    _builder.append("PortFactoryInterface() { };");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("virtual ~");
    String _name_2 = component.getName();
    _builder.append(_name_2, "\t");
    _builder.append("PortFactoryInterface() { };");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void initialize(");
    String _nameClass_1 = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass_1, "\t");
    _builder.append(" *component, int argc, char* argv[]) = 0;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("virtual int onStartup() = 0;");
    _builder.newLine();
    _builder.newLine();
    {
      final Function1<ComponentPort, String> _function_1 = (ComponentPort it) -> {
        return it.getName();
      };
      List<ComponentPort> _sortBy_1 = IterableExtensions.<ComponentPort, String>sortBy(this._componentGenHelpers.getAllClientPorts(component), _function_1);
      for(final ComponentPort port : _sortBy_1) {
        _builder.append("\t");
        _builder.append("virtual ");
        String _portDefinition = this._componentGenHelpers.getPortDefinition(port);
        _builder.append(_portDefinition, "\t");
        _builder.append(" * create");
        String _nameClass_2 = this._componentGenHelpers.nameClass(port);
        _builder.append(_nameClass_2, "\t");
        _builder.append("() = 0;");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    {
      final Function1<ComponentPort, String> _function_2 = (ComponentPort it) -> {
        return it.getName();
      };
      List<ComponentPort> _sortBy_2 = IterableExtensions.<ComponentPort, String>sortBy(this._componentGenHelpers.getAllServerPorts(component), _function_2);
      for(final ComponentPort port_1 : _sortBy_2) {
        _builder.append("\t");
        _builder.append("virtual ");
        String _portDefinition_1 = this._componentGenHelpers.getPortDefinition(port_1);
        _builder.append(_portDefinition_1, "\t");
        _builder.append(" * create");
        String _nameClass_3 = this._componentGenHelpers.nameClass(port_1);
        _builder.append(_nameClass_3, "\t");
        _builder.append("(const std::string &serviceName");
        {
          boolean _isEventServer = this._componentGenHelpers.isEventServer(port_1);
          if (_isEventServer) {
            _builder.append(", std::shared_ptr<Smart::IEventTestHandler<");
            CharSequence _commObjectCppList = this._componentGenHelpers.getCommObjectCppList(port_1, Boolean.valueOf(true));
            _builder.append(_commObjectCppList, "\t");
            _builder.append(">> ");
            String _nameInstance = this._componentGenHelpers.nameInstance(port_1);
            _builder.append(_nameInstance, "\t");
            _builder.append("EventTestHandler");
          }
        }
        _builder.append(") = 0;");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual int onShutdown(const std::chrono::steady_clock::duration &timeoutTime=std::chrono::seconds(2)) = 0;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void destroy() = 0;");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif /* ");
    String _upperCase_2 = component.getName().toUpperCase();
    _builder.append(_upperCase_2);
    _builder.append("_PORTFACTORYINTERFACE_HH_ */");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence compileAcePortFactoryHeader(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#ifndef ");
    String _upperCase = component.getName().toUpperCase();
    _builder.append(_upperCase);
    _builder.append("_ACE_PORTFACTORY_HH_");
    _builder.newLineIfNotEmpty();
    _builder.append("#define ");
    String _upperCase_1 = component.getName().toUpperCase();
    _builder.append(_upperCase_1);
    _builder.append("_ACE_PORTFACTORY_HH_");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// include ACE/SmartSoft component implementation");
    _builder.newLine();
    _builder.append("#include \"");
    String _compImplHeaderFilename = this._smartComponent.getCompImplHeaderFilename(component);
    _builder.append(_compImplHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// include the main component-definition class");
    _builder.newLine();
    _builder.append("#include \"");
    String _portFactoryInterfaceFilename = this.getPortFactoryInterfaceFilename(component);
    _builder.append(_portFactoryInterfaceFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("class ");
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("AcePortFactory: public ");
    String _name_1 = component.getName();
    _builder.append(_name_1);
    _builder.append("PortFactoryInterface");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("private:");
    _builder.newLine();
    _builder.append("\t");
    String _name_2 = component.getName();
    _builder.append(_name_2, "\t");
    _builder.append("Impl *componentImpl;");
    _builder.newLineIfNotEmpty();
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t");
    String _name_3 = component.getName();
    _builder.append(_name_3, "\t");
    _builder.append("AcePortFactory();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("virtual ~");
    String _name_4 = component.getName();
    _builder.append(_name_4, "\t");
    _builder.append("AcePortFactory();");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void initialize(");
    String _nameClass = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass, "\t");
    _builder.append(" *component, int argc, char* argv[]) override;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("virtual int onStartup() override;");
    _builder.newLine();
    _builder.newLine();
    {
      final Function1<ComponentPort, String> _function = (ComponentPort it) -> {
        return it.getName();
      };
      List<ComponentPort> _sortBy = IterableExtensions.<ComponentPort, String>sortBy(this._componentGenHelpers.getAllClientPorts(component), _function);
      for(final ComponentPort port : _sortBy) {
        _builder.append("\t");
        _builder.append("virtual ");
        String _portDefinition = this._componentGenHelpers.getPortDefinition(port);
        _builder.append(_portDefinition, "\t");
        _builder.append(" * create");
        String _nameClass_1 = this._componentGenHelpers.nameClass(port);
        _builder.append(_nameClass_1, "\t");
        _builder.append("() override;");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    {
      final Function1<ComponentPort, String> _function_1 = (ComponentPort it) -> {
        return it.getName();
      };
      List<ComponentPort> _sortBy_1 = IterableExtensions.<ComponentPort, String>sortBy(this._componentGenHelpers.getAllServerPorts(component), _function_1);
      for(final ComponentPort port_1 : _sortBy_1) {
        _builder.append("\t");
        _builder.append("virtual ");
        String _portDefinition_1 = this._componentGenHelpers.getPortDefinition(port_1);
        _builder.append(_portDefinition_1, "\t");
        _builder.append(" * create");
        String _nameClass_2 = this._componentGenHelpers.nameClass(port_1);
        _builder.append(_nameClass_2, "\t");
        _builder.append("(const std::string &serviceName");
        {
          boolean _isEventServer = this._componentGenHelpers.isEventServer(port_1);
          if (_isEventServer) {
            _builder.append(", std::shared_ptr<Smart::IEventTestHandler<");
            CharSequence _commObjectCppList = this._componentGenHelpers.getCommObjectCppList(port_1, Boolean.valueOf(true));
            _builder.append(_commObjectCppList, "\t");
            _builder.append(">> ");
            String _nameInstance = this._componentGenHelpers.nameInstance(port_1);
            _builder.append(_nameInstance, "\t");
            _builder.append("EventTestHandler");
          }
        }
        _builder.append(") override;");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// get a pointer to the internal component implementation");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("SmartACE::SmartComponent* getComponentImpl();");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual int onShutdown(const std::chrono::steady_clock::duration &timeoutTime=std::chrono::seconds(2)) override;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("virtual void destroy() override;");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#endif /* ");
    String _upperCase_2 = component.getName().toUpperCase();
    _builder.append(_upperCase_2);
    _builder.append("_ACE_PORTFACTORY_HH_ */");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence compileAcePortFactorySource(final ComponentDefinition component) {
    StringConcatenation _builder = new StringConcatenation();
    String _copyright = this._copyrightHelpers.getCopyright();
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("#include \"");
    String _acePortFactoryHeaderFilename = this.getAcePortFactoryHeaderFilename(component);
    _builder.append(_acePortFactoryHeaderFilename);
    _builder.append("\"");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("// create a static instance of the default AcePortFactory");
    _builder.newLine();
    _builder.append("static ");
    String _name = component.getName();
    _builder.append(_name);
    _builder.append("AcePortFactory acePortFactory;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    String _name_1 = component.getName();
    _builder.append(_name_1);
    _builder.append("AcePortFactory::");
    String _name_2 = component.getName();
    _builder.append(_name_2);
    _builder.append("AcePortFactory()");
    _builder.newLineIfNotEmpty();
    _builder.append("{  ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("componentImpl = 0;");
    _builder.newLine();
    _builder.append("\t");
    String _nameClass = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass, "\t");
    _builder.append("::instance()->addPortFactory(\"");
    String _simpleName = ACE_SmartSoft.class.getSimpleName();
    _builder.append(_simpleName, "\t");
    _builder.append("\", this);");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    String _name_3 = component.getName();
    _builder.append(_name_3);
    _builder.append("AcePortFactory::~");
    String _name_4 = component.getName();
    _builder.append(_name_4);
    _builder.append("AcePortFactory()");
    _builder.newLineIfNotEmpty();
    _builder.append("{  }");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    String _name_5 = component.getName();
    _builder.append(_name_5);
    _builder.append("AcePortFactory::initialize(");
    String _nameClass_1 = this._componentGenHelpers.nameClass(component);
    _builder.append(_nameClass_1);
    _builder.append(" *component, int argc, char* argv[])");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(component->connections.component.defaultScheduler != \"DEFAULT\") {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("ACE_Sched_Params sched_params(ACE_SCHED_OTHER, ACE_THR_PRI_OTHER_DEF);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("if(component->connections.component.defaultScheduler == \"FIFO\") {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("sched_params.policy(ACE_SCHED_FIFO);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("sched_params.priority(ACE_THR_PRI_FIFO_MIN);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("} else if(component->connections.component.defaultScheduler == \"RR\") {");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("sched_params.policy(ACE_SCHED_RR);");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("sched_params.priority(ACE_THR_PRI_RR_MIN);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// create new instance of the SmartSoft component with customized scheuling parameters ");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("componentImpl = new ");
    String _name_6 = component.getName();
    _builder.append(_name_6, "\t\t");
    _builder.append("Impl(component->connections.component.name, argc, argv, sched_params);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("} else {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// create new instance of the SmartSoft component");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("componentImpl = new ");
    String _name_7 = component.getName();
    _builder.append(_name_7, "\t\t");
    _builder.append("Impl(component->connections.component.name, argc, argv);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("int ");
    String _name_8 = component.getName();
    _builder.append(_name_8);
    _builder.append("AcePortFactory::onStartup()");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return componentImpl->startComponentInfrastructure();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    {
      final Function1<ComponentPort, String> _function = (ComponentPort it) -> {
        return it.getName();
      };
      List<ComponentPort> _sortBy = IterableExtensions.<ComponentPort, String>sortBy(this._componentGenHelpers.getAllClientPorts(component), _function);
      for(final ComponentPort port : _sortBy) {
        String _portDefinition = this._componentGenHelpers.getPortDefinition(port);
        _builder.append(_portDefinition);
        _builder.append(" * ");
        String _name_9 = component.getName();
        _builder.append(_name_9);
        _builder.append("AcePortFactory::create");
        String _nameClass_2 = this._componentGenHelpers.nameClass(port);
        _builder.append(_nameClass_2);
        _builder.append("()");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return new ");
        String _portImplementation = this._componentGenHelpers.getPortImplementation(port);
        _builder.append(_portImplementation, "\t");
        _builder.append("(componentImpl);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
      }
    }
    _builder.newLine();
    {
      final Function1<ComponentPort, String> _function_1 = (ComponentPort it) -> {
        return it.getName();
      };
      List<ComponentPort> _sortBy_1 = IterableExtensions.<ComponentPort, String>sortBy(this._componentGenHelpers.getAllServerPorts(component), _function_1);
      for(final ComponentPort port_1 : _sortBy_1) {
        String _portDefinition_1 = this._componentGenHelpers.getPortDefinition(port_1);
        _builder.append(_portDefinition_1);
        _builder.append(" * ");
        String _name_10 = component.getName();
        _builder.append(_name_10);
        _builder.append("AcePortFactory::create");
        String _nameClass_3 = this._componentGenHelpers.nameClass(port_1);
        _builder.append(_nameClass_3);
        _builder.append("(const std::string &serviceName");
        {
          boolean _isEventServer = this._componentGenHelpers.isEventServer(port_1);
          if (_isEventServer) {
            _builder.append(", std::shared_ptr<Smart::IEventTestHandler<");
            CharSequence _commObjectCppList = this._componentGenHelpers.getCommObjectCppList(port_1, Boolean.valueOf(true));
            _builder.append(_commObjectCppList);
            _builder.append(">> ");
            String _nameInstance = this._componentGenHelpers.nameInstance(port_1);
            _builder.append(_nameInstance);
            _builder.append("EventTestHandler");
          }
        }
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return new ");
        String _portImplementation_1 = this._componentGenHelpers.getPortImplementation(port_1);
        _builder.append(_portImplementation_1, "\t");
        _builder.append("(componentImpl, serviceName");
        {
          boolean _isEventServer_1 = this._componentGenHelpers.isEventServer(port_1);
          if (_isEventServer_1) {
            _builder.append(", ");
            String _nameInstance_1 = this._componentGenHelpers.nameInstance(port_1);
            _builder.append(_nameInstance_1, "\t");
            _builder.append("EventTestHandler");
          }
        }
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("SmartACE::SmartComponent* ");
    String _name_11 = component.getName();
    _builder.append(_name_11);
    _builder.append("AcePortFactory::getComponentImpl()");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return componentImpl;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("int ");
    String _name_12 = component.getName();
    _builder.append(_name_12);
    _builder.append("AcePortFactory::onShutdown(const std::chrono::steady_clock::duration &timeoutTime)");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("componentImpl->stopComponentInfrastructure(timeoutTime);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return 0;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void ");
    String _name_13 = component.getName();
    _builder.append(_name_13);
    _builder.append("AcePortFactory::destroy()");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// clean-up component\'s internally used resources (internally used communication middleware) ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("componentImpl->cleanUpComponentResources();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("delete componentImpl;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
