/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component.docu;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BoolValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.FloatingPointValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.IntValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PrimitiveType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.SingleValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.StringValue;
import org.eclipse.smartmdsd.ecore.base.documentation.AbstractDocumentationElement;
import org.eclipse.smartmdsd.ecore.component.componentParameter.AbstractComponentParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.AbstractParameterInstance;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ExtendedParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ExtendedTrigger;
import org.eclipse.smartmdsd.ecore.component.componentParameter.InternalParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterInstance;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterSetInstance;
import org.eclipse.smartmdsd.ecore.component.componentParameter.TriggerInstance;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.docu.HtmlTableHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class ComponentParametersDocu {
  @Inject
  @Extension
  private HtmlTableHelpers _htmlTableHelpers;
  
  public CharSequence getAttributeTableHeader() {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _tableHeaderBegin = this._htmlTableHelpers.getTableHeaderBegin();
    _builder.append(_tableHeaderBegin);
    _builder.newLineIfNotEmpty();
    CharSequence _asTableHeaderCell = this._htmlTableHelpers.getAsTableHeaderCell("Attribute Name");
    _builder.append(_asTableHeaderCell);
    _builder.newLineIfNotEmpty();
    CharSequence _asTableHeaderCell_1 = this._htmlTableHelpers.getAsTableHeaderCell("Attribute Type");
    _builder.append(_asTableHeaderCell_1);
    _builder.newLineIfNotEmpty();
    CharSequence _asTableHeaderCell_2 = this._htmlTableHelpers.getAsTableHeaderCell("Attribute Value");
    _builder.append(_asTableHeaderCell_2);
    _builder.newLineIfNotEmpty();
    CharSequence _asTableHeaderCell_3 = this._htmlTableHelpers.getAsTableHeaderCell("Attribute Description");
    _builder.append(_asTableHeaderCell_3);
    _builder.newLineIfNotEmpty();
    CharSequence _tableHeaderEnd = this._htmlTableHelpers.getTableHeaderEnd();
    _builder.append(_tableHeaderEnd);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public String getTypeName(final AbstractAttributeType type) {
    String _switchResult = null;
    boolean _matched = false;
    if (type instanceof PrimitiveType) {
      _matched=true;
      _switchResult = ((PrimitiveType)type).getTypeName().getLiteral();
    }
    if (!_matched) {
      if (type instanceof InlineEnumerationType) {
        _matched=true;
        _switchResult = "InlineEnumeration";
      }
    }
    return _switchResult;
  }
  
  public String getValueString(final AbstractValue av) {
    String _switchResult = null;
    boolean _matched = false;
    if (av instanceof IntValue) {
      _matched=true;
      _switchResult = Integer.valueOf(((IntValue)av).getValue()).toString();
    }
    if (!_matched) {
      if (av instanceof FloatingPointValue) {
        _matched=true;
        _switchResult = Double.valueOf(((FloatingPointValue)av).getValue()).toString();
      }
    }
    if (!_matched) {
      if (av instanceof StringValue) {
        _matched=true;
        String _value = ((StringValue)av).getValue();
        String _plus = ("\"" + _value);
        _switchResult = (_plus + "\"");
      }
    }
    if (!_matched) {
      if (av instanceof BoolValue) {
        _matched=true;
        _switchResult = Boolean.valueOf(((BoolValue)av).isValue()).toString();
      }
    }
    if (!_matched) {
      if (av instanceof EnumerationValue) {
        _matched=true;
        _switchResult = ((EnumerationValue)av).getValue().getName();
      }
    }
    if (!_matched) {
      if (av instanceof ArrayValue) {
        _matched=true;
        EList<SingleValue> _values = ((ArrayValue)av).getValues();
        List<String> _map = null;
        if (_values!=null) {
          final Function1<SingleValue, String> _function = (SingleValue it) -> {
            return this.getValueString(it);
          };
          _map=ListExtensions.<SingleValue, String>map(_values, _function);
        }
        String _join = IterableExtensions.join(_map, ", ");
        String _plus = ("[" + _join);
        _switchResult = (_plus + "]");
      }
    }
    if (!_matched) {
      _switchResult = "";
    }
    return _switchResult;
  }
  
  protected CharSequence _getTableRow(final AttributeDefinition attr) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<tr>");
    _builder.newLine();
    String _name = attr.getName();
    String _plus = ("<b>" + _name);
    CharSequence _asTableCell = this._htmlTableHelpers.getAsTableCell((_plus + "</b>"));
    _builder.append(_asTableCell);
    _builder.newLineIfNotEmpty();
    CharSequence _asTableCell_1 = this._htmlTableHelpers.getAsTableCell(this.getTypeName(attr.getType()));
    _builder.append(_asTableCell_1);
    _builder.newLineIfNotEmpty();
    CharSequence _asTableCell_2 = this._htmlTableHelpers.getAsTableCell(this.getValueString(attr.getDefaultvalue()));
    _builder.append(_asTableCell_2);
    _builder.newLineIfNotEmpty();
    CharSequence _asTableCell_3 = this._htmlTableHelpers.getAsTableCell(attr.getMultilineHtmlDocumentation());
    _builder.append(_asTableCell_3);
    _builder.newLineIfNotEmpty();
    _builder.append("</tr>");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _getTableRow(final AttributeRefinement ref) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("<tr>");
    _builder.newLine();
    String _name = ref.getAttribute().getName();
    String _plus = ("<b>" + _name);
    CharSequence _asTableCell = this._htmlTableHelpers.getAsTableCell((_plus + "</b>"));
    _builder.append(_asTableCell);
    _builder.newLineIfNotEmpty();
    CharSequence _asTableCell_1 = this._htmlTableHelpers.getAsTableCell(this.getTypeName(ref.getAttribute().getType()));
    _builder.append(_asTableCell_1);
    _builder.newLineIfNotEmpty();
    CharSequence _asTableCell_2 = this._htmlTableHelpers.getAsTableCell(this.getValueString(ref.getValue()));
    _builder.append(_asTableCell_2);
    _builder.newLineIfNotEmpty();
    CharSequence _asTableCell_3 = this._htmlTableHelpers.getAsTableCell(ref.getMultilineHtmlDocumentation());
    _builder.append(_asTableCell_3);
    _builder.newLineIfNotEmpty();
    _builder.append("</tr>");
    _builder.newLine();
    return _builder;
  }
  
  public CharSequence compileComponentParameters(final ComponentParameter parameter) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("## Component Parameters: ");
    String _name = parameter.getName();
    _builder.append(_name);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      EList<AbstractComponentParameter> _parameters = parameter.getParameters();
      for(final AbstractComponentParameter param : _parameters) {
        {
          if ((param instanceof InternalParameter)) {
            _builder.append("### Internal Parameter: ");
            String _name_1 = ((InternalParameter)param).getName();
            _builder.append(_name_1);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("*Documentation:*");
            _builder.newLine();
            String _multilineHtmlDocumentation = ((InternalParameter)param).getMultilineHtmlDocumentation();
            _builder.append(_multilineHtmlDocumentation);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            CharSequence _tableBegin = this._htmlTableHelpers.getTableBegin();
            _builder.append(_tableBegin);
            _builder.newLineIfNotEmpty();
            String _name_2 = ((InternalParameter)param).getName();
            String _plus = ("Internal Parameter <b>" + _name_2);
            String _plus_1 = (_plus + "</b>");
            CharSequence _asTableCaption = this._htmlTableHelpers.getAsTableCaption(_plus_1);
            _builder.append(_asTableCaption);
            _builder.newLineIfNotEmpty();
            CharSequence _attributeTableHeader = this.getAttributeTableHeader();
            _builder.append(_attributeTableHeader);
            _builder.newLineIfNotEmpty();
            {
              EList<AttributeDefinition> _attributes = ((InternalParameter)param).getAttributes();
              for(final AttributeDefinition attr : _attributes) {
                CharSequence _tableRow = this.getTableRow(attr);
                _builder.append(_tableRow);
                _builder.newLineIfNotEmpty();
              }
            }
            CharSequence _tableEnd = this._htmlTableHelpers.getTableEnd();
            _builder.append(_tableEnd);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
          } else {
            if ((param instanceof ExtendedParameter)) {
              _builder.append("### Extended Parameter: ");
              String _name_3 = ((ExtendedParameter)param).getName();
              _builder.append(_name_3);
              _builder.newLineIfNotEmpty();
              _builder.newLine();
              _builder.append("*Documentation:*");
              _builder.newLine();
              String _multilineHtmlDocumentation_1 = ((ExtendedParameter)param).getMultilineHtmlDocumentation();
              _builder.append(_multilineHtmlDocumentation_1);
              _builder.newLineIfNotEmpty();
              _builder.newLine();
              CharSequence _tableBegin_1 = this._htmlTableHelpers.getTableBegin();
              _builder.append(_tableBegin_1);
              _builder.newLineIfNotEmpty();
              String _name_4 = ((ExtendedParameter)param).getName();
              String _plus_2 = ("Extended Parameter <b>" + _name_4);
              String _plus_3 = (_plus_2 + "</b>");
              CharSequence _asTableCaption_1 = this._htmlTableHelpers.getAsTableCaption(_plus_3);
              _builder.append(_asTableCaption_1);
              _builder.newLineIfNotEmpty();
              CharSequence _attributeTableHeader_1 = this.getAttributeTableHeader();
              _builder.append(_attributeTableHeader_1);
              _builder.newLineIfNotEmpty();
              {
                EList<AttributeDefinition> _attributes_1 = ((ExtendedParameter)param).getAttributes();
                for(final AttributeDefinition attr_1 : _attributes_1) {
                  CharSequence _tableRow_1 = this.getTableRow(attr_1);
                  _builder.append(_tableRow_1);
                  _builder.newLineIfNotEmpty();
                }
              }
              CharSequence _tableEnd_1 = this._htmlTableHelpers.getTableEnd();
              _builder.append(_tableEnd_1);
              _builder.newLineIfNotEmpty();
              _builder.newLine();
            } else {
              if ((param instanceof ExtendedTrigger)) {
                _builder.append("### Extended Trigger: ");
                String _name_5 = ((ExtendedTrigger)param).getName();
                _builder.append(_name_5);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append("*Property:* active = **");
                boolean _isActive = ((ExtendedTrigger)param).isActive();
                _builder.append(_isActive);
                _builder.append("**");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append("*Documentation:*");
                _builder.newLine();
                String _multilineHtmlDocumentation_2 = ((ExtendedTrigger)param).getMultilineHtmlDocumentation();
                _builder.append(_multilineHtmlDocumentation_2);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                CharSequence _tableBegin_2 = this._htmlTableHelpers.getTableBegin();
                _builder.append(_tableBegin_2);
                _builder.newLineIfNotEmpty();
                String _name_6 = ((ExtendedTrigger)param).getName();
                String _plus_4 = ("Attributes of Extended Trigger <b>" + _name_6);
                String _plus_5 = (_plus_4 + "</b>");
                CharSequence _asTableCaption_2 = this._htmlTableHelpers.getAsTableCaption(_plus_5);
                _builder.append(_asTableCaption_2);
                _builder.newLineIfNotEmpty();
                CharSequence _attributeTableHeader_2 = this.getAttributeTableHeader();
                _builder.append(_attributeTableHeader_2);
                _builder.newLineIfNotEmpty();
                {
                  EList<AttributeDefinition> _attributes_2 = ((ExtendedTrigger)param).getAttributes();
                  for(final AttributeDefinition attr_2 : _attributes_2) {
                    CharSequence _tableRow_2 = this.getTableRow(attr_2);
                    _builder.append(_tableRow_2);
                    _builder.newLineIfNotEmpty();
                  }
                }
                CharSequence _tableEnd_2 = this._htmlTableHelpers.getTableEnd();
                _builder.append(_tableEnd_2);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
              } else {
                if ((param instanceof ParameterSetInstance)) {
                  _builder.append("### ParameterSetInstance: ");
                  String _name_7 = ((ParameterSetInstance)param).getName();
                  _builder.append(_name_7);
                  _builder.newLineIfNotEmpty();
                  _builder.newLine();
                  {
                    EList<AbstractParameterInstance> _parameterInstances = ((ParameterSetInstance)param).getParameterInstances();
                    for(final AbstractParameterInstance instance : _parameterInstances) {
                      {
                        if ((instance instanceof ParameterInstance)) {
                          _builder.append("#### Parameter Instance: ");
                          String _name_8 = ((ParameterInstance)instance).getName();
                          _builder.append(_name_8);
                          _builder.newLineIfNotEmpty();
                          _builder.newLine();
                          _builder.append("*Documentation:*");
                          _builder.newLine();
                          String _multilineHtmlDocumentation_3 = ((ParameterInstance)instance).getMultilineHtmlDocumentation();
                          _builder.append(_multilineHtmlDocumentation_3);
                          _builder.newLineIfNotEmpty();
                          _builder.newLine();
                          CharSequence _tableBegin_3 = this._htmlTableHelpers.getTableBegin();
                          _builder.append(_tableBegin_3);
                          _builder.newLineIfNotEmpty();
                          String _name_9 = ((ParameterInstance)instance).getName();
                          String _plus_6 = ("Parameter-Instance <b>" + _name_9);
                          String _plus_7 = (_plus_6 + "</b>");
                          CharSequence _asTableCaption_3 = this._htmlTableHelpers.getAsTableCaption(_plus_7);
                          _builder.append(_asTableCaption_3);
                          _builder.newLineIfNotEmpty();
                          CharSequence _attributeTableHeader_3 = this.getAttributeTableHeader();
                          _builder.append(_attributeTableHeader_3);
                          _builder.newLineIfNotEmpty();
                          {
                            EList<AttributeRefinement> _attributes_3 = ((ParameterInstance)instance).getAttributes();
                            for(final AttributeRefinement attr_3 : _attributes_3) {
                              CharSequence _tableRow_3 = this.getTableRow(attr_3);
                              _builder.append(_tableRow_3);
                              _builder.newLineIfNotEmpty();
                            }
                          }
                          CharSequence _tableEnd_3 = this._htmlTableHelpers.getTableEnd();
                          _builder.append(_tableEnd_3);
                          _builder.newLineIfNotEmpty();
                          _builder.newLine();
                        } else {
                          if ((instance instanceof TriggerInstance)) {
                            _builder.append("#### Trigger Instance: ");
                            String _name_10 = ((TriggerInstance)instance).getTriggerDef().getName();
                            _builder.append(_name_10);
                            _builder.newLineIfNotEmpty();
                            _builder.newLine();
                            _builder.append("*Property:* active = **");
                            boolean _isActive_1 = ((TriggerInstance)instance).isActive();
                            _builder.append(_isActive_1);
                            _builder.append("**");
                            _builder.newLineIfNotEmpty();
                            _builder.newLine();
                            _builder.append("*Documentation:*");
                            _builder.newLine();
                            String _multilineHtmlDocumentation_4 = ((TriggerInstance)instance).getMultilineHtmlDocumentation();
                            _builder.append(_multilineHtmlDocumentation_4);
                            _builder.newLineIfNotEmpty();
                            _builder.newLine();
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    return _builder;
  }
  
  public CharSequence getTableRow(final AbstractDocumentationElement attr) {
    if (attr instanceof AttributeDefinition) {
      return _getTableRow((AttributeDefinition)attr);
    } else if (attr instanceof AttributeRefinement) {
      return _getTableRow((AttributeRefinement)attr);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(attr).toString());
    }
  }
}
