/**
 * Copyright (c) 2013 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.component.params;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.ArrayValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BoolValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.EnumerationValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.FloatingPointValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.IntValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PRIMITIVE_TYPE_NAME;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.PrimitiveType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.SingleValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.StringValue;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ExtendedParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ExtendedTrigger;
import org.eclipse.smartmdsd.ecore.component.componentParameter.InternalParameter;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.AbstractParameter;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.basicAttributes.BasicAttributesGenHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ComponentParamsGenHelpers extends BasicAttributesGenHelpers {
  @Override
  public String compileAttributeParentTypeName(final AttributeDefinition attr) {
    String _xblockexpression = null;
    {
      final EObject parent = attr.eContainer();
      String _switchResult = null;
      boolean _matched = false;
      if (parent instanceof AbstractParameter) {
        _matched=true;
        _switchResult = ((AbstractParameter)parent).getName();
      }
      if (!_matched) {
        if (parent instanceof InternalParameter) {
          _matched=true;
          _switchResult = ((InternalParameter)parent).getName();
        }
      }
      if (!_matched) {
        if (parent instanceof ExtendedParameter) {
          _matched=true;
          _switchResult = ((ExtendedParameter)parent).getName();
        }
      }
      if (!_matched) {
        if (parent instanceof ExtendedTrigger) {
          _matched=true;
          _switchResult = ((ExtendedTrigger)parent).getName();
        }
      }
      if (!_matched) {
        _switchResult = "";
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
  
  public String getInternalNameValues(final EList<AttributeRefinement> dvs, final boolean isConst) {
    String result = "";
    for (final AttributeRefinement dv : dvs) {
      {
        if (isConst) {
          String _compileCppType = this.compileCppType(dv.getAttribute());
          String _plus = ((result + "const ") + _compileCppType);
          String _plus_1 = (_plus + " &");
          String _name = dv.getAttribute().getName();
          String _plus_2 = (_plus_1 + _name);
          result = _plus_2;
        } else {
          String _compileCppType_1 = this.compileCppType(dv.getAttribute());
          String _plus_3 = (result + _compileCppType_1);
          String _plus_4 = (_plus_3 + " &");
          String _name_1 = dv.getAttribute().getName();
          String _plus_5 = (_plus_4 + _name_1);
          result = _plus_5;
        }
        AttributeRefinement _last = IterableExtensions.<AttributeRefinement>last(dvs);
        boolean _notEquals = (!Objects.equal(dv, _last));
        if (_notEquals) {
          result = (result + ", ");
        }
      }
    }
    return result;
  }
  
  public String getNameTypes(final EList<AttributeDefinition> attrs, final boolean isConst) {
    String result = "";
    for (final AttributeDefinition attr : attrs) {
      {
        if (isConst) {
          String _compileCppType = this.compileCppType(attr);
          String _plus = ((result + "const ") + _compileCppType);
          String _plus_1 = (_plus + " &");
          String _name = attr.getName();
          String _plus_2 = (_plus_1 + _name);
          result = _plus_2;
        } else {
          String _compileCppType_1 = this.compileCppType(attr);
          String _plus_3 = (result + _compileCppType_1);
          String _plus_4 = (_plus_3 + " &");
          String _name_1 = attr.getName();
          String _plus_5 = (_plus_4 + _name_1);
          result = _plus_5;
        }
        AttributeDefinition _last = IterableExtensions.<AttributeDefinition>last(attrs);
        boolean _notEquals = (!Objects.equal(attr, _last));
        if (_notEquals) {
          result = (result + ", ");
        }
      }
    }
    return result;
  }
  
  public String getNames(final EList<AttributeRefinement> dvs) {
    String result = "";
    for (final AttributeRefinement dv : dvs) {
      {
        String _name = dv.getAttribute().getName();
        String _plus = (result + _name);
        result = _plus;
        AttributeRefinement _last = IterableExtensions.<AttributeRefinement>last(dvs);
        boolean _notEquals = (!Objects.equal(dv, _last));
        if (_notEquals) {
          result = (result + ", ");
        }
      }
    }
    return result;
  }
  
  public String getNtNames(final EList<AttributeDefinition> attrs) {
    String result = "";
    for (final AttributeDefinition attr : attrs) {
      {
        String _name = attr.getName();
        String _plus = (result + _name);
        result = _plus;
        AttributeDefinition _last = IterableExtensions.<AttributeDefinition>last(attrs);
        boolean _notEquals = (!Objects.equal(attr, _last));
        if (_notEquals) {
          result = (result + ", ");
        }
      }
    }
    return result;
  }
  
  public String compileParamHandlerCppType(final AbstractAttributeType type) {
    if ((type instanceof InlineEnumerationType)) {
      return "std::string";
    } else {
      return this.compileCppType(type);
    }
  }
  
  public String compileCommObjType(final AttributeDefinition attr) {
    String _xblockexpression = null;
    {
      final AbstractAttributeType type = attr.getType();
      String _switchResult = null;
      boolean _matched = false;
      if (type instanceof PrimitiveType) {
        PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)type).getTypeName();
        boolean _lessEqualsThan = (_typeName.compareTo(PRIMITIVE_TYPE_NAME.INT64) <= 0);
        if (_lessEqualsThan) {
          _matched=true;
          _switchResult = "Integer";
        }
      }
      if (!_matched) {
        if (type instanceof PrimitiveType) {
          PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)type).getTypeName();
          boolean _lessEqualsThan = (_typeName.compareTo(PRIMITIVE_TYPE_NAME.DOUBLE) <= 0);
          if (_lessEqualsThan) {
            _matched=true;
            _switchResult = "Double";
          }
        }
      }
      if (!_matched) {
        if (type instanceof PrimitiveType) {
          PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)type).getTypeName();
          boolean _equals = Objects.equal(_typeName, PRIMITIVE_TYPE_NAME.STRING);
          if (_equals) {
            _matched=true;
            _switchResult = "String";
          }
        }
      }
      if (!_matched) {
        if (type instanceof PrimitiveType) {
          PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)type).getTypeName();
          boolean _equals = Objects.equal(_typeName, PRIMITIVE_TYPE_NAME.BOOLEAN);
          if (_equals) {
            _matched=true;
            _switchResult = "Boolean";
          }
        }
      }
      if (!_matched) {
        if (type instanceof InlineEnumerationType) {
          _matched=true;
          _switchResult = "String";
        }
      }
      if (!_matched) {
        _switchResult = "String";
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
  
  public String compileContent(final AbstractValue v) {
    String result = "";
    boolean _matched = false;
    if (v instanceof IntValue) {
      _matched=true;
      result = Integer.valueOf(((IntValue)v).getValue()).toString();
    }
    if (!_matched) {
      if (v instanceof FloatingPointValue) {
        _matched=true;
        result = Double.valueOf(((FloatingPointValue)v).getValue()).toString();
      }
    }
    if (!_matched) {
      if (v instanceof BoolValue) {
        _matched=true;
        result = Boolean.valueOf(((BoolValue)v).isValue()).toString();
      }
    }
    if (!_matched) {
      if (v instanceof StringValue) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\"");
        String _value = ((StringValue)v).getValue();
        _builder.append(_value);
        _builder.append("\"");
        result = _builder.toString();
      }
    }
    if (!_matched) {
      if (v instanceof EnumerationValue) {
        _matched=true;
        EObject parent = ((EnumerationValue)v).eContainer();
        if ((parent instanceof AttributeDefinition)) {
          String _compileCppType = this.compileCppType(((AttributeDefinition)parent));
          String _plus = (_compileCppType + "::");
          String _name = ((EnumerationValue)v).getValue().getName();
          String _plus_1 = (_plus + _name);
          result = _plus_1;
        } else {
          if ((parent instanceof AttributeRefinement)) {
            String _compileCppType_1 = this.compileCppType(((AttributeRefinement)parent).getAttribute());
            String _plus_2 = (_compileCppType_1 + "::");
            String _name_1 = ((EnumerationValue)v).getValue().getName();
            String _plus_3 = (_plus_2 + _name_1);
            result = _plus_3;
          }
        }
      }
    }
    if (!_matched) {
      if (v instanceof ArrayValue) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#warning \"array values are not implemented\"");
        result = _builder.toString();
      }
    }
    return result;
  }
  
  public String getStandardValue(final AttributeDefinition attr) {
    ArrayType _array = attr.getType().getArray();
    boolean _tripleNotEquals = (_array != null);
    if (_tripleNotEquals) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("std::list<");
      String _compileCppType = this.compileCppType(attr);
      _builder.append(_compileCppType);
      _builder.append(">()");
      return _builder.toString();
    } else {
      final AbstractAttributeType type = attr.getType();
      boolean _matched = false;
      if (type instanceof PrimitiveType) {
        PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)type).getTypeName();
        boolean _lessEqualsThan = (_typeName.compareTo(PRIMITIVE_TYPE_NAME.INT64) <= 0);
        if (_lessEqualsThan) {
          _matched=true;
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("0");
          return _builder_1.toString();
        }
      }
      if (!_matched) {
        if (type instanceof PrimitiveType) {
          PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)type).getTypeName();
          boolean _lessEqualsThan = (_typeName.compareTo(PRIMITIVE_TYPE_NAME.DOUBLE) <= 0);
          if (_lessEqualsThan) {
            _matched=true;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("0.0");
            return _builder_1.toString();
          }
        }
      }
      if (!_matched) {
        if (type instanceof PrimitiveType) {
          PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)type).getTypeName();
          boolean _equals = Objects.equal(_typeName, PRIMITIVE_TYPE_NAME.BOOLEAN);
          if (_equals) {
            _matched=true;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("false");
            return _builder_1.toString();
          }
        }
      }
      if (!_matched) {
        if (type instanceof InlineEnumerationType) {
          _matched=true;
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("\"\"");
          return _builder_1.toString();
        }
      }
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("\"\"");
      return _builder_1.toString();
    }
  }
  
  public Object getValue(final SingleValue v) {
    Object _switchResult = null;
    boolean _matched = false;
    if (v instanceof IntValue) {
      _matched=true;
      _switchResult = Integer.valueOf(((IntValue)v).getValue());
    }
    if (!_matched) {
      if (v instanceof FloatingPointValue) {
        _matched=true;
        _switchResult = Double.valueOf(((FloatingPointValue)v).getValue());
      }
    }
    if (!_matched) {
      if (v instanceof BoolValue) {
        _matched=true;
        _switchResult = Boolean.valueOf(((BoolValue)v).isValue());
      }
    }
    if (!_matched) {
      if (v instanceof StringValue) {
        _matched=true;
        _switchResult = ((StringValue)v).getValue();
      }
    }
    if (!_matched) {
      if (v instanceof EnumerationValue) {
        _matched=true;
        _switchResult = ((EnumerationValue)v).getValue().getName();
      }
    }
    return _switchResult;
  }
  
  public CharSequence getDefaultValue(final AbstractAttributeType type) {
    CharSequence _switchResult = null;
    boolean _matched = false;
    if (type instanceof PrimitiveType) {
      PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)type).getTypeName();
      boolean _lessEqualsThan = (_typeName.compareTo(PRIMITIVE_TYPE_NAME.INT64) <= 0);
      if (_lessEqualsThan) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("0");
        _switchResult = _builder;
      }
    }
    if (!_matched) {
      if (type instanceof PrimitiveType) {
        PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)type).getTypeName();
        boolean _lessEqualsThan = (_typeName.compareTo(PRIMITIVE_TYPE_NAME.DOUBLE) <= 0);
        if (_lessEqualsThan) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("0.0");
          _switchResult = _builder;
        }
      }
    }
    if (!_matched) {
      if (type instanceof PrimitiveType) {
        PRIMITIVE_TYPE_NAME _typeName = ((PrimitiveType)type).getTypeName();
        boolean _equals = Objects.equal(_typeName, PRIMITIVE_TYPE_NAME.BOOLEAN);
        if (_equals) {
          _matched=true;
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("false");
          _switchResult = _builder;
        }
      }
    }
    if (!_matched) {
      if (type instanceof InlineEnumerationType) {
        _matched=true;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("ENUM_VALUE_UNDEFINED");
        _switchResult = _builder;
      }
    }
    if (!_matched) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("# empty string");
      _switchResult = _builder;
    }
    return _switchResult;
  }
}
