/**
 * Copyright (c) 2018 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Matthias Lutz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.system.params;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterBase;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParametersRef;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ExtendedParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.InternalParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterInstance;
import org.eclipse.smartmdsd.ecore.system.componentArchitecture.ComponentInstance;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ComponentParameterInstance;
import org.eclipse.smartmdsd.ecore.system.systemParameter.ParameterRefinement;
import org.eclipse.smartmdsd.ecore.system.systemParameter.SystemParamModel;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.ExtendedOutputConfigurationProvider;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.component.params.SmartComponentParameter;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@SuppressWarnings("all")
public class SystemParameterGenerator2Impl extends AbstractGenerator {
  @Inject
  @Extension
  private SmartComponentParameter _smartComponentParameter;
  
  @Override
  public void doGenerate(final Resource resource, final IFileSystemAccess2 fsa, final IGeneratorContext context) {
    Iterable<SystemParamModel> _filter = Iterables.<SystemParamModel>filter(IteratorExtensions.<EObject>toIterable(resource.getAllContents()), SystemParamModel.class);
    for (final SystemParamModel model : _filter) {
      EList<ComponentInstance> _components = model.getSystem().getComponents();
      for (final ComponentInstance instance : _components) {
        {
          final Function1<ComponentParameterInstance, Boolean> _function = (ComponentParameterInstance it) -> {
            ComponentInstance _componentInstance = it.getComponentInstance();
            return Boolean.valueOf(Objects.equal(_componentInstance, instance));
          };
          final ComponentParameterInstance systemParam = IterableExtensions.<ComponentParameterInstance>findFirst(model.getComponents(), _function);
          if ((systemParam != null)) {
            String _name = systemParam.getName();
            String _plus = (_name + ".ini");
            fsa.generateFile(_plus, 
              ExtendedOutputConfigurationProvider.SRC_GEN_PARAMS, 
              this.compile(systemParam));
          } else {
            final ComponentParametersRef componentParams = IterableExtensions.<ComponentParametersRef>head(Iterables.<ComponentParametersRef>filter(instance.getComponent().getElements(), ComponentParametersRef.class));
            if ((componentParams != null)) {
              String _name_1 = instance.getName();
              String _plus_1 = (_name_1 + ".ini");
              fsa.generateFile(_plus_1, 
                ExtendedOutputConfigurationProvider.SRC_GEN_PARAMS, 
                this._smartComponentParameter.compileIniFile(componentParams.getParameter()));
            }
          }
        }
      }
    }
  }
  
  public CharSequence compile(final ComponentParameterInstance parameterInstance) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("##########################");
    _builder.newLine();
    _builder.append("## component parameters ##");
    _builder.newLine();
    _builder.append("##########################");
    _builder.newLine();
    _builder.newLine();
    {
      Iterable<ComponentParameterBase> _filter = Iterables.<ComponentParameterBase>filter(IteratorExtensions.<EObject>toIterable(parameterInstance.getComponentParam().eAllContents()), ComponentParameterBase.class);
      for(final ComponentParameterBase parameter : _filter) {
        {
          final Function1<ParameterRefinement, Boolean> _function = (ParameterRefinement it) -> {
            ComponentParameterBase _parameter = it.getParameter();
            return Boolean.valueOf(Objects.equal(_parameter, parameter));
          };
          boolean _exists = IterableExtensions.<ParameterRefinement>exists(parameterInstance.getParameters(), _function);
          if (_exists) {
            final Function1<ParameterRefinement, Boolean> _function_1 = (ParameterRefinement it) -> {
              ComponentParameterBase _parameter = it.getParameter();
              return Boolean.valueOf(Objects.equal(_parameter, parameter));
            };
            CharSequence _compileParameterRefinement = this.compileParameterRefinement(IterableExtensions.<ParameterRefinement>findFirst(parameterInstance.getParameters(), _function_1));
            _builder.append(_compileParameterRefinement);
            _builder.newLineIfNotEmpty();
          } else {
            CharSequence _compileIniFileParameter = this._smartComponentParameter.compileIniFileParameter(parameter);
            _builder.append(_compileIniFileParameter);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
  
  public CharSequence compileParameterRefinement(final ParameterRefinement refinement) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("######################################");
    _builder.newLine();
    _builder.append("## parameter refinement ");
    String _name = this.getName(refinement);
    _builder.append(_name);
    _builder.newLineIfNotEmpty();
    _builder.append("[");
    String _name_1 = this.getName(refinement);
    _builder.append(_name_1);
    _builder.append("]");
    _builder.newLineIfNotEmpty();
    final ComponentParameterBase parameter = refinement.getParameter();
    _builder.newLineIfNotEmpty();
    {
      if ((parameter instanceof ParameterInstance)) {
        {
          EList<AttributeRefinement> _attributes = ((ParameterInstance)parameter).getAttributes();
          for(final AttributeRefinement attr : _attributes) {
            {
              final Function1<AttributeRefinement, Boolean> _function = (AttributeRefinement it) -> {
                String _name_2 = it.getAttribute().getName();
                String _name_3 = attr.getAttribute().getName();
                return Boolean.valueOf(Objects.equal(_name_2, _name_3));
              };
              boolean _exists = IterableExtensions.<AttributeRefinement>exists(refinement.getAttributes(), _function);
              if (_exists) {
                final Function1<AttributeRefinement, Boolean> _function_1 = (AttributeRefinement it) -> {
                  String _name_2 = it.getAttribute().getName();
                  String _name_3 = attr.getAttribute().getName();
                  return Boolean.valueOf(Objects.equal(_name_2, _name_3));
                };
                CharSequence _compileIniAttribute = this._smartComponentParameter.compileIniAttribute(IterableExtensions.<AttributeRefinement>findFirst(refinement.getAttributes(), _function_1));
                _builder.append(_compileIniAttribute);
                _builder.newLineIfNotEmpty();
              } else {
                CharSequence _compileIniAttribute_1 = this._smartComponentParameter.compileIniAttribute(attr);
                _builder.append(_compileIniAttribute_1);
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
      } else {
        if ((parameter instanceof InternalParameter)) {
          {
            EList<AttributeDefinition> _attributes_1 = ((InternalParameter)parameter).getAttributes();
            for(final AttributeDefinition attr_1 : _attributes_1) {
              {
                final Function1<AttributeRefinement, Boolean> _function_2 = (AttributeRefinement it) -> {
                  String _name_2 = it.getAttribute().getName();
                  String _name_3 = attr_1.getName();
                  return Boolean.valueOf(Objects.equal(_name_2, _name_3));
                };
                boolean _exists_1 = IterableExtensions.<AttributeRefinement>exists(refinement.getAttributes(), _function_2);
                if (_exists_1) {
                  final Function1<AttributeRefinement, Boolean> _function_3 = (AttributeRefinement it) -> {
                    String _name_2 = it.getAttribute().getName();
                    String _name_3 = attr_1.getName();
                    return Boolean.valueOf(Objects.equal(_name_2, _name_3));
                  };
                  CharSequence _compileIniAttribute_2 = this._smartComponentParameter.compileIniAttribute(IterableExtensions.<AttributeRefinement>findFirst(refinement.getAttributes(), _function_3));
                  _builder.append(_compileIniAttribute_2);
                  _builder.newLineIfNotEmpty();
                } else {
                  CharSequence _compileIniAttribute_3 = this._smartComponentParameter.compileIniAttribute(attr_1);
                  _builder.append(_compileIniAttribute_3);
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        } else {
          if ((parameter instanceof ExtendedParameter)) {
            {
              EList<AttributeDefinition> _attributes_2 = ((ExtendedParameter)parameter).getAttributes();
              for(final AttributeDefinition attr_2 : _attributes_2) {
                {
                  final Function1<AttributeRefinement, Boolean> _function_4 = (AttributeRefinement it) -> {
                    String _name_2 = it.getAttribute().getName();
                    String _name_3 = attr_2.getName();
                    return Boolean.valueOf(Objects.equal(_name_2, _name_3));
                  };
                  boolean _exists_2 = IterableExtensions.<AttributeRefinement>exists(refinement.getAttributes(), _function_4);
                  if (_exists_2) {
                    final Function1<AttributeRefinement, Boolean> _function_5 = (AttributeRefinement it) -> {
                      String _name_2 = it.getAttribute().getName();
                      String _name_3 = attr_2.getName();
                      return Boolean.valueOf(Objects.equal(_name_2, _name_3));
                    };
                    CharSequence _compileIniAttribute_4 = this._smartComponentParameter.compileIniAttribute(IterableExtensions.<AttributeRefinement>findFirst(refinement.getAttributes(), _function_5));
                    _builder.append(_compileIniAttribute_4);
                    _builder.newLineIfNotEmpty();
                  } else {
                    CharSequence _compileIniAttribute_5 = this._smartComponentParameter.compileIniAttribute(attr_2);
                    _builder.append(_compileIniAttribute_5);
                    _builder.newLineIfNotEmpty();
                  }
                }
              }
            }
          }
        }
      }
    }
    return _builder;
  }
  
  private String getName(final ParameterRefinement refinement) {
    String _xblockexpression = null;
    {
      final ComponentParameterBase parameter = refinement.getParameter();
      String _switchResult = null;
      boolean _matched = false;
      if (parameter instanceof ExtendedParameter) {
        _matched=true;
        _switchResult = ((ExtendedParameter)parameter).getName();
      }
      if (!_matched) {
        if (parameter instanceof InternalParameter) {
          _matched=true;
          _switchResult = ((InternalParameter)parameter).getName();
        }
      }
      if (!_matched) {
        if (parameter instanceof ParameterInstance) {
          _matched=true;
          _switchResult = ((ParameterInstance)parameter).getName();
        }
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
}
