/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractAttributeType;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.documentation.AbstractDocumentationElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommElementReference;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.CopyrightHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.CommObjectGenHelpers;
import org.eclipse.smartmdsd.xtend.smartsoft.generator.commObj.DomainModelsGeneratorExtension;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class CommObjectCMakeGenerator {
    @Inject
    @Extension
    private CommObjectGenHelpers _commObjectGenHelpers;
    @Inject
    @Extension
    private CopyrightHelpers _copyrightHelpers;

    public CharSequence generateCmakeProjectFile(CommObjectsRepository repo) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
        _builder.append(_copyrightHash);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("PROJECT(");
        CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace);
        _builder.append(" VERSION ");
        int _major = repo.getVersion().getMajor();
        _builder.append((Object)_major);
        _builder.append(".");
        int _minor = repo.getVersion().getMinor();
        _builder.append((Object)_minor);
        _builder.append(".");
        int _patch = repo.getVersion().getPatch();
        _builder.append((Object)_patch);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateCmakeListsFile(CommObjectsRepository repo) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightWriteOnceHash = this._copyrightHelpers.getCopyrightWriteOnceHash();
        _builder.append(_copyrightWriteOnceHash);
        _builder.newLineIfNotEmpty();
        _builder.append("CMAKE_MINIMUM_REQUIRED(VERSION 3.0)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# find the SmartSoft CMake Macros (version 2 that uses CMake v3)");
        _builder.newLine();
        _builder.append("FIND_FILE(SMART_MACROS SmartMacros2.cmake PATHS $ENV{SMART_ROOT_ACE}/CMakeMacros /opt/smartSoftAce/CMakeMacros)");
        _builder.newLine();
        _builder.append("INCLUDE(${SMART_MACROS})");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# Create and configure a CMake project for a CommunicationObject");
        _builder.newLine();
        _builder.append("SMART_COMMOBJECT_PROJECT()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# automatically build dependencies to other CommunicationObjects (if needed)");
        _builder.newLine();
        _builder.append("SMART_COMMOBJECT_AUTOBUILD_DEPENDENCIES()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#################################################################################");
        _builder.newLine();
        _builder.append("## here you can put all your project-specific compiler configurations          ##");
        _builder.newLine();
        _builder.append("## using regular CMake commands (like FIND_PACKAGE, INCLUDE_DIRECTORIES, etc.) ##");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# you can add additional smartsoft utilities as follows:");
        _builder.newLine();
        _builder.append("#SMART_FIND_PACKAGE(SomePackageName)");
        _builder.newLine();
        _builder.append("#INCLUDE_DIRECTORIES(${SOMEPACKAGENAME_INCLUDE_DIRS})");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# uncomment the following lines to activate data hash calculation (for debugging purposes)");
        _builder.newLine();
        _builder.append("#FIND_PACKAGE(Boost REQUIRED)");
        _builder.newLine();
        _builder.append("#INCLUDE_DIRECTORIES(${Boost_INCLUDE_DIRS})");
        _builder.newLine();
        _builder.append("#SET(CMAKE_CXX_FLAGS \"${CMAKE_CXX_FLAGS} -DENABLE_HASH\")");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# as communication objects are typically shared on various platforms,");
        _builder.newLine();
        _builder.append("# it is recommended to limit the external dependencies here as much as possible");
        _builder.newLine();
        _builder.newLine();
        _builder.append("FILE(GLOB_RECURSE SRC ${CMAKE_CURRENT_LIST_DIR}/src/*.cc)");
        _builder.newLine();
        _builder.append("FILE(GLOB_RECURSE SRC_GEN ${CMAKE_CURRENT_LIST_DIR}/src-gen/*.cc)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("IF(WIN32)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ADD_LIBRARY(${PROJECT_NAME} STATIC ${SRC} ${SRC_GEN})");
        _builder.newLine();
        _builder.append("ELSE()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ADD_LIBRARY(${PROJECT_NAME} SHARED ${SRC} ${SRC_GEN})");
        _builder.newLine();
        _builder.append("ENDIF()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# link your external libraries here");
        _builder.newLine();
        _builder.append("#TARGET_LINK_LIBRARIES(${PROJECT_NAME} <your-libs>)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("## end user-code                                                               ##");
        _builder.newLine();
        _builder.append("#################################################################################");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# automaticall link to all dependent CommunicationObjects");
        _builder.newLine();
        _builder.append("SMART_COMMOBJECT_AUTOLINK_DEPENDENCIES()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# autoinstall all default CommunicationObject artefacts");
        _builder.newLine();
        _builder.append("SMART_COMMOBJECT_AUTOINSTALL()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# include extensions cmake files");
        _builder.newLine();
        _builder.append("INCLUDE(${CMAKE_CURRENT_LIST_DIR}/src-gen/DomainModelsExtensions.cmake)");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateCmakeConfigFile(CommObjectsRepository repo) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
        _builder.append(_copyrightHash);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# each comm-obj depend on the ACE middleware library");
        _builder.newLine();
        _builder.append("FIND_PACKAGE(ACE 6.0.2 PATHS $ENV{SMART_ROOT_ACE}/CMakeMacros /opt/smartSoftAce/CMakeMacros)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("IF(EXISTS ${CMAKE_CURRENT_LIST_DIR}/CMakeCache.txt)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# find the SmartSoft CMake Macros (version 2 that uses CMake v3)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("FIND_FILE(SMART_MACROS SmartMacros2.cmake PATHS $ENV{SMART_ROOT_ACE}/CMakeMacros /opt/smartSoftAce/CMakeMacros)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("INCLUDE(${SMART_MACROS})");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# find and include all external package definitions (if there are any needed)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("FOREACH(DEPENDENCY IN ITEMS @");
        CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace, "\t");
        _builder.append("_DEPENDENCIES@)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("INTERNAL_IMPORT_PACKAGE(${DEPENDENCY})");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ENDFOREACH(DEPENDENCY)");
        _builder.newLine();
        _builder.append("ELSE()");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("# find and include all external package definitions (if there are any needed)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("FOREACH(DEPENDENCY IN ITEMS @");
        CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace_1, "\t");
        _builder.append("_DEPENDENCIES@)");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("FIND_PACKAGE(${DEPENDENCY} PATHS $ENV{SMART_ROOT_ACE}/modules /opt/smartSoftAce/modules)");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ENDFOREACH(DEPENDENCY)");
        _builder.newLine();
        _builder.append("ENDIF()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# include generated target configurations");
        _builder.newLine();
        _builder.append("INCLUDE(${CMAKE_CURRENT_LIST_DIR}/@PROJECT_NAME@Targets.cmake)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# the following variables are depricated and should not be used anymore:");
        _builder.newLine();
        _builder.append("# @PROJECT_NAME@_LIBRARIES");
        _builder.newLine();
        _builder.append("# @PROJECT_NAME@_INCLUDES");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# instead, just directly link the library @PROJECT_NAME@ to your executable target like this:");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# TARGET_LINK_LIBRARIES(YourExecutableTarget @PROJECT_NAME@)");
        _builder.newLine();
        _builder.append("#");
        _builder.newLine();
        _builder.append("# (all the includes and additional libraries are automatically determined from the target @PROJECT_NAME@)");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateCmakeDependenciesFile(CommObjectsRepository repo) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
        _builder.append(_copyrightHash);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# SmartXml is a default dependency of each CommunicationObject");
        _builder.newLine();
        _builder.append("LIST(APPEND ");
        CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace);
        _builder.append("_DEPENDENCIES SmartXml)");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# modelled CommunicationObject-dependencies are added here (if there are any)");
        _builder.newLine();
        Functions.Function1 _function = c -> this._commObjectGenHelpers.getRepoNamespace((EObject)c).toString();
        List _sortBy = IterableExtensions.sortBy(this.getReferencedCommObjects(repo), (Functions.Function1)_function);
        for (CommunicationObject co : _sortBy) {
            _builder.append("LIST(APPEND ");
            CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
            _builder.append((Object)_repoNamespace_1);
            _builder.append("_DEPENDENCIES ");
            String _string = this._commObjectGenHelpers.getRepoNamespace((EObject)co).toString();
            _builder.append(_string);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("# these are the dependencies that have been added manually within the CMakeLists.txt file");
        _builder.newLine();
        _builder.append("# (e.g. added by SMART_ADD_UTILITY)");
        _builder.newLine();
        _builder.append("LIST(APPEND ");
        CharSequence _repoNamespace_2 = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace_2);
        _builder.append("_DEPENDENCIES @");
        CharSequence _repoNamespace_3 = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace_3);
        _builder.append("_LOCAL_DEPENDENCIES@)");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("LIST(REMOVE_DUPLICATES ");
        CharSequence _repoNamespace_4 = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace_4);
        _builder.append("_DEPENDENCIES)");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateProjectSettingsCmake(CommObjectsRepository repo) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
        _builder.append(_copyrightHash);
        _builder.newLineIfNotEmpty();
        _builder.append("FIND_FILE(SMART_MACROS SmartMacros.cmake PATHS $ENV{SMART_ROOT_ACE}/CMakeMacros /opt/smartSoftAce/CMakeMacros)");
        _builder.newLine();
        _builder.append("INCLUDE(${SMART_MACROS})");
        _builder.newLine();
        _builder.newLine();
        _builder.append("SMART_COMMOBJECT_PROJECT(");
        CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("SMART_VERSION(");
        int _major = repo.getVersion().getMajor();
        _builder.append((Object)_major);
        _builder.append(".");
        int _minor = repo.getVersion().getMinor();
        _builder.append((Object)_minor);
        _builder.append(".");
        int _patch = repo.getVersion().getPatch();
        _builder.append((Object)_patch);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("SMART_COMMOBJECT_BUILD_DEBIAN_PACKAGE(${PROJECT_NAME} ${PACKAGE_VERSION_STRING})");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# each comm-obj depend on the ACE middleware library");
        _builder.newLine();
        _builder.append("FIND_PACKAGE(ACE 6.0.2 PATHS $ENV{SMART_ROOT_ACE}/CMakeMacros /opt/smartSoftAce/CMakeMacros)");
        _builder.newLine();
        _builder.append("LIST(APPEND USER_INCLUDES ${ACE_INCLUDE_DIRS})");
        _builder.newLine();
        _builder.append("LIST(APPEND USER_LIBS ${ACE_LIBRARIES})");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# ");
        CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace_1);
        _builder.append(" depends on the SmartXml utility (for xml parsing in comm objects)");
        _builder.newLineIfNotEmpty();
        _builder.append("SMART_FIND_PACKAGE(SmartXml 1.0.0)");
        _builder.newLine();
        _builder.append("LIST(APPEND USER_INCLUDES ${SMARTXML_INCLUDE_DIRS})");
        _builder.newLine();
        _builder.append("LIST(APPEND USER_LIBS ${SMARTXML_LIBRARIES})");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# project specific include directories");
        _builder.newLine();
        _builder.append("LIST(APPEND USER_INCLUDES \"${PROJECT_SOURCE_DIR}/src\")");
        _builder.newLine();
        _builder.append("LIST(APPEND USER_INCLUDES \"${PROJECT_SOURCE_DIR}/src-gen\")");
        _builder.newLine();
        _builder.newLine();
        Functions.Function1 _function = c -> this._commObjectGenHelpers.getRepoNamespace((EObject)c).toString();
        List _sortBy = IterableExtensions.sortBy(this.getReferencedCommObjects(repo), (Functions.Function1)_function);
        for (CommunicationObject co : _sortBy) {
            _builder.newLine();
            _builder.append("# ");
            CharSequence _repoNamespace_2 = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
            _builder.append((Object)_repoNamespace_2);
            _builder.append(" depends on the SmartSoft module ");
            String _string = this._commObjectGenHelpers.getRepoNamespace((EObject)co).toString();
            _builder.append(_string);
            _builder.newLineIfNotEmpty();
            _builder.append("SMART_FIND_PACKAGE(");
            String _string_1 = this._commObjectGenHelpers.getRepoNamespace((EObject)co).toString();
            _builder.append(_string_1);
            _builder.append(" ");
            int _major_1 = this._commObjectGenHelpers.getRepoVersion((AbstractDocumentationElement)co).getMajor();
            _builder.append((Object)_major_1);
            _builder.append(".");
            int _minor_1 = this._commObjectGenHelpers.getRepoVersion((AbstractDocumentationElement)co).getMinor();
            _builder.append((Object)_minor_1);
            _builder.append(".");
            int _patch_1 = this._commObjectGenHelpers.getRepoVersion((AbstractDocumentationElement)co).getPatch();
            _builder.append((Object)_patch_1);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("LIST(APPEND USER_INCLUDES ${");
            String _upperCase = this._commObjectGenHelpers.getRepoNamespace((EObject)co).toString().toUpperCase();
            _builder.append(_upperCase);
            _builder.append("_INCLUDE_DIRS})");
            _builder.newLineIfNotEmpty();
            _builder.append("LIST(APPEND USER_LIBS ${");
            String _upperCase_1 = this._commObjectGenHelpers.getRepoNamespace((EObject)co).toString().toUpperCase();
            _builder.append(_upperCase_1);
            _builder.append("_LIBRARIES})");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateBuildSettingsCmake(CommObjectsRepository repo) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
        _builder.append(_copyrightHash);
        _builder.newLineIfNotEmpty();
        _builder.append("# set-up include directories including all referenced projects");
        _builder.newLine();
        _builder.append("INCLUDE_DIRECTORIES(${USER_INCLUDES})");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# set-up header files and source files to be compiled");
        _builder.newLine();
        _builder.append("FILE(GLOB HDRS src/");
        CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace);
        _builder.append("/*.hh src-gen/");
        CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace_1);
        _builder.append("/*.hh)");
        _builder.newLineIfNotEmpty();
        _builder.append("FILE(GLOB SRCS src/");
        CharSequence _repoNamespace_2 = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace_2);
        _builder.append("/*.cc src-gen/");
        CharSequence _repoNamespace_3 = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace_3);
        _builder.append("/*.cc)");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("SMART_COMMOBJECT_GENERATE_HASH()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("SMART_COMMOBJECT_ADD_LIBRARY(${PROJECT_NAME})");
        _builder.newLine();
        _builder.newLine();
        _builder.append("SMART_COMMOBJECT_INSTALL(${PROJECT_NAME})");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateHashHeaderCmake(CommObjectsRepository repo) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
        _builder.append(_copyrightHash);
        _builder.newLineIfNotEmpty();
        _builder.append("CMAKE_MINIMUM_REQUIRED(VERSION 2.8.7)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("SET(GEN_DIR ${CMAKE_CURRENT_LIST_DIR})");
        _builder.newLine();
        _builder.newLine();
        _builder.append("FILE(GLOB HASH_SRCS ${GEN_DIR}/*.hh ${GEN_DIR}/*.cc ${GEN_DIR}/../../");
        CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace);
        _builder.append("/*.hh ${GEN_DIR}/../../");
        CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace_1);
        _builder.append("/*.cc)");
        _builder.newLineIfNotEmpty();
        _builder.append("LIST(REMOVE_ITEM HASH_SRCS ${GEN_DIR}/hash.hh)");
        _builder.newLine();
        _builder.append("LIST(SORT HASH_SRCS)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("FOREACH(SRC IN LISTS HASH_SRCS)");
        _builder.newLine();
        _builder.append("FILE(READ ${SRC} SRC_BUFFER)");
        _builder.newLine();
        _builder.append("FILE(APPEND HashSource.txt ${SRC_BUFFER})");
        _builder.newLine();
        _builder.append("ENDFOREACH()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("FILE(MD5 HashSource.txt HASH_VALUE)");
        _builder.newLine();
        _builder.append("MESSAGE(\"HASH_VALUE of ");
        CharSequence _repoNamespace_2 = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace_2);
        _builder.append(" is: ${HASH_VALUE}\")");
        _builder.newLineIfNotEmpty();
        _builder.append("FILE(REMOVE HashSource.txt)");
        _builder.newLine();
        _builder.append("CONFIGURE_FILE(${GEN_DIR}/hash.hh.in ${GEN_DIR}/hash.hh @ONLY)");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateCmakeModule(CommObjectsRepository repo) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightWriteOnceHash = this._copyrightHelpers.getCopyrightWriteOnceHash();
        _builder.append(_copyrightWriteOnceHash);
        _builder.newLineIfNotEmpty();
        _builder.append("# get current path");
        _builder.newLine();
        _builder.append("GET_FILENAME_COMPONENT(CURR_DIR \"${CMAKE_CURRENT_LIST_FILE}\" PATH)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("INCLUDE(${CURR_DIR}/");
        CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace);
        _builder.append("ModuleProjectSettings.cmake)");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# add additional \"LIST(APPEND USER_INCLUDES ...)\" and \"LIST(APPEND USER_LIBS ...)\" for custom dependencies");
        _builder.newLine();
        _builder.newLine();
        _builder.append("INCLUDE(${CURR_DIR}/");
        CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace_1);
        _builder.append("ModuleBuildSettings.cmake)");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateModuleProjectSettings(CommObjectsRepository repo) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
        _builder.append(_copyrightHash);
        _builder.newLineIfNotEmpty();
        _builder.append("FIND_FILE(SMART_MACROS SmartMacros.cmake PATHS $ENV{SMART_ROOT_ACE} /opt/smartSoftAce)");
        _builder.newLine();
        _builder.append("INCLUDE(${SMART_MACROS})");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# each comm-obj depend on the ACE middleware library");
        _builder.newLine();
        _builder.append("IF(NOT ACE_FOUND)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("FIND_PACKAGE(ACE 6.0.2 PATHS $ENV{SMART_ROOT_ACE} /opt/smartSoftAce)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("LIST(APPEND ");
        String _upperCase = repo.getName().toUpperCase();
        _builder.append(_upperCase, "  ");
        _builder.append("_INCLUDE_DIRS ${ACE_INCLUDE_DIRS})");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("LIST(APPEND ");
        String _upperCase_1 = repo.getName().toUpperCase();
        _builder.append(_upperCase_1, "  ");
        _builder.append("_LIBRARIES ${ACE_LIBRARIES})");
        _builder.newLineIfNotEmpty();
        _builder.append("ENDIF(NOT ACE_FOUND)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# use the SmartSoft CMake registry to find SmartSoft project dependencies");
        _builder.newLine();
        _builder.append("FIND_FILE(SMART_REGISTRY SmartRegistry.cmake PATHS $ENV{SMART_ROOT_ACE} /opt/smartSoftAce)");
        _builder.newLine();
        _builder.append("INCLUDE(${SMART_REGISTRY})");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# ");
        CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace);
        _builder.append(" depends on the SmartXml utility (for xml parsing in comm objects)");
        _builder.newLineIfNotEmpty();
        _builder.append("SMART_INCLUDE_PACKAGE(SmartXml 1.0.0)");
        _builder.newLine();
        _builder.append("LIST(APPEND ");
        String _upperCase_2 = repo.getName().toUpperCase();
        _builder.append(_upperCase_2);
        _builder.append("_INCLUDE_DIRS ${SMARTXML_INCLUDE_DIRS})");
        _builder.newLineIfNotEmpty();
        _builder.append("LIST(APPEND ");
        String _upperCase_3 = repo.getName().toUpperCase();
        _builder.append(_upperCase_3);
        _builder.append("_LIBRARIES ${SMARTXML_LIBRARIES})\t\t");
        _builder.newLineIfNotEmpty();
        Functions.Function1 _function = c -> this._commObjectGenHelpers.getRepoNamespace((EObject)c).toString();
        List _sortBy = IterableExtensions.sortBy(this.getReferencedCommObjects(repo), (Functions.Function1)_function);
        for (CommunicationObject co : _sortBy) {
            _builder.newLine();
            _builder.append("# ");
            CharSequence _repoNamespace_1 = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
            _builder.append((Object)_repoNamespace_1);
            _builder.append(" depends on the SmartSoft module ");
            String _string = this._commObjectGenHelpers.getRepoNamespace((EObject)co).toString();
            _builder.append(_string);
            _builder.newLineIfNotEmpty();
            _builder.append("SMART_INCLUDE_PACKAGE(");
            String _string_1 = this._commObjectGenHelpers.getRepoNamespace((EObject)co).toString();
            _builder.append(_string_1);
            _builder.append(" ");
            int _major = this._commObjectGenHelpers.getRepoVersion((AbstractDocumentationElement)co).getMajor();
            _builder.append((Object)_major);
            _builder.append(".");
            int _minor = this._commObjectGenHelpers.getRepoVersion((AbstractDocumentationElement)co).getMinor();
            _builder.append((Object)_minor);
            _builder.append(".");
            int _patch = this._commObjectGenHelpers.getRepoVersion((AbstractDocumentationElement)co).getPatch();
            _builder.append((Object)_patch);
            _builder.append(")");
            _builder.newLineIfNotEmpty();
            _builder.append("LIST(APPEND ");
            String _upperCase_4 = repo.getName().toUpperCase();
            _builder.append(_upperCase_4);
            _builder.append("_INCLUDE_DIRS ${");
            String _upperCase_5 = this._commObjectGenHelpers.getRepoNamespace((EObject)co).toString().toUpperCase();
            _builder.append(_upperCase_5);
            _builder.append("_INCLUDE_DIRS})");
            _builder.newLineIfNotEmpty();
            _builder.append("LIST(APPEND ");
            String _upperCase_6 = repo.getName().toUpperCase();
            _builder.append(_upperCase_6);
            _builder.append("_LIBRARIES ${");
            String _upperCase_7 = this._commObjectGenHelpers.getRepoNamespace((EObject)co).toString().toUpperCase();
            _builder.append(_upperCase_7);
            _builder.append("_LIBRARIES})");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateModuleBuildSettings(CommObjectsRepository repo) {
        StringConcatenation _builder = new StringConcatenation();
        String _copyrightHash = this._copyrightHelpers.getCopyrightHash();
        _builder.append(_copyrightHash);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# get crrent path");
        _builder.newLine();
        _builder.append("GET_FILENAME_COMPONENT(CURR_CMAKE_DIR \"${CMAKE_CURRENT_LIST_FILE}\" PATH)");
        _builder.newLine();
        _builder.newLine();
        _builder.append("IF(EXISTS ${CURR_CMAKE_DIR}/CMakeCache.txt)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("# in build tree");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("LIST(APPEND ");
        String _upperCase = repo.getName().toUpperCase();
        _builder.append(_upperCase, "  ");
        _builder.append("_INCLUDE_DIRS @PROJECT_SOURCE_DIR@/src)");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("LIST(APPEND ");
        String _upperCase_1 = repo.getName().toUpperCase();
        _builder.append(_upperCase_1, "  ");
        _builder.append("_INCLUDE_DIRS @PROJECT_SOURCE_DIR@/src-gen)");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("IF(NOT TARGET @PROJECT_NAME@)");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("INCLUDE(\"@PROJECT_BINARY_DIR@/@PROJECT_NAME@Target.cmake\")");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("ENDIF()");
        _builder.newLine();
        _builder.append("ELSE()");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("# installed");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("LIST(APPEND ");
        String _upperCase_2 = repo.getName().toUpperCase();
        _builder.append(_upperCase_2, "  ");
        _builder.append("_INCLUDE_DIRS \"@CMAKE_INSTALL_PREFIX@/include\")");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("  ");
        _builder.append("IF(NOT TARGET @PROJECT_NAME@)");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("IF(EXISTS ${CURR_CMAKE_DIR}/@PROJECT_NAME@Target.cmake) ");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("INCLUDE(\"${CURR_CMAKE_DIR}/@PROJECT_NAME@Target.cmake\")");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("ELSE()");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("MESSAGE(WARNING \"Could not find @PROJECT_NAME@Target.cmake\")");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("ENDIF()");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("ENDIF()");
        _builder.newLine();
        _builder.append("ENDIF()");
        _builder.newLine();
        _builder.newLine();
        _builder.append("# these are the output variables to be used by external packages in their build process");
        _builder.newLine();
        _builder.append("LIST(APPEND ");
        String _upperCase_3 = repo.getName().toUpperCase();
        _builder.append(_upperCase_3);
        _builder.append("_LIBRARIES ");
        CharSequence _repoNamespace = this._commObjectGenHelpers.getRepoNamespace((EObject)repo);
        _builder.append((Object)_repoNamespace);
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("SET(");
        String _upperCase_4 = repo.getName().toUpperCase();
        _builder.append(_upperCase_4);
        _builder.append("_FOUND TRUE)");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("# export to parent scope");
        _builder.newLine();
        _builder.append("LIST(APPEND SMART_EXPORT_VARS ");
        String _upperCase_5 = repo.getName().toUpperCase();
        _builder.append(_upperCase_5);
        _builder.append("_FOUND)");
        _builder.newLineIfNotEmpty();
        _builder.append("LIST(APPEND SMART_EXPORT_VARS ");
        String _upperCase_6 = repo.getName().toUpperCase();
        _builder.append(_upperCase_6);
        _builder.append("_INCLUDE_DIRS)");
        _builder.newLineIfNotEmpty();
        _builder.append("LIST(APPEND SMART_EXPORT_VARS ");
        String _upperCase_7 = repo.getName().toUpperCase();
        _builder.append(_upperCase_7);
        _builder.append("_LIBRARIES)");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateCmakeDomainModelsExtensionsFile(CommObjectsRepository repo) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> it.getExtensionName(repo);
        List _sortBy = IterableExtensions.sortBy(this._commObjectGenHelpers.getDomainModelsGeneratorExtensions(), (Functions.Function1)_function);
        for (DomainModelsGeneratorExtension ext : _sortBy) {
            _builder.append("# ");
            String _extensionName = ext.getExtensionName(repo);
            _builder.append(_extensionName);
            _builder.newLineIfNotEmpty();
            CharSequence _cMakeExtension = ext.getCMakeExtension(repo);
            _builder.append((Object)_cMakeExtension);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    public Collection<CommunicationObject> getReferencedCommObjects(CommObjectsRepository repo) {
        HashSet<CommunicationObject> repoNames = new HashSet<CommunicationObject>();
        EList _elements = repo.getElements();
        for (AbstractCommElement abstrel : _elements) {
            if (!(abstrel instanceof CommunicationObject)) continue;
            EList _attributes = ((CommunicationObject)abstrel).getAttributes();
            for (AttributeDefinition attr : _attributes) {
                String _string_1;
                boolean _notEquals;
                AbstractCommElement id;
                AbstractAttributeType type = attr.getType();
                if (!(type instanceof CommElementReference) || !((id = ((CommElementReference)type).getTypeName()) instanceof CommunicationObject)) continue;
                String _string = this._commObjectGenHelpers.getRepoNamespace((EObject)id).toString();
                boolean bl = _notEquals = !Objects.equal((Object)_string, (Object)(_string_1 = this._commObjectGenHelpers.getRepoNamespace((EObject)repo).toString()));
                if (!_notEquals) continue;
                repoNames.add((CommunicationObject)id);
            }
        }
        return repoNames;
    }
}

