/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.base.basicAttributes.ui.quickfix;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesTypeConformance;
import org.eclipse.smartmdsd.xtext.base.basicAttributes.validation.BasicAttributesValidator;
import org.eclipse.smartmdsd.xtext.base.docuterminals.ui.quickfix.DocuTerminalsQuickfixProvider;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;

/**
 * Custom quickfixes.
 * 
 * See https://www.eclipse.org/Xtext/documentation/310_eclipse_support.html#quick-fixes
 */
@SuppressWarnings("all")
public class BasicAttributesQuickfixProvider extends DocuTerminalsQuickfixProvider {
  @Inject
  private BasicAttributesTypeConformance conf;
  
  @Fix(BasicAttributesValidator.SMALL_ATTR_NAME)
  public void smallCaseName(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final IModification _function = (IModificationContext context) -> {
      final IXtextDocument xtextDocument = context.getXtextDocument();
      final String firstLetter = xtextDocument.get((issue.getOffset()).intValue(), 1);
      xtextDocument.replace((issue.getOffset()).intValue(), 1, firstLetter.toLowerCase());
    };
    acceptor.accept(issue, "Small-case name", "Small-case the name.", "", _function);
  }
  
  @Fix(BasicAttributesValidator.INCOMPATIBLE_TYPES)
  public void createTypedDefaultValue(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      final AttributeDefinition currAttribute = EcoreUtil2.<AttributeDefinition>getContainerOfType(element, AttributeDefinition.class);
      currAttribute.setDefaultvalue(this.conf.createPrimitiveDefaultValue(currAttribute.getType()));
    };
    acceptor.accept(issue, "Change to matching default value", "Change to matching default value type.", "", _function);
  }
}
