/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.base.stateMachine;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.smartmdsd.ecore.base.stateMachine.StateMachine;
import org.eclipse.smartmdsd.ecore.base.stateMachine.StateMachinePackage;
import org.eclipse.smartmdsd.xtext.indexer.XtextResourceIndex;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class StateMachineDefaultLifecycleLib {
  @Inject
  private XtextResourceIndex index;
  
  public static final String COMPONENT_LIFECYCLE_PACKAGE = "componentLifecycle";
  
  public static final String COMPONENT_LIFECYCLE_LIBRARY = (StateMachineDefaultLifecycleLib.COMPONENT_LIFECYCLE_PACKAGE + "/ComponentLifecycle.automaton");
  
  public static final String COMPONENT_LIFECYCLE = "ComponentLifecycle";
  
  public static final String ALIVE_SIMPLE = "Alive";
  
  public static final String ALIVE_MAIN_STATE_COLLECTION = ((StateMachineDefaultLifecycleLib.COMPONENT_LIFECYCLE + ".") + StateMachineDefaultLifecycleLib.ALIVE_SIMPLE);
  
  public static final QualifiedName COMPONENT_LIFECYCLE_QNAME = QualifiedName.create(StateMachineDefaultLifecycleLib.COMPONENT_LIFECYCLE);
  
  public URI getPluginURI() {
    String _name = this.getClass().getPackage().getName();
    String _plus = (_name + "/");
    String _plus_1 = (_plus + StateMachineDefaultLifecycleLib.COMPONENT_LIFECYCLE_LIBRARY);
    return URI.createPlatformPluginURI(_plus_1, false);
  }
  
  public void loadLib(final ResourceSet resourceSet) {
    try {
      final URL url = this.getClass().getClassLoader().getResource(StateMachineDefaultLifecycleLib.COMPONENT_LIFECYCLE_LIBRARY);
      final InputStream stream = url.openStream();
      final URI path = URI.createURI(url.getPath());
      final Resource resource = resourceSet.createResource(path);
      resource.load(stream, resourceSet.getLoadOptions());
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public StateMachine getDefaultComponentLifecycleObject(final EObject context) {
    final EClass stateMachineClass = StateMachinePackage.eINSTANCE.getStateMachine();
    final Iterable<IEObjectDescription> descriptions = this.index.getVisibleEObjectDescriptions(context, stateMachineClass);
    final Function1<IEObjectDescription, Boolean> _function = (IEObjectDescription it) -> {
      String _string = it.getQualifiedName().toString();
      return Boolean.valueOf(Objects.equal(_string, StateMachineDefaultLifecycleLib.COMPONENT_LIFECYCLE));
    };
    final IEObjectDescription description = IterableExtensions.<IEObjectDescription>findFirst(descriptions, _function);
    if ((description == null)) {
      return null;
    }
    EObject object = description.getEObjectOrProxy();
    boolean _eIsProxy = object.eIsProxy();
    if (_eIsProxy) {
      object = context.eResource().getResourceSet().getEObject(description.getEObjectURI(), true);
    }
    return ((StateMachine) object);
  }
}
