/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.base.stateMachine.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.stateMachine.AbstractMachineElement;
import org.eclipse.smartmdsd.ecore.base.stateMachine.StateMachine;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;

@SuppressWarnings("all")
public class StateMachineFormatter extends AbstractFormatter2 {
  protected void _format(final StateMachine stateMachine, @Extension final IFormattableDocument document) {
    EList<AbstractMachineElement> _elements = stateMachine.getElements();
    for (final AbstractMachineElement abstractMachineElement : _elements) {
      document.<AbstractMachineElement>format(abstractMachineElement);
    }
  }
  
  public void format(final Object stateMachine, final IFormattableDocument document) {
    if (stateMachine instanceof XtextResource) {
      _format((XtextResource)stateMachine, document);
      return;
    } else if (stateMachine instanceof StateMachine) {
      _format((StateMachine)stateMachine, document);
      return;
    } else if (stateMachine instanceof EObject) {
      _format((EObject)stateMachine, document);
      return;
    } else if (stateMachine == null) {
      _format((Void)null, document);
      return;
    } else if (stateMachine != null) {
      _format(stateMachine, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(stateMachine, document).toString());
    }
  }
}
