/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.base.stateMachine.validation;

import org.eclipse.smartmdsd.ecore.base.stateMachine.StateMachinePackage;
import org.eclipse.smartmdsd.xtext.base.stateMachine.validation.AbstractStateMachineValidator;
import org.eclipse.xtext.validation.Check;

/**
 * This class contains custom validation rules.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#validation
 */
@SuppressWarnings("all")
public class StateMachineValidator extends AbstractStateMachineValidator {
  private static final String ISSUE = "org.eclipse.smartmdsd.xtext.base.stateMachine";
  
  private static final String STATE_UPPER = (StateMachineValidator.ISSUE + "MainStateUpper");
  
  @Check
  public void checkCapitalState(final org.eclipse.smartmdsd.ecore.base.stateMachine.State state) {
    boolean _isLowerCase = Character.isLowerCase(state.getName().charAt(0));
    if (_isLowerCase) {
      this.warning("State should start with a capital letter.", 
        StateMachinePackage.Literals.ABSTRACT_STATE_ELEMENT__NAME, 
        StateMachineValidator.STATE_UPPER);
    }
  }
}
