/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Matthias Lutz, Alex Lotz, Dennis Stampfer
 */
package org.eclipse.smartmdsd.xtext.behavior.skillRealization.scoping;

import com.google.common.base.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.smartmdsd.ecore.behavior.skillRealization.ComponentCoordinationActionActivation;
import org.eclipse.smartmdsd.ecore.behavior.skillRealization.ComponentCoordinationActionParameter;
import org.eclipse.smartmdsd.ecore.behavior.skillRealization.CoordinationInterfaceInstance;
import org.eclipse.smartmdsd.ecore.behavior.skillRealization.CoordinationModuleRealization;
import org.eclipse.smartmdsd.ecore.behavior.skillRealization.SkillRealizationPackage;
import org.eclipse.smartmdsd.xtext.behavior.skillRealization.scoping.AbstractSkillRealizationScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;

/**
 * This class contains custom scoping description.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 */
@SuppressWarnings("all")
public class SkillRealizationScopeProvider extends AbstractSkillRealizationScopeProvider {
  @Override
  public IScope getScope(final EObject context, final EReference reference) {
    EReference _skillRealization_SkillDef = SkillRealizationPackage.eINSTANCE.getSkillRealization_SkillDef();
    boolean _equals = Objects.equal(reference, _skillRealization_SkillDef);
    if (_equals) {
      final EObject parent = context.eContainer();
      if ((parent instanceof CoordinationModuleRealization)) {
        return Scopes.scopeFor(((CoordinationModuleRealization)parent).getCoordinationModuleDef().getSkills());
      }
    } else {
      EReference _componentCoordinationActionParameter_Parameter = SkillRealizationPackage.eINSTANCE.getComponentCoordinationActionParameter_Parameter();
      boolean _equals_1 = Objects.equal(reference, _componentCoordinationActionParameter_Parameter);
      if (_equals_1) {
        if ((context instanceof ComponentCoordinationActionParameter)) {
          CoordinationInterfaceInstance _coordinationService = ((ComponentCoordinationActionParameter)context).getCoordinationService();
          boolean _tripleNotEquals = (_coordinationService != null);
          if (_tripleNotEquals) {
            return Scopes.scopeFor(((ComponentCoordinationActionParameter)context).getCoordinationService().getCoordinationInterfaceDef().getParameterPattern().getParameterSet().getParameters());
          } else {
            return IScope.NULLSCOPE;
          }
        }
      } else {
        EReference _componentCoordinationActionActivation_State = SkillRealizationPackage.eINSTANCE.getComponentCoordinationActionActivation_State();
        boolean _equals_2 = Objects.equal(reference, _componentCoordinationActionActivation_State);
        if (_equals_2) {
          if ((context instanceof ComponentCoordinationActionActivation)) {
            CoordinationInterfaceInstance _coordinationService_1 = ((ComponentCoordinationActionActivation)context).getCoordinationService();
            boolean _tripleNotEquals_1 = (_coordinationService_1 != null);
            if (_tripleNotEquals_1) {
              return Scopes.scopeFor(((ComponentCoordinationActionActivation)context).getCoordinationService().getCoordinationInterfaceDef().getStatePattern().getModes().getModes());
            } else {
              return IScope.NULLSCOPE;
            }
          }
        } else {
          return super.getScope(context, reference);
        }
      }
    }
    return IScope.NULLSCOPE;
  }
}
