/********************************************************************************
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Matthias Lutz, Alex Lotz, Dennis Stampfer
 ********************************************************************************/
package org.eclipse.smartmdsd.xtext.behavior.taskDefinition.parser.antlr;

import com.google.inject.Inject;
import org.eclipse.smartmdsd.xtext.behavior.taskDefinition.parser.antlr.internal.InternalTaskDefinitionParser;
import org.eclipse.smartmdsd.xtext.behavior.taskDefinition.services.TaskDefinitionGrammarAccess;
import org.eclipse.xtext.parser.antlr.AbstractAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;

public class TaskDefinitionParser extends AbstractAntlrParser {

	@Inject
	private TaskDefinitionGrammarAccess grammarAccess;

	@Override
	protected void setInitialHiddenTokens(XtextTokenStream tokenStream) {
		tokenStream.setInitialHiddenTokens("RULE_WS", "RULE_ML_COMMENT", "RULE_SL_COMMENT");
	}
	

	@Override
	protected InternalTaskDefinitionParser createParser(XtextTokenStream stream) {
		return new InternalTaskDefinitionParser(stream, getGrammarAccess());
	}

	@Override 
	protected String getDefaultRuleName() {
		return "TaskDefinitionModel";
	}

	public TaskDefinitionGrammarAccess getGrammarAccess() {
		return this.grammarAccess;
	}

	public void setGrammarAccess(TaskDefinitionGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}
}
