/********************************************************************************
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Matthias Lutz, Alex Lotz, Dennis Stampfer
 ********************************************************************************/
package org.eclipse.smartmdsd.xtext.behavior.taskRealization.parser.antlr;

import com.google.inject.Inject;
import org.eclipse.smartmdsd.xtext.behavior.taskRealization.parser.antlr.internal.InternalTaskRealizationParser;
import org.eclipse.smartmdsd.xtext.behavior.taskRealization.services.TaskRealizationGrammarAccess;
import org.eclipse.xtext.parser.antlr.AbstractAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;

public class TaskRealizationParser extends AbstractAntlrParser {

	@Inject
	private TaskRealizationGrammarAccess grammarAccess;

	@Override
	protected void setInitialHiddenTokens(XtextTokenStream tokenStream) {
		tokenStream.setInitialHiddenTokens("RULE_WS", "RULE_ML_COMMENT", "RULE_SL_COMMENT");
	}
	

	@Override
	protected InternalTaskRealizationParser createParser(XtextTokenStream stream) {
		return new InternalTaskRealizationParser(stream, getGrammarAccess());
	}

	@Override 
	protected String getDefaultRuleName() {
		return "TaskRealizationModel";
	}

	public TaskRealizationGrammarAccess getGrammarAccess() {
		return this.grammarAccess;
	}

	public void setGrammarAccess(TaskRealizationGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}
}
