/**
 * Copyright (c) 2019 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.component.componentDatasheet.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.AbstractDatasheetElement;
import org.eclipse.smartmdsd.ecore.base.genericDatasheet.DatasheetProperty;
import org.eclipse.smartmdsd.ecore.component.componentDatasheet.ComponentDatasheet;
import org.eclipse.smartmdsd.ecore.component.componentDatasheet.ComponentPortDatasheet;
import org.eclipse.smartmdsd.xtext.base.genericDatasheet.formatting2.GenericDatasheetFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class ComponentDatasheetFormatter extends GenericDatasheetFormatter {
  protected void _format(final ComponentDatasheet componentDatasheet, @Extension final IFormattableDocument document) {
    final ISemanticRegion ropen = this.textRegionExtensions.regionFor(componentDatasheet).keyword("{");
    final ISemanticRegion rclose = this.textRegionExtensions.regionFor(componentDatasheet).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(ropen, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(ropen, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(ropen, rclose, _function_2);
    final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(rclose, _function_3);
    EList<AbstractDatasheetElement> _elements = componentDatasheet.getElements();
    for (final AbstractDatasheetElement element : _elements) {
      document.<AbstractDatasheetElement>format(element);
    }
  }
  
  protected void _format(final ComponentPortDatasheet componentPortDatasheet, @Extension final IFormattableDocument document) {
    final ISemanticRegion ropen = this.textRegionExtensions.regionFor(componentPortDatasheet).keyword("{");
    final ISemanticRegion rclose = this.textRegionExtensions.regionFor(componentPortDatasheet).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(ropen, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(ropen, rclose, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(rclose, _function_2);
  }
  
  public void format(final Object componentDatasheet, final IFormattableDocument document) {
    if (componentDatasheet instanceof XtextResource) {
      _format((XtextResource)componentDatasheet, document);
      return;
    } else if (componentDatasheet instanceof DatasheetProperty) {
      _format((DatasheetProperty)componentDatasheet, document);
      return;
    } else if (componentDatasheet instanceof ComponentDatasheet) {
      _format((ComponentDatasheet)componentDatasheet, document);
      return;
    } else if (componentDatasheet instanceof ComponentPortDatasheet) {
      _format((ComponentPortDatasheet)componentDatasheet, document);
      return;
    } else if (componentDatasheet instanceof EObject) {
      _format((EObject)componentDatasheet, document);
      return;
    } else if (componentDatasheet == null) {
      _format((Void)null, document);
      return;
    } else if (componentDatasheet != null) {
      _format(componentDatasheet, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(componentDatasheet, document).toString());
    }
  }
}
