/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.component.componentDefinition;

import java.util.List;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionPackage;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentSubNodeObserver;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.InputPortLink;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.RequestPortLink;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterPackage;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParametersRef;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationExtensionPackage;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.OperationModeBinding;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.PublicOperationMode;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.MixedPortROS;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.MixedPortROSLink;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.MixedPortYARP;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.OpcUaClientLink;
import org.eclipse.smartmdsd.ecore.component.seronetExtension.SeronetExtensionPackage;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

@SuppressWarnings("all")
public class ComponentDefinitionQNameProvider extends DefaultDeclarativeQualifiedNameProvider {
  public QualifiedName qualifiedName(final InputPortLink link) {
    final QualifiedName parent = super.getFullyQualifiedName(link.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(link, ComponentDefinitionPackage.Literals.INPUT_PORT_LINK__INPUT_PORT);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = link.eIsSet(ComponentDefinitionPackage.Literals.INPUT_PORT_LINK__INPUT_PORT);
      if (_eIsSet) {
        return parent.append(link.getInputPort().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final RequestPortLink link) {
    final QualifiedName parent = super.getFullyQualifiedName(link.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(link, ComponentDefinitionPackage.Literals.REQUEST_PORT_LINK__REQUEST_PORT);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = link.eIsSet(ComponentDefinitionPackage.Literals.REQUEST_PORT_LINK__REQUEST_PORT);
      if (_eIsSet) {
        return parent.append(link.getRequestPort().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final ComponentSubNodeObserver observer) {
    final QualifiedName parent = super.getFullyQualifiedName(observer.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(observer, ComponentDefinitionPackage.Literals.COMPONENT_SUB_NODE_OBSERVER__SUBJECT);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = observer.eIsSet(ComponentDefinitionPackage.Literals.COMPONENT_SUB_NODE_OBSERVER__SUBJECT);
      if (_eIsSet) {
        return parent.append(observer.getSubject().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final OperationModeBinding state) {
    final QualifiedName parent = super.getFullyQualifiedName(state.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(state, CoordinationExtensionPackage.Literals.OPERATION_MODE_BINDING__MODE);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = state.eIsSet(CoordinationExtensionPackage.Literals.OPERATION_MODE_BINDING__MODE);
      if (_eIsSet) {
        return parent.append(state.getMode().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final PublicOperationMode state) {
    final QualifiedName parent = super.getFullyQualifiedName(state.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(state, CoordinationExtensionPackage.Literals.PUBLIC_OPERATION_MODE__MODE);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = state.eIsSet(CoordinationExtensionPackage.Literals.PUBLIC_OPERATION_MODE__MODE);
      if (_eIsSet) {
        return parent.append(state.getMode().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final ComponentParametersRef params) {
    final QualifiedName parent = super.getFullyQualifiedName(params.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(params, ComponentParameterPackage.Literals.COMPONENT_PARAMETERS_REF__PARAMETER);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = params.eIsSet(ComponentParameterPackage.Literals.COMPONENT_PARAMETERS_REF__PARAMETER);
      if (_eIsSet) {
        return parent.append(params.getParameter().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final OpcUaClientLink link) {
    final QualifiedName parent = super.getFullyQualifiedName(link.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(link, SeronetExtensionPackage.Literals.OPC_UA_CLIENT_LINK__CLIENT);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = link.eIsSet(SeronetExtensionPackage.Literals.OPC_UA_CLIENT_LINK__CLIENT);
      if (_eIsSet) {
        return parent.append(link.getClient().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final MixedPortROS mixedport) {
    final QualifiedName parent = super.getFullyQualifiedName(mixedport.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(mixedport, SeronetExtensionPackage.Literals.MIXED_PORT_ROS__PORT);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = mixedport.eIsSet(SeronetExtensionPackage.Literals.MIXED_PORT_ROS__PORT);
      if (_eIsSet) {
        return parent.append(mixedport.getPort().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final MixedPortROSLink link) {
    final QualifiedName parent = super.getFullyQualifiedName(link.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(link, SeronetExtensionPackage.Literals.MIXED_PORT_ROS_LINK__MIXEDPORTROS);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = link.eIsSet(SeronetExtensionPackage.Literals.MIXED_PORT_ROS_LINK__MIXEDPORTROS);
      if (_eIsSet) {
        return parent.append(link.getMixedportros().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final MixedPortYARP mixedport) {
    final QualifiedName parent = super.getFullyQualifiedName(mixedport.eContainer());
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(mixedport, SeronetExtensionPackage.Literals.MIXED_PORT_YARP__PORT);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      return parent.append(NodeModelUtils.getTokenText(nodes.get(0)));
    } else {
      boolean _eIsSet = mixedport.eIsSet(SeronetExtensionPackage.Literals.MIXED_PORT_YARP__PORT);
      if (_eIsSet) {
        return parent.append(mixedport.getPort().getName());
      }
    }
    return QualifiedName.EMPTY;
  }
}
