/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.component.componentDefinition;

import com.google.inject.Injector;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.ComponentDefinitionPackage;
import org.eclipse.smartmdsd.ecore.component.coordinationExtension.CoordinationExtensionPackage;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.PerformanceExtensionPackage;
import org.eclipse.smartmdsd.xtext.component.componentDefinition.ComponentDefinitionStandaloneSetupGenerated;

/**
 * Initialization support for running Xtext languages without Equinox extension registry.
 */
@SuppressWarnings("all")
public class ComponentDefinitionStandaloneSetup extends ComponentDefinitionStandaloneSetupGenerated {
  public static void doSetup() {
    new ComponentDefinitionStandaloneSetup().createInjectorAndDoEMFRegistration();
  }
  
  @Override
  public void register(final Injector injector) {
    boolean _containsKey = EPackage.Registry.INSTANCE.containsKey(ComponentDefinitionPackage.eNS_URI);
    boolean _not = (!_containsKey);
    if (_not) {
      EPackage.Registry.INSTANCE.put(
        ComponentDefinitionPackage.eNS_URI, 
        ComponentDefinitionPackage.eINSTANCE);
    }
    boolean _containsKey_1 = EPackage.Registry.INSTANCE.containsKey(PerformanceExtensionPackage.eNS_URI);
    boolean _not_1 = (!_containsKey_1);
    if (_not_1) {
      EPackage.Registry.INSTANCE.put(
        PerformanceExtensionPackage.eNS_URI, 
        PerformanceExtensionPackage.eINSTANCE);
    }
    boolean _containsKey_2 = EPackage.Registry.INSTANCE.containsKey(CoordinationExtensionPackage.eNS_URI);
    boolean _not_2 = (!_containsKey_2);
    if (_not_2) {
      EPackage.Registry.INSTANCE.put(
        CoordinationExtensionPackage.eNS_URI, 
        CoordinationExtensionPackage.eINSTANCE);
    }
    super.register(injector);
  }
}
