/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.component.componentDefinition.ui.contentassist;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.component.componentDefinition.Activity;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.ActivationConstraints;
import org.eclipse.smartmdsd.ecore.component.performanceExtension.DefaultPeriodicTimer;
import org.eclipse.smartmdsd.ecore.service.serviceDefinition.ServiceDefinitionPackage;
import org.eclipse.smartmdsd.xtext.component.componentDefinition.ui.contentassist.AbstractComponentDefinitionProposalProvider;
import org.eclipse.smartmdsd.xtext.indexer.XtextResourceIndex;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

/**
 * See https://www.eclipse.org/Xtext/documentation/304_ide_concepts.html#content-assist
 * on how to customize the content assistant.
 */
@SuppressWarnings("all")
public class ComponentDefinitionProposalProvider extends AbstractComponentDefinitionProposalProvider {
  @Inject
  private XtextResourceIndex index;
  
  @Override
  public void completeComponentDefinition_Name(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    final URI uri = model.eResource().getURI();
    boolean _isPlatform = uri.isPlatform();
    if (_isPlatform) {
      final String projectName = uri.segment(1);
      acceptor.accept(this.createCompletionProposal(projectName, (projectName + " - ProjectName"), this.getImage(model), context));
    }
  }
  
  @Override
  public void completeServiceRepoImport_ImportedNamespace(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    final Iterable<IEObjectDescription> repos = this.index.getVisibleEObjectDescriptions(model, ServiceDefinitionPackage.eINSTANCE.getServiceDefRepository());
    final Consumer<IEObjectDescription> _function = (IEObjectDescription repo) -> {
      final String name = repo.getName().toString();
      final String text = (name + ".*;");
      acceptor.accept(this.createCompletionProposal(text, (name + " - ServiceRepositoryImport"), this.getImage(repo), context));
    };
    repos.forEach(_function);
  }
  
  @Override
  public void completeDefaultPeriodicTimer_PeriodicActFreq(final EObject model, final Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
    super.completeDefaultPeriodicTimer_PeriodicActFreq(model, assignment, context, acceptor);
    if ((model instanceof DefaultPeriodicTimer)) {
      final EObject parent = ((DefaultPeriodicTimer)model).eContainer();
      if ((parent instanceof Activity)) {
        Iterable<ActivationConstraints> _filter = Iterables.<ActivationConstraints>filter(((Activity)parent).getExtensions(), ActivationConstraints.class);
        for (final ActivationConstraints ac : _filter) {
          {
            double _minActFreq = ac.getMinActFreq();
            boolean _greaterThan = (_minActFreq > 0.0);
            if (_greaterThan) {
              String _string = Double.valueOf(ac.getMinActFreq()).toString();
              String _plus = (_string + " Hz");
              acceptor.accept(this.createCompletionProposal(_plus, context));
            }
            double _maxActFreq = ac.getMaxActFreq();
            boolean _greaterThan_1 = (_maxActFreq > 0.0);
            if (_greaterThan_1) {
              String _string_1 = Double.valueOf(ac.getMaxActFreq()).toString();
              String _plus_1 = (_string_1 + " Hz");
              acceptor.accept(this.createCompletionProposal(_plus_1, context));
            }
          }
        }
      }
    } else {
      acceptor.accept(this.createCompletionProposal("10.0 Hz", context));
    }
  }
}
