/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.component.componentParameter;

import java.util.List;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterPackage;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterInstance;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterSetInstance;
import org.eclipse.smartmdsd.ecore.component.componentParameter.TriggerInstance;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

@SuppressWarnings("all")
public class ComponentParameterQNameProvider extends DefaultDeclarativeQualifiedNameProvider {
  public QualifiedName qualifiedName(final ParameterSetInstance paramSet) {
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(paramSet, ComponentParameterPackage.Literals.PARAMETER_SET_INSTANCE__PARAM_SET);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      final String refname = NodeModelUtils.getTokenText(nodes.get(0));
      final QualifiedName parent = super.getFullyQualifiedName(paramSet.eContainer());
      return parent.append(refname);
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final ParameterInstance param) {
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(param, ComponentParameterPackage.Literals.PARAMETER_INSTANCE__PARAMETER_DEF);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      final String refname = NodeModelUtils.getTokenText(nodes.get(0));
      final QualifiedName parent = super.getFullyQualifiedName(param.eContainer());
      return parent.append(refname);
    }
    return QualifiedName.EMPTY;
  }
  
  public QualifiedName qualifiedName(final TriggerInstance param) {
    final List<INode> nodes = NodeModelUtils.findNodesForFeature(param, ComponentParameterPackage.Literals.TRIGGER_INSTANCE__TRIGGER_DEF);
    boolean _isEmpty = nodes.isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      final String refname = NodeModelUtils.getTokenText(nodes.get(0));
      final QualifiedName parent = super.getFullyQualifiedName(param.eContainer());
      return parent.append(refname);
    }
    return QualifiedName.EMPTY;
  }
}
