/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.component.componentParameter.scoping;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesPackage;
import org.eclipse.smartmdsd.ecore.component.componentParameter.AbstractParameterInstance;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterPackage;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterInstance;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterSetInstance;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.ParameterDefinition;
import org.eclipse.smartmdsd.ecore.service.parameterDefinition.TriggerDefinition;
import org.eclipse.smartmdsd.xtext.component.componentParameter.scoping.AbstractComponentParameterScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;

/**
 * This class contains custom scoping description.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 */
@SuppressWarnings("all")
public class ComponentParameterScopeProvider extends AbstractComponentParameterScopeProvider {
  @Inject
  private ComponentParameterModelUtility util;
  
  @Override
  public IScope getScope(final EObject context, final EReference reference) {
    EReference _triggerInstance_TriggerDef = ComponentParameterPackage.eINSTANCE.getTriggerInstance_TriggerDef();
    boolean _equals = Objects.equal(reference, _triggerInstance_TriggerDef);
    if (_equals) {
      final EObject parent = context.eContainer();
      if ((parent instanceof ParameterSetInstance)) {
        return Scopes.scopeFor(Iterables.<TriggerDefinition>filter(((ParameterSetInstance)parent).getParamSet().getParameters(), TriggerDefinition.class));
      }
    } else {
      EReference _parameterInstance_ParameterDef = ComponentParameterPackage.eINSTANCE.getParameterInstance_ParameterDef();
      boolean _equals_1 = Objects.equal(reference, _parameterInstance_ParameterDef);
      if (_equals_1) {
        final EObject parent_1 = context.eContainer();
        if ((parent_1 instanceof ParameterSetInstance)) {
          return Scopes.scopeFor(Iterables.<ParameterDefinition>filter(((ParameterSetInstance)parent_1).getParamSet().getParameters(), ParameterDefinition.class));
        }
      } else {
        EReference _parameterInstance_Attributes = ComponentParameterPackage.eINSTANCE.getParameterInstance_Attributes();
        boolean _equals_2 = Objects.equal(reference, _parameterInstance_Attributes);
        if (_equals_2) {
          if ((context instanceof ParameterInstance)) {
            ParameterDefinition _parameterDef = ((ParameterInstance)context).getParameterDef();
            EList<AttributeDefinition> _attributes = null;
            if (_parameterDef!=null) {
              _attributes=_parameterDef.getAttributes();
            }
            return Scopes.scopeFor(_attributes);
          }
        } else {
          EReference _attributeRefinement_Attribute = BasicAttributesPackage.eINSTANCE.getAttributeRefinement_Attribute();
          boolean _equals_3 = Objects.equal(reference, _attributeRefinement_Attribute);
          if (_equals_3) {
            if ((context instanceof ParameterInstance)) {
              return Scopes.scopeFor(this.util.getReferencedAttributes(((AbstractParameterInstance)context)));
            } else {
              final EObject parent_2 = context.eContainer();
              if ((parent_2 instanceof ParameterInstance)) {
                return Scopes.scopeFor(this.util.getReferencedAttributes(((AbstractParameterInstance)parent_2)));
              }
            }
          } else {
            return super.getScope(context, reference);
          }
        }
      }
    }
    return IScope.NULLSCOPE;
  }
}
