/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.component.componentParameter.ui.quickfix;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AbstractValue;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesFactory;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.BasicAttributesModelUtility;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameter;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ComponentParameterTypeConformance;
import org.eclipse.smartmdsd.ecore.component.componentParameter.ParameterInstance;
import org.eclipse.smartmdsd.xtext.component.componentParameter.validation.ComponentParameterValidator;
import org.eclipse.smartmdsd.xtext.service.parameterDefinition.ui.quickfix.ParameterDefinitionQuickfixProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Custom quickfixes.
 * 
 * See https://www.eclipse.org/Xtext/documentation/310_eclipse_support.html#quick-fixes
 */
@SuppressWarnings("all")
public class ComponentParameterQuickfixProvider extends ParameterDefinitionQuickfixProvider {
  @Inject
  private ComponentParameterTypeConformance conf;
  
  @Inject
  private BasicAttributesModelUtility util;
  
  @Fix(ComponentParameterValidator.MISSING_ATTRIBUTE_REFINEMENTS)
  public void addMissingAttributeRefinements(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      final ParameterInstance param = ((ParameterInstance) element);
      final Consumer<AttributeDefinition> _function_1 = (AttributeDefinition attribute) -> {
        final Function1<AttributeRefinement, Boolean> _function_2 = (AttributeRefinement ref) -> {
          return Boolean.valueOf(ref.getAttribute().equals(attribute));
        };
        boolean _exists = IterableExtensions.<AttributeRefinement>exists(param.getAttributes(), _function_2);
        boolean _not = (!_exists);
        if (_not) {
          final AttributeRefinement attrRef = BasicAttributesFactory.eINSTANCE.createAttributeRefinement();
          attrRef.setAttribute(attribute);
          AbstractValue _defaultvalue = attribute.getDefaultvalue();
          boolean _tripleNotEquals = (_defaultvalue != null);
          if (_tripleNotEquals) {
            attrRef.setValue(attribute.getDefaultvalue());
          } else {
            attrRef.setValue(this.conf.createPrimitiveDefaultValue(attribute.getType()));
          }
          param.getAttributes().add(attrRef);
        }
      };
      param.getParameterDef().getAttributes().forEach(_function_1);
    };
    acceptor.accept(issue, "Add missing attribute-refinements", "Add missing attribute-refinements.", "", _function);
    final IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
    if ((editor instanceof XtextEditor)) {
      ISourceViewer _internalSourceViewer = ((XtextEditor)editor).getInternalSourceViewer();
      ((SourceViewer) _internalSourceViewer).doOperation(ISourceViewer.FORMAT);
    }
  }
  
  @Fix(ComponentParameterValidator.SINGLE_PARAM_SET_INSTANCE)
  public void fixMultipleParamSetInstances(final Issue issue, final IssueResolutionAcceptor acceptor) {
    String _get = issue.getData()[0];
    String _plus = ("Remove ParameterSetInstance \"" + _get);
    String _plus_1 = (_plus + "\".");
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      EObject _eContainer = element.eContainer();
      final ComponentParameter param = ((ComponentParameter) _eContainer);
      param.getParameters().remove(element);
    };
    acceptor.accept(issue, "Remove ParameterSetInstance", _plus_1, 
      "", _function);
  }
  
  @Fix(ComponentParameterValidator.PARAM_SET_INSTANCE_MATCH_BEHAVIOR_INTERFACE)
  public void fixParameterSetInstanceMatchComponentBehaviorSlaveInterface(final Issue issue, final IssueResolutionAcceptor acceptor) {
    String _get = issue.getData()[0];
    String _plus = ("Change ParameterSetInstance to \"" + _get);
    String _plus_1 = (_plus + "\".");
    String _get_1 = issue.getData()[0];
    String _plus_2 = ("Change ParameterSetInstance to \"" + _get_1);
    String _plus_3 = (_plus_2 + "\".");
    final IModification _function = (IModificationContext context) -> {
      final IXtextDocument doc = context.getXtextDocument();
      doc.replace((issue.getOffset()).intValue(), (issue.getLength()).intValue(), issue.getData()[0]);
    };
    acceptor.accept(issue, _plus_1, _plus_3, 
      "", _function);
  }
  
  @Fix(ComponentParameterValidator.MISSING_ATTRIBUTE_VALUE)
  public void fixMisingAttributeValue(final Issue issue, final IssueResolutionAcceptor acceptor) {
    final ISemanticModification _function = (EObject element, IModificationContext context) -> {
      final IXtextDocument doc = context.getXtextDocument();
      final AttributeDefinition attr = ((AttributeDefinition) element);
      Integer _offset = issue.getOffset();
      Integer _length = issue.getLength();
      int _plus = ((_offset).intValue() + (_length).intValue());
      String _get = ((String[])Conversions.unwrapArray(this.util.getDefaultValuesFor(attr.getType()), String.class))[0];
      String _plus_1 = (" = " + _get);
      String _plus_2 = (_plus_1 + "\n");
      doc.replace(_plus, 1, _plus_2);
    };
    acceptor.accept(issue, "Add default attribute value", 
      "Add default attribute value", 
      "", _function);
  }
}
