/**
 * Copyright (c) 2017 Technische Hochschule Ulm, Servicerobotics Ulm, Germany
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *   Alex Lotz, Dennis Stampfer, Matthias Lutz
 */
package org.eclipse.smartmdsd.xtext.service.communicationObject.formatting2;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeDefinition;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.AttributeRefinement;
import org.eclipse.smartmdsd.ecore.base.basicAttributes.InlineEnumerationType;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectModel;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommRepositoryImport;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObjectPackage;
import org.eclipse.smartmdsd.ecore.service.communicationObject.Version;
import org.eclipse.smartmdsd.xtext.base.basicAttributes.formatting2.BasicAttributesFormatter;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class CommunicationObjectFormatter extends BasicAttributesFormatter {
  protected void _format(final CommObjectModel commObjectModel, @Extension final IFormattableDocument document) {
    EList<CommRepositoryImport> _imports = commObjectModel.getImports();
    for (final CommRepositoryImport commRepositoryImport : _imports) {
      {
        document.<CommRepositoryImport>format(commRepositoryImport);
        final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
          it.newLine();
        };
        document.<CommRepositoryImport>append(commRepositoryImport, _function);
      }
    }
    CommObjectsRepository _repository = commObjectModel.getRepository();
    if (_repository!=null) {
      document.<CommObjectsRepository>format(_repository);
    }
  }
  
  protected void _format(final CommObjectsRepository commObjectsRepository, @Extension final IFormattableDocument document) {
    document.<Version>format(commObjectsRepository.getVersion());
    final ISemanticRegion ropen = this.textRegionExtensions.regionFor(commObjectsRepository).keyword("{");
    final ISemanticRegion rclose = this.textRegionExtensions.regionFor(commObjectsRepository).keyword("}");
    final Procedure1<IHiddenRegionFormatter> _function = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.prepend(ropen, _function);
    final Procedure1<IHiddenRegionFormatter> _function_1 = (IHiddenRegionFormatter it) -> {
      it.newLine();
    };
    document.append(ropen, _function_1);
    final Procedure1<IHiddenRegionFormatter> _function_2 = (IHiddenRegionFormatter it) -> {
      it.indent();
    };
    document.<ISemanticRegion, ISemanticRegion>interior(ropen, rclose, _function_2);
    EList<AbstractCommElement> _elements = commObjectsRepository.getElements();
    for (final AbstractCommElement abstractCommElement : _elements) {
      {
        document.<AbstractCommElement>format(abstractCommElement);
        final Procedure1<IHiddenRegionFormatter> _function_3 = (IHiddenRegionFormatter it) -> {
          it.oneSpace();
        };
        document.surround(this.textRegionExtensions.regionFor(abstractCommElement).feature(CommunicationObjectPackage.Literals.ABSTRACT_COMM_ELEMENT__NAME), _function_3);
        final Procedure1<IHiddenRegionFormatter> _function_4 = (IHiddenRegionFormatter it) -> {
          it.setNewLines(1, 1, 2);
        };
        document.<AbstractCommElement>append(abstractCommElement, _function_4);
        final ISemanticRegion open = this.textRegionExtensions.regionFor(abstractCommElement).keyword("{");
        final ISemanticRegion close = this.textRegionExtensions.regionFor(abstractCommElement).keyword("}");
        final Procedure1<IHiddenRegionFormatter> _function_5 = (IHiddenRegionFormatter it) -> {
          it.newLine();
        };
        document.append(open, _function_5);
        final Procedure1<IHiddenRegionFormatter> _function_6 = (IHiddenRegionFormatter it) -> {
          it.indent();
        };
        document.<ISemanticRegion, ISemanticRegion>interior(open, close, _function_6);
      }
    }
  }
  
  public void format(final Object commObjectsRepository, final IFormattableDocument document) {
    if (commObjectsRepository instanceof XtextResource) {
      _format((XtextResource)commObjectsRepository, document);
      return;
    } else if (commObjectsRepository instanceof AttributeDefinition) {
      _format((AttributeDefinition)commObjectsRepository, document);
      return;
    } else if (commObjectsRepository instanceof AttributeRefinement) {
      _format((AttributeRefinement)commObjectsRepository, document);
      return;
    } else if (commObjectsRepository instanceof InlineEnumerationType) {
      _format((InlineEnumerationType)commObjectsRepository, document);
      return;
    } else if (commObjectsRepository instanceof CommObjectsRepository) {
      _format((CommObjectsRepository)commObjectsRepository, document);
      return;
    } else if (commObjectsRepository instanceof CommObjectModel) {
      _format((CommObjectModel)commObjectsRepository, document);
      return;
    } else if (commObjectsRepository instanceof EObject) {
      _format((EObject)commObjectsRepository, document);
      return;
    } else if (commObjectsRepository == null) {
      _format((Void)null, document);
      return;
    } else if (commObjectsRepository != null) {
      _format(commObjectsRepository, document);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(commObjectsRepository, document).toString());
    }
  }
}
