/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smartmdsd.xtext.service.communicationObject.ui.quickfix;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smartmdsd.ecore.service.communicationObject.AbstractCommElement;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommObjectsRepository;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObject;
import org.eclipse.smartmdsd.ecore.service.communicationObject.CommunicationObjectFactory;
import org.eclipse.smartmdsd.xtext.base.basicAttributes.ui.quickfix.BasicAttributesQuickfixProvider;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class CommunicationObjectQuickfixProvider
extends BasicAttributesQuickfixProvider {
    @Fix(value="org.xtext.service.communicationObject.InvalidRepoName")
    public void repoName(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> ((CommObjectsRepository)element).setName(issue.getData()[0]);
        acceptor.accept(issue, "Fix repository name to match project name", "Repository name will be set to project name", "", _function);
    }

    @Fix(value="org.xtext.service.communicationObject.CapitalCommElementName")
    public void capitalizeName(Issue issue, IssueResolutionAcceptor acceptor) {
        IModification _function = context -> {
            IXtextDocument xtextDocument = context.getXtextDocument();
            String firstLetter = xtextDocument.get(issue.getOffset().intValue(), 1);
            xtextDocument.replace(issue.getOffset().intValue(), 1, firstLetter.toUpperCase());
        };
        acceptor.accept(issue, "Capitalize name", "Capitalize the name.", "", _function);
    }

    @Fix(value="org.eclipse.xtext.diagnostics.Diagnostic.Linking")
    public void createMissingCommObject(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification _function = (element, context) -> {
            AbstractCommElement currEntity = (AbstractCommElement)EcoreUtil2.getContainerOfType((EObject)element, AbstractCommElement.class);
            EObject _eContainer = currEntity.eContainer();
            CommObjectsRepository model = (CommObjectsRepository)_eContainer;
            EList _elements = model.getElements();
            int _indexOf = model.getElements().indexOf((Object)currEntity);
            int _plus = _indexOf + 1;
            CommunicationObject _createCommunicationObject = CommunicationObjectFactory.eINSTANCE.createCommunicationObject();
            Procedures.Procedure1 _function_1 = it -> {
                try {
                    it.setName(context.getXtextDocument().get(issue.getOffset().intValue(), issue.getLength().intValue()));
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            };
            CommunicationObject _doubleArrow = (CommunicationObject)ObjectExtensions.operator_doubleArrow((Object)_createCommunicationObject, (Procedures.Procedure1)_function_1);
            _elements.add(_plus, (Object)_doubleArrow);
        };
        acceptor.accept(issue, "Create missing CommunicationObject", "Create missing CommunicationObject", "", _function);
    }
}

